/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.profile.server.core.internal.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tptp.platform.profile.server.core.internal.reflect.LinkageException;

public class EclipseClass {
    public static Class findClass(String bundleId, String classId) throws LinkageException {
        try {
            return Platform.getBundle((String)bundleId).loadClass(classId);
        }
        catch (Throwable throwable) {
            throw new LinkageException();
        }
    }

    public static Object newInstance(String bundleId, String classId, Class[] signature, Object[] arguments) throws LinkageException {
        Class foreignClass = EclipseClass.findClass(bundleId, classId);
        try {
            Constructor constructor = foreignClass.getConstructor(signature);
            constructor.setAccessible(true);
            return constructor.newInstance(arguments);
        }
        catch (Throwable throwable) {
            throw new LinkageException();
        }
    }

    public static Object invoke(Object object, String methodId, Class[] signature, Object[] arguments) throws LinkageException {
        try {
            Method method = object.getClass().getMethod(methodId, signature);
            method.setAccessible(true);
            return method.invoke(object, arguments);
        }
        catch (Throwable throwable) {
            throw new LinkageException();
        }
    }

    public static Object invokeStatic(Class clazz, String methodId, Class[] signature, Object[] arguments) throws LinkageException {
        try {
            Method method = clazz.getMethod(methodId, signature);
            method.setAccessible(true);
            return method.invoke((Object)clazz, arguments);
        }
        catch (Throwable throwable) {
            throw new LinkageException();
        }
    }
}

