/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.operation;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.util.ArtifactEditRegistryReader;
import org.eclipse.wst.common.componentcore.internal.util.IArtifactEditFactory;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchContext;

public abstract class ArtifactEditProviderOperation
extends AbstractDataModelOperation {
    protected ArtifactEdit artifactEdit;
    protected EMFWorkbenchContext emfWorkbenchContext;

    public ArtifactEditProviderOperation() {
    }

    public ArtifactEditProviderOperation(IDataModel model) {
        super(model);
    }

    protected final void initialize(IProgressMonitor monitor) {
        this.emfWorkbenchContext = (EMFWorkbenchContext)WorkbenchResourceHelperBase.createEMFContext((IProject)this.getTargetProject(), null);
        IVirtualComponent component = this.getTargetComponent();
        this.artifactEdit = this.getArtifactEditForModule(component);
        this.doInitialize(monitor);
    }

    public IProject getTargetProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        return ProjectUtilities.getProject((String)projectName);
    }

    public IVirtualComponent getTargetComponent() {
        return ComponentCore.createComponent(this.getTargetProject());
    }

    private void doInitialize(IProgressMonitor monitor) {
    }

    protected ArtifactEdit getArtifactEditForModule(IVirtualComponent comp) {
        ArtifactEditRegistryReader reader = ArtifactEditRegistryReader.instance();
        IArtifactEditFactory factory = reader.getArtifactEdit(comp.getProject());
        if (factory == null) {
            return null;
        }
        return factory.createArtifactEditForWrite(comp);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public void dispose() {
        if (this.artifactEdit != null) {
            this.artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
            this.artifactEdit.dispose();
        }
        super.dispose();
    }

    public final IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            this.initialize(monitor);
            IStatus iStatus = this.doExecute(monitor, info);
            Object var3_4 = null;
            this.dispose();
            return iStatus;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.dispose();
            throw throwable;
        }
    }

    public abstract IStatus doExecute(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    public ArtifactEdit getArtifactEdit() {
        return this.artifactEdit;
    }
}

