/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.operation;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IComponentCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public abstract class ComponentCreationDataModelProvider
extends AbstractDataModelProvider
implements IComponentCreationDataModelProperties {
    public void init() {
        super.init();
        this.initProjectCreationModel();
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IComponentCreationDataModelProperties.PROJECT_NAME");
        propertyNames.add("IComponentCreationDataModelProperties.NESTED_PROJECT_CREATION_DM");
        propertyNames.add("IComponentCreationDataModelProperties.COMPONENT_NAME");
        propertyNames.add("IComponentCreationDataModelProperties.COMPONENT_NAME");
        propertyNames.add("IFlexibleProjectCreationDataModelProperties.LOCATION");
        propertyNames.add("IComponentCreationDataModelProperties.COMPONENT_DEPLOY_NAME");
        propertyNames.add("IComponentCreationDataModelProperties.CREATE_DEFAULT_FILES");
        propertyNames.add("IComponentCreationDataModelProperties.COMPONENT");
        return propertyNames;
    }

    public void propertyChanged(DataModelEvent event) {
        if (event.getFlag() == 1) {
            event.getDataModel();
        }
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if ("IComponentCreationDataModelProperties.COMPONENT_NAME".equals(propertyName)) {
            this.model.setProperty("IComponentCreationDataModelProperties.COMPONENT_DEPLOY_NAME", propertyValue);
            this.model.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", propertyValue);
        } else if ("IComponentCreationDataModelProperties.COMPONENT_DEPLOY_NAME".equals(propertyName)) {
            this.model.setProperty("IComponentCreationDataModelProperties.COMPONENT_DEPLOY_NAME", propertyValue);
        } else {
            if ("IComponentCreationDataModelProperties.COMPONENT".equals(propertyName)) {
                throw new RuntimeException(String.valueOf(propertyName) + " should not be set.");
            }
            if ("IComponentCreationDataModelProperties.PROJECT_NAME".equals(propertyName)) {
                IDataModel dm = this.model.getNestedModel("IComponentCreationDataModelProperties.NESTED_PROJECT_CREATION_DM");
                dm.setProperty("IProjectCreationProperties.PROJECT_NAME", propertyValue);
                return true;
            }
        }
        return true;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IComponentCreationDataModelProperties.CREATE_DEFAULT_FILES")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IComponentCreationDataModelProperties.COMPONENT")) {
            String projectName = this.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME");
            IProject project = ProjectUtilities.getProject((String)projectName);
            return ComponentCore.createComponent(project);
        }
        return super.getDefaultProperty(propertyName);
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("IComponentCreationDataModelProperties.COMPONENT_NAME")) {
            IStatus status = OK_STATUS;
            String moduleName = this.model.getStringProperty("IComponentCreationDataModelProperties.COMPONENT_NAME");
            if (status.isOK()) {
                if (moduleName.indexOf("#") != -1 || moduleName.indexOf("/") != -1) {
                    String errorMessage = WTPCommonPlugin.getResourceString((String)"35");
                    return WTPCommonPlugin.createErrorStatus((String)errorMessage);
                }
                if (moduleName == null || moduleName.equals("")) {
                    String errorMessage = WTPCommonPlugin.getResourceString((String)"34");
                    return WTPCommonPlugin.createErrorStatus((String)errorMessage);
                }
                return OK_STATUS;
            }
            return status;
        }
        if (propertyName.equals("IComponentCreationDataModelProperties.PROJECT_NAME")) {
            IProject proj;
            IStatus status = OK_STATUS;
            String projectName = this.model.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME");
            if (projectName == null || projectName.length() == 0) {
                String errorMessage = WTPCommonPlugin.getResourceString((String)"15");
                status = WTPCommonPlugin.createErrorStatus((String)errorMessage);
            }
            if (status.isOK() && (status = this.validateProjectName(projectName)).isOK() && (proj = ProjectUtilities.getProject((String)projectName)).exists()) {
                String errorMessage = WTPCommonPlugin.getResourceString((String)"1");
                status = WTPCommonPlugin.createErrorStatus((String)errorMessage);
            }
            return status;
        }
        if (propertyName.equals("IComponentCreationDataModelProperties.COMPONENT_DEPLOY_NAME")) {
            return OK_STATUS;
        }
        if (propertyName.equals("IComponentCreationDataModelProperties.CREATE_DEFAULT_FILES")) {
            return OK_STATUS;
        }
        return OK_STATUS;
    }

    protected IStatus validateProjectName(String projectName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateName(projectName, 4);
        if (!status.isOK()) {
            return status;
        }
        if (ProjectUtilities.getProject((String)projectName).exists()) {
            return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"1", (Object[])new Object[]{projectName}));
        }
        if (projectName.indexOf("#") != -1) {
            String errorMessage = "InvalidCharsError";
            return WTPCommonPlugin.createErrorStatus((String)errorMessage);
        }
        return OK_STATUS;
    }

    protected String getComponentName() {
        return this.model.getStringProperty("IComponentCreationDataModelProperties.COMPONENT_NAME");
    }

    protected String getComponentDeployName() {
        return this.model.getStringProperty("IComponentCreationDataModelProperties.COMPONENT_DEPLOY_NAME");
    }

    protected abstract void initProjectCreationModel();

    protected abstract EClass getComponentType();

    protected abstract String getComponentExtension();

    protected abstract List getProperties();

    protected abstract Integer getDefaultComponentVersion();
}

