/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.operation;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class FacetProjectCreationOperation
extends AbstractDataModelOperation {
    public FacetProjectCreationOperation() {
    }

    public FacetProjectCreationOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            IFacetedProject facetProj = this.createProject(monitor);
            Set existingFacets = facetProj.getProjectFacets();
            Map dmMap = (Map)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            HashSet<Object> actions = new HashSet<Object>();
            IDataModel facetDM = null;
            Iterator iterator = dmMap.values().iterator();
            while (iterator.hasNext()) {
                facetDM = (IDataModel)iterator.next();
                if (!facetDM.getBooleanProperty("IFacetDataModelProperties.SHOULD_EXECUTE")) continue;
                String facetID = facetDM.getStringProperty("IFacetDataModelPropeties.FACET_ID");
                boolean shouldInstallFacet = true;
                Iterator existingFacetsIterator = existingFacets.iterator();
                while (shouldInstallFacet && existingFacetsIterator.hasNext()) {
                    IProjectFacetVersion version = (IProjectFacetVersion)existingFacetsIterator.next();
                    if (!version.getProjectFacet().getId().equals(facetID)) continue;
                    shouldInstallFacet = false;
                }
                if (!shouldInstallFacet) continue;
                actions.add(facetDM.getProperty("IFacetDataModelProperties.FACET_ACTION"));
            }
            if (!actions.isEmpty()) {
                facetProj.modify(actions, monitor);
            }
            HashSet<IProjectFacet> fixedFacets = new HashSet<IProjectFacet>();
            Set newFacetVersions = facetProj.getProjectFacets();
            Set existingFixedFacets = facetProj.getFixedProjectFacets();
            Iterator iter = newFacetVersions.iterator();
            while (iter.hasNext()) {
                IProjectFacetVersion facetVersion = (IProjectFacetVersion)iter.next();
                String facetID = facetVersion.getProjectFacet().getId();
                boolean shouldInstallFacet = true;
                Iterator existingFacetsIterator = existingFixedFacets.iterator();
                while (shouldInstallFacet && existingFacetsIterator.hasNext()) {
                    IProjectFacet facet = (IProjectFacet)existingFacetsIterator.next();
                    if (!facet.getId().equals(facetID)) continue;
                    shouldInstallFacet = false;
                }
                if (!shouldInstallFacet) continue;
                fixedFacets.add(facetVersion.getProjectFacet());
            }
            if (!fixedFacets.isEmpty()) {
                facetProj.setFixedProjectFacets(fixedFacets);
            }
            IRuntime runtime = (IRuntime)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
            IRuntime existingRuntime = facetProj.getRuntime();
            if (!(runtime == null || existingRuntime != null && runtime.equals(existingRuntime))) {
                facetProj.setRuntime(runtime, null);
                this.addDefaultFacets(facetProj, runtime.getDefaultFacets(fixedFacets));
            }
        }
        catch (CoreException e) {
            Logger.getLogger().logError((Throwable)e);
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            Logger.getLogger().logError((Throwable)e);
        }
        return OK_STATUS;
    }

    private void addDefaultFacets(IFacetedProject facetProj, Set defaultFacets) {
        HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
        Iterator iter = defaultFacets.iterator();
        while (iter.hasNext()) {
            IProjectFacetVersion facetVersion = (IProjectFacetVersion)iter.next();
            if (facetProj.hasProjectFacet(facetVersion.getProjectFacet())) continue;
            IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetInstallDataModelProvider());
            dm.setProperty("IFacetDataModelPropeties.FACET_ID", (Object)facetVersion.getProjectFacet().getId());
            dm.setProperty("IFacetDataModelPropeties.FACET_PROJECT_NAME", (Object)facetProj.getProject().getName());
            dm.setProperty("IFacetDataModelPropeties.FACET_VERSION_STR", (Object)facetVersion.getVersionString());
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, facetVersion, (Object)dm));
        }
        try {
            if (!actions.isEmpty()) {
                facetProj.modify(actions, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public IFacetedProject createProject(IProgressMonitor monitor) throws CoreException {
        IProject project = ProjectUtilities.getProject((String)((String)this.model.getProperty("IFacetDataModelPropeties.FACET_PROJECT_NAME")));
        IFacetedProject facetProj = null;
        if (project.exists()) {
            facetProj = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        } else {
            String location = (String)this.model.getProperty("IProjectCreationPropertiesNew.PROJECT_LOCATION");
            Path locationPath = location == null ? null : new Path(location);
            facetProj = ProjectFacetsManager.create((String)this.model.getStringProperty("IFacetDataModelPropeties.FACET_PROJECT_NAME"), (IPath)locationPath, (IProgressMonitor)monitor);
        }
        return facetProj;
    }

    private static void addDefaultFacetsInProject(IFacetedProject facetProj, Set defaultFacets) {
        HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
        Iterator iter = defaultFacets.iterator();
        while (iter.hasNext()) {
            IProjectFacetVersion facetVersion = (IProjectFacetVersion)iter.next();
            if (facetProj.hasProjectFacet(facetVersion.getProjectFacet())) continue;
            IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetInstallDataModelProvider());
            dm.setProperty("IFacetDataModelPropeties.FACET_ID", (Object)facetVersion.getProjectFacet().getId());
            dm.setProperty("IFacetDataModelPropeties.FACET_PROJECT_NAME", (Object)facetProj.getProject().getName());
            dm.setProperty("IFacetDataModelPropeties.FACET_VERSION_STR", (Object)facetVersion.getVersionString());
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, facetVersion, (Object)dm));
        }
        try {
            if (!actions.isEmpty()) {
                facetProj.modify(actions, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void addDefaultFactets(IFacetedProject facetProj, IRuntime runtime) throws ExecutionException {
        HashSet<IProjectFacet> fixedFacets = new HashSet<IProjectFacet>();
        Set newFacetVersions = facetProj.getProjectFacets();
        Set existingFixedFacets = facetProj.getFixedProjectFacets();
        Iterator iter = newFacetVersions.iterator();
        while (iter.hasNext()) {
            IProjectFacetVersion facetVersion = (IProjectFacetVersion)iter.next();
            String facetID = facetVersion.getProjectFacet().getId();
            boolean shouldInstallFacet = true;
            Iterator existingFacetsIterator = existingFixedFacets.iterator();
            while (shouldInstallFacet && existingFacetsIterator.hasNext()) {
                IProjectFacet facet = (IProjectFacet)existingFacetsIterator.next();
                if (!facet.getId().equals(facetID)) continue;
                shouldInstallFacet = false;
            }
            if (!shouldInstallFacet) continue;
            fixedFacets.add(facetVersion.getProjectFacet());
        }
        try {
            fixedFacets.addAll(facetProj.getFixedProjectFacets());
            facetProj.setFixedProjectFacets(fixedFacets);
            if (runtime != null) {
                FacetProjectCreationOperation.addDefaultFacetsInProject(facetProj, runtime.getDefaultFacets(fixedFacets));
            }
        }
        catch (CoreException e) {
            Logger.getLogger().logError((Throwable)e);
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }
}

