/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.util;

import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.wst.common.componentcore.internal.util.IArtifactEditFactory;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ArtifactEditRegistryReader
extends RegistryReader {
    Hashtable typeRegistry = new Hashtable();
    static final String ARTIFACT_EDIT_EXTENSION_POINT = "artifactedit";
    static final String ARTIFACTEDIT = "artifactedit";
    static final String TYPE = "typeID";
    static final String ARTIFACTEDITCLASS = "class";
    private static ArtifactEditRegistryReader instance;

    public static ArtifactEditRegistryReader instance() {
        if (instance == null) {
            instance = new ArtifactEditRegistryReader();
            instance.readRegistry();
        }
        return instance;
    }

    public ArtifactEditRegistryReader() {
        super("org.eclipse.wst.common.modulecore", "artifactedit");
    }

    public boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals("artifactedit")) {
            return false;
        }
        IArtifactEditFactory staticCaller = null;
        String typeID = null;
        try {
            typeID = element.getAttribute(TYPE);
            staticCaller = (IArtifactEditFactory)element.createExecutableExtension(ARTIFACTEDITCLASS);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (staticCaller != null) {
            this.addArtifactEdit(typeID, staticCaller);
        }
        return true;
    }

    private void addArtifactEdit(String typeID, IArtifactEditFactory staticCaller) {
        this.typeRegistry.put(typeID, staticCaller);
    }

    public IArtifactEditFactory getArtifactEdit(String typeID) {
        return (IArtifactEditFactory)this.typeRegistry.get(typeID);
    }

    public IArtifactEditFactory getArtifactEdit(IProject project) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            Iterator keys = this.typeRegistry.keySet().iterator();
            while (keys.hasNext()) {
                String typeID = (String)keys.next();
                try {
                    IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)typeID);
                    if (projectFacet == null || !facetedProject.hasProjectFacet(projectFacet)) continue;
                    return this.getArtifactEdit(typeID);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

