/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.deferred;

import java.util.Comparator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonLabelProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentExtension;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.DefaultNavigatorContentExtension;
import org.eclipse.wst.common.navigator.internal.views.deferred.ProxyContentProvider;
import org.eclipse.wst.common.navigator.internal.views.deferred.ProxyLabelProvider;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;

public class ProxyContentExtension
extends DefaultNavigatorContentExtension
implements INavigatorContentExtension {
    private NavigatorContentDescriptor descriptor;
    private INavigatorContentExtension delegateExtension;
    private INavigatorContentProvider delegateContentProvider;
    private ILabelProvider delegateLabelProvider;
    private ICommonLabelProvider labelProvider;
    private INavigatorContentProvider contentProvider;
    private NavigatorContentService contentService;

    public ProxyContentExtension(NavigatorContentDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public INavigatorContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new ProxyContentProvider(this);
        }
        return this.contentProvider;
    }

    public ICommonLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new ProxyLabelProvider(this);
        }
        return this.labelProvider;
    }

    public void init(NavigatorContentService aContentService) {
        this.contentService = aContentService;
    }

    public void dispose() {
        if (this.isExtensionLoaded()) {
            this.getDelegateExtension().dispose();
        }
    }

    public Comparator getComparator() {
        if (!this.isExtensionLoaded()) {
            return null;
        }
        return this.getDelegateExtension().getComparator();
    }

    public void setDescriptor(NavigatorContentDescriptor descriptor) {
        if (descriptor == null) {
            this.descriptor = descriptor;
        }
    }

    public NavigatorContentDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Object getAdapter(Class adapter) {
        if (!this.isExtensionLoaded()) {
            return Platform.getAdapterManager().getAdapter((Object)this, adapter);
        }
        return this.getDelegateExtension().getAdapter(adapter);
    }

    protected boolean isExtensionLoaded() {
        return this.delegateExtension != null;
    }

    protected boolean isContentProviderLoaded() {
        return this.delegateContentProvider != null;
    }

    public boolean isLabelProviderLoaded() {
        return this.delegateLabelProvider != null;
    }

    protected INavigatorContentExtension getDelegateExtension() {
        if (this.delegateExtension == null) {
            this.delegateExtension = this.descriptor.createExtension(false);
            this.delegateExtension.init(this.descriptor, this.contentService);
        }
        return this.delegateExtension;
    }

    protected INavigatorContentProvider getDelegateContentProvider() {
        if (this.delegateContentProvider == null) {
            this.delegateContentProvider = this.getDelegateExtension().getContentProvider();
        }
        return this.delegateContentProvider;
    }

    protected ILabelProvider getDelegateLabelProvider() {
        if (this.delegateLabelProvider == null) {
            this.delegateLabelProvider = this.getDelegateExtension().getLabelProvider();
        }
        return this.delegateLabelProvider;
    }
}

