/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.deferred;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.navigator.internal.views.InstanceSchedulingRule;
import org.eclipse.wst.common.navigator.internal.views.deferred.IPendingElementCollector;

public class TreeViewerElementCollector
implements IPendingElementCollector {
    private Map instanceRuleCache = null;
    private AbstractTreeViewer treeViewer = null;

    public TreeViewerElementCollector(AbstractTreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    public synchronized void collectChildren(Object parent, Object[] children) {
        this.getDefaultUIUpdateJob(parent, children).schedule();
    }

    public void done(PendingUpdateAdapter placeHolder) {
        if (PlatformUI.isWorkbenchRunning()) {
            this.getDefaultUIComplete(placeHolder).schedule();
        }
    }

    protected UIJob getDefaultUIUpdateJob(Object parent, Object[] children) {
        return new TreeViewerUIUpdateJob(parent, children);
    }

    protected UIJob getDefaultUIComplete(PendingUpdateAdapter placeHolder) {
        return new ClearPlaceHolderJob(placeHolder);
    }

    protected AbstractTreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected Map getWrappedRuleCache() {
        if (this.instanceRuleCache == null) {
            this.instanceRuleCache = new WeakHashMap();
        }
        return this.instanceRuleCache;
    }

    protected ISchedulingRule getCachedRule(Object ruleObject) {
        ISchedulingRule rule = (ISchedulingRule)this.getWrappedRuleCache().get(ruleObject);
        if (rule == null) {
            rule = new InstanceSchedulingRule(ruleObject);
            this.getWrappedRuleCache().put(ruleObject, rule);
        }
        return rule;
    }

    public class TreeViewerUIUpdateJob
    extends UIJob {
        protected Object parent = null;
        protected Object[] children = null;

        public TreeViewerUIUpdateJob(Object parent, Object[] children) {
            super(ProgressMessages.DeferredTreeContentManager_AddingChildren);
            this.parent = parent;
            this.children = children;
            this.setRule(new InstanceSchedulingRule(TreeViewerElementCollector.this.treeViewer));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor updateMonitor) {
            if (this.children == null || this.children.length == 0) {
                return Status.OK_STATUS;
            }
            AbstractTreeViewer abstractTreeViewer = TreeViewerElementCollector.this.treeViewer;
            synchronized (abstractTreeViewer) {
                if (TreeViewerElementCollector.this.treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                TreeViewerElementCollector.this.treeViewer.getControl().setRedraw(false);
                TreeViewerElementCollector.this.treeViewer.add(this.parent, this.children);
                TreeViewerElementCollector.this.treeViewer.getControl().setRedraw(true);
            }
            return Status.OK_STATUS;
        }
    }

    public class ClearPlaceHolderJob
    extends UIJob {
        private PendingUpdateAdapter placeHolder = null;

        public ClearPlaceHolderJob(PendingUpdateAdapter placeHolder) {
            super(ProgressMessages.DeferredTreeContentManager_ClearJob);
            this.setSystem(true);
            this.placeHolder = placeHolder;
            this.setRule(new InstanceSchedulingRule(TreeViewerElementCollector.this.treeViewer));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            AbstractTreeViewer abstractTreeViewer = TreeViewerElementCollector.this.treeViewer;
            synchronized (abstractTreeViewer) {
                Control control = TreeViewerElementCollector.this.treeViewer.getControl();
                if (control.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                TreeViewerElementCollector.this.getTreeViewer().remove((Object)this.placeHolder);
                return Status.OK_STATUS;
            }
        }
    }
}

