/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.dnd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonViewer;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonDropActionDelegate;
import org.eclipse.wst.common.navigator.internal.views.NavigatorMessages;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.dnd.Assert;
import org.eclipse.wst.common.navigator.internal.views.dnd.DropHandlerDescriptor;
import org.eclipse.wst.common.navigator.internal.views.dnd.IDropValidator;
import org.eclipse.wst.common.navigator.internal.views.dnd.SerializerCollectionDescriptor;
import org.eclipse.wst.common.navigator.internal.views.dnd.SerializerDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.RegistryReader;

public class CommonDropHandlerService
extends RegistryReader {
    private static final DropHandlerDescriptor[] NO_DROP_HANDLER_DESCRIPTORS = new DropHandlerDescriptor[0];
    private Map descriptors;
    private Map actions;
    private static Map registries;
    private String viewerId;

    protected CommonDropHandlerService(String viewerId) {
        super(NavigatorPlugin.PLUGIN_ID, "dropHandler");
        this.viewerId = viewerId;
    }

    public DropHandlerDescriptor[] getDropHandlersEnabledFor(Object source, Object target) {
        try {
            ArrayList<DropHandlerDescriptor> results = new ArrayList<DropHandlerDescriptor>();
            DropHandlerDescriptor descr = null;
            Iterator descriptorIterator = this.getDescriptors().values().iterator();
            while (descriptorIterator.hasNext()) {
                descr = (DropHandlerDescriptor)descriptorIterator.next();
                if (!descr.isDropEnabledFor(target) || source != null && !descr.isDragEnabledFor(source)) continue;
                results.add(descr);
            }
            if (results.size() > 0) {
                return results.toArray(new DropHandlerDescriptor[results.size()]);
            }
            return NO_DROP_HANDLER_DESCRIPTORS;
        }
        catch (Throwable t) {
            NavigatorPlugin.log(String.valueOf(NavigatorMessages.CommonDropHandlerService_0) + t);
            return NO_DROP_HANDLER_DESCRIPTORS;
        }
    }

    public DropHandlerDescriptor[] getDropHandlersBySerializerId(String id) {
        try {
            ArrayList<DropHandlerDescriptor> results = new ArrayList<DropHandlerDescriptor>();
            DropHandlerDescriptor descr = null;
            SerializerCollectionDescriptor serializerCollectionDescriptor = null;
            Iterator descriptorIterator = this.getDescriptors().values().iterator();
            while (descriptorIterator.hasNext()) {
                descr = (DropHandlerDescriptor)descriptorIterator.next();
                serializerCollectionDescriptor = descr.getSerializersDescriptor();
                if (serializerCollectionDescriptor == null || serializerCollectionDescriptor.getSerializerById(id) == null) continue;
                results.add(descr);
            }
            if (results.size() > 0) {
                return results.toArray(new DropHandlerDescriptor[results.size()]);
            }
            return NO_DROP_HANDLER_DESCRIPTORS;
        }
        catch (Throwable t) {
            NavigatorPlugin.log(String.valueOf(NavigatorMessages.CommonDropHandlerService_0) + t);
            return NO_DROP_HANDLER_DESCRIPTORS;
        }
    }

    public SerializerDescriptor getSerializerById(String id) {
        DropHandlerDescriptor descr = null;
        SerializerDescriptor result = null;
        SerializerCollectionDescriptor serializerCollectionDescriptor = null;
        Iterator descriptorIterator = this.getDescriptors().values().iterator();
        while (descriptorIterator.hasNext()) {
            descr = (DropHandlerDescriptor)descriptorIterator.next();
            serializerCollectionDescriptor = descr.getSerializersDescriptor();
            if (serializerCollectionDescriptor != null && (result = serializerCollectionDescriptor.getSerializerById(id)) != null) break;
        }
        return result;
    }

    public ICommonDropActionDelegate getActionForSerializerId(String serializerId) {
        DropHandlerDescriptor descr = null;
        SerializerCollectionDescriptor serializerCollectionDescriptor = null;
        ICommonDropActionDelegate action = null;
        Iterator descriptorIterator = this.getDescriptors().values().iterator();
        while (descriptorIterator.hasNext()) {
            descr = (DropHandlerDescriptor)descriptorIterator.next();
            serializerCollectionDescriptor = descr.getSerializersDescriptor();
            if (serializerCollectionDescriptor == null || serializerCollectionDescriptor.getSerializerById(serializerId) == null) continue;
            action = descr.createAction();
            break;
        }
        return action;
    }

    public SerializerDescriptor[] getSerializersEnabledFor(Object source) {
        SerializerDescriptor[] serializers = null;
        try {
            ArrayList<SerializerDescriptor> results = new ArrayList<SerializerDescriptor>();
            Iterator descriptorIterator = this.getDescriptors().values().iterator();
            DropHandlerDescriptor descr = null;
            SerializerCollectionDescriptor serializerCollectionDescriptor = null;
            while (descriptorIterator.hasNext()) {
                descr = (DropHandlerDescriptor)descriptorIterator.next();
                if (!descr.isDragEnabledFor(source) || (serializerCollectionDescriptor = descr.getSerializersDescriptor()) == null) continue;
                results.addAll(Arrays.asList(serializerCollectionDescriptor.getSerializersEnabledFor(source)));
            }
            if (results.size() > 0) {
                serializers = new SerializerDescriptor[results.size()];
                results.toArray(serializers);
            } else {
                serializers = new SerializerDescriptor[]{};
            }
        }
        catch (Throwable t) {
            NavigatorPlugin.log(String.valueOf(NavigatorMessages.CommonDropHandlerService_0) + t);
            serializers = new SerializerDescriptor[]{};
        }
        return serializers;
    }

    public IDropValidator getDropValidator(CommonViewer aViewer, DropHandlerDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        ICommonDropActionDelegate action = null;
        IDropValidator dropValidator = descriptor.getDropValidator();
        if (dropValidator == null && (action = this.getDropActionDelegate(aViewer, descriptor)) instanceof IDropValidator) {
            dropValidator = (IDropValidator)((Object)action);
        }
        return dropValidator;
    }

    public ICommonDropActionDelegate getDropActionDelegate(CommonViewer aViewer, DropHandlerDescriptor descriptor) {
        Assert.isTrue(this.viewerId.equals(aViewer.getNavigatorContentService().getViewerId()));
        ICommonDropActionDelegate action = (ICommonDropActionDelegate)this.getActions().get(descriptor.getId());
        if (action == null && (action = descriptor.createAction()) != null) {
            action.init(aViewer);
            this.getActions().put(descriptor.getId(), action);
        }
        return action;
    }

    public boolean readElement(IConfigurationElement element) {
        if ("dropHandler".equals(element.getName())) {
            this.addDescriptor(new DropHandlerDescriptor(element));
            return true;
        }
        return false;
    }

    protected void addDescriptor(DropHandlerDescriptor descriptor) {
        this.getDescriptors().put(descriptor.getId(), descriptor);
    }

    protected Map getDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new HashMap();
        }
        return this.descriptors;
    }

    protected Map getActions() {
        if (this.actions == null) {
            this.actions = new HashMap();
        }
        return this.actions;
    }

    protected static Map getRegistries() {
        if (registries == null) {
            registries = new HashMap();
        }
        return registries;
    }

    public static CommonDropHandlerService getInstance(String viewerId) {
        CommonDropHandlerService instance = (CommonDropHandlerService)CommonDropHandlerService.getRegistries().get(viewerId);
        if (instance == null) {
            instance = new CommonDropHandlerService(viewerId);
            CommonDropHandlerService.getRegistries().put(viewerId, instance);
            instance.readRegistry();
        }
        return instance;
    }
}

