/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.dnd;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonViewer;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.dnd.FileTransferDragAdapter;
import org.eclipse.wst.common.navigator.internal.views.dnd.ISerializer;
import org.eclipse.wst.common.navigator.internal.views.dnd.NavigatorSelectionSerializer;
import org.eclipse.wst.common.navigator.internal.views.dnd.ResourceTransferDragAdapter;

public class CommonNavigatorDragAdapter
extends DragSourceAdapter {
    private ResourceTransferDragAdapter delegateResourceDragAdapter;
    private FileTransferDragAdapter delegateFileDragAdapter;
    private ISerializer serializer;
    private final CommonViewer commonViewer;

    public CommonNavigatorDragAdapter(CommonViewer aViewer) {
        this.commonViewer = aViewer;
        this.delegateResourceDragAdapter = new ResourceTransferDragAdapter((ISelectionProvider)this.commonViewer);
        this.delegateFileDragAdapter = new FileTransferDragAdapter((ISelectionProvider)this.commonViewer);
    }

    public void dragStart(DragSourceEvent event) {
        try {
            ISelection selection = this.commonViewer.getSelection();
            event.doit = !selection.isEmpty();
            LocalSelectionTransfer.getInstance().setSelection(selection);
        }
        catch (RuntimeException e) {
            NavigatorPlugin.log("CommonNavigatorDragAdapter.dragStart():" + e.toString());
        }
    }

    public void dragSetData(DragSourceEvent event) {
        if (LocalSelectionTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = LocalSelectionTransfer.getInstance().getSelection();
        } else if (PluginTransfer.getInstance().isSupportedType(event.dataType)) {
            IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getInstance().getSelection();
            byte[] data = this.getSerializer().toByteArray(selection);
            event.data = new PluginTransferData("org.eclipse.wst.common.navigator.internal.views.navigator.dnd.PluginDropAction", data);
        } else if (ResourceTransfer.getInstance().isSupportedType(event.dataType)) {
            this.delegateResourceDragAdapter.dragSetData(event);
        } else if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
            this.delegateFileDragAdapter.dragSetData(event);
        }
    }

    private ISerializer getSerializer() {
        if (this.serializer == null) {
            this.serializer = new NavigatorSelectionSerializer(this.commonViewer.getNavigatorContentService().getViewerId());
        }
        return this.serializer;
    }

    public void dragFinished(DragSourceEvent event) {
        LocalSelectionTransfer.getInstance().setSelection(null);
    }
}

