/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.dnd;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.wst.common.navigator.internal.views.NavigatorMessages;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.dnd.Assert;
import org.eclipse.wst.common.navigator.internal.views.dnd.ISerializer;

public class SerializerDescriptor {
    public final String id;
    protected final IConfigurationElement serializerElement;
    public final ActionExpression enablement;
    private ISerializer serializer;

    public SerializerDescriptor(String dropHandlerId, IConfigurationElement serializer, ActionExpression dragEnablement) {
        Assert.isNotNull(serializer, NavigatorMessages.SerializerDescriptor_0);
        String localId = serializer.getAttribute("id");
        Assert.isNotNull(localId, NavigatorMessages.SerializerDescriptor_1);
        this.id = String.valueOf(dropHandlerId) + ":" + localId;
        this.serializerElement = serializer;
        IConfigurationElement[] enablementConfigElement = this.serializerElement.getChildren("enablement");
        if (enablementConfigElement.length == 0) {
            this.enablement = dragEnablement;
        } else if (enablementConfigElement.length == 1) {
            this.enablement = new ActionExpression(enablementConfigElement[0]);
        } else {
            NavigatorPlugin.log(NavigatorMessages.getString(NavigatorMessages.SerializerDescriptor_3, new Object[]{this.id}));
            this.enablement = dragEnablement;
        }
    }

    public ISerializer getSerializer() {
        if (this.serializer == null) {
            try {
                this.serializer = (ISerializer)this.serializerElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                NavigatorPlugin.log(NavigatorMessages.getString(NavigatorMessages.SerializerDescriptor_5, new Object[]{this.id, e.toString()}));
                this.serializer = null;
            }
        }
        return this.serializer;
    }
}

