/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.extensions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.wst.common.navigator.internal.provisional.views.ILinkHelper;
import org.eclipse.wst.common.navigator.internal.views.NavigatorMessages;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.dnd.Assert;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptorRegistry;
import org.eclipse.wst.common.navigator.internal.views.extensions.RegistryReader;

public class LinkHelperRegistry
extends RegistryReader {
    private static final NavigatorContentDescriptorRegistry CONTENT_DESCRIPTOR_REGISTRY = NavigatorContentDescriptorRegistry.getInstance();
    private static final LinkHelperRegistry INSTANCE = new LinkHelperRegistry();
    private static final ILinkHelper[] NO_LINK_HELPERS = new ILinkHelper[0];
    private static boolean isInitialized = false;
    private List descriptors;

    protected LinkHelperRegistry() {
        super(NavigatorPlugin.PLUGIN_ID, "linkHelper");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkHelperRegistry getInstance() {
        if (isInitialized) {
            return INSTANCE;
        }
        LinkHelperRegistry linkHelperRegistry = INSTANCE;
        synchronized (linkHelperRegistry) {
            if (!isInitialized) {
                INSTANCE.readRegistry();
                isInitialized = true;
            }
        }
        return INSTANCE;
    }

    public ILinkHelper[] getLinkHelpersFor(IStructuredSelection aSelection) {
        if (aSelection.isEmpty()) {
            return NO_LINK_HELPERS;
        }
        List contentDescriptors = CONTENT_DESCRIPTOR_REGISTRY.getEnabledContentDescriptors(aSelection.getFirstElement());
        if (contentDescriptors.size() == 0) {
            return NO_LINK_HELPERS;
        }
        NavigatorContentDescriptor contentDescriptor = (NavigatorContentDescriptor)contentDescriptors.get(0);
        ArrayList<ILinkHelper> helpersList = new ArrayList<ILinkHelper>();
        ILinkHelper[] helpers = NO_LINK_HELPERS;
        Descriptor descriptor = null;
        Iterator itr = this.getDescriptors().iterator();
        while (itr.hasNext()) {
            descriptor = (Descriptor)itr.next();
            if (descriptor.isEnabledFor(contentDescriptor.getId())) {
                helpersList.add(descriptor.getLinkHelper());
                continue;
            }
            if (!descriptor.isEnabledFor(aSelection)) continue;
            helpersList.add(descriptor.getLinkHelper());
        }
        if (helpersList.size() > 0) {
            helpers = new ILinkHelper[helpersList.size()];
            helpersList.toArray(helpers);
        }
        return helpers;
    }

    public ILinkHelper[] getLinkHelpersFor(IEditorInput input) {
        ArrayList<ILinkHelper> helpersList = new ArrayList<ILinkHelper>();
        ILinkHelper[] helpers = new ILinkHelper[]{};
        Descriptor descriptor = null;
        Iterator itr = this.getDescriptors().iterator();
        while (itr.hasNext()) {
            descriptor = (Descriptor)itr.next();
            if (!descriptor.isEnabledFor(input)) continue;
            helpersList.add(descriptor.getLinkHelper());
        }
        if (helpersList.size() > 0) {
            helpers = new ILinkHelper[helpersList.size()];
            helpersList.toArray(helpers);
        }
        return helpers;
    }

    public boolean readElement(IConfigurationElement element) {
        if ("linkHelper".equals(element.getName())) {
            this.getDescriptors().add(new Descriptor(element));
            return true;
        }
        return false;
    }

    protected List getDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new ArrayList();
        }
        return this.descriptors;
    }

    public class Descriptor {
        private final IConfigurationElement configElement;
        private String id;
        private String navigatorContentExtensionId;
        private ILinkHelper linkHelper;
        public static final String LINK_HELPER = "linkHelper";
        public static final String ATT_ID = "id";
        private static final String ATT_CLASS = "class";
        private static final String ATT_NAVIGATOR_CONTENT_EXTENSION_ID = "navigatorContentExtensionId";
        private ActionExpression editorInputEnablement;
        private ActionExpression selectionEnablement;
        private static final String EDITOR_INPUT_ENABLEMENT = "editorInputEnablement";
        private static final String SELECTION_ENABLEMENT = "selectionEnablement";

        public Descriptor(IConfigurationElement element) {
            Assert.isNotNull(element, NavigatorMessages.LinkHelperRegistry_4);
            Assert.isLegal(LINK_HELPER.equals(element.getName()), NavigatorMessages.LinkHelperRegistry_5);
            this.configElement = element;
            this.init();
        }

        private void init() {
            this.id = this.configElement.getAttribute(ATT_ID);
            IConfigurationElement[] expressions = this.configElement.getChildren(EDITOR_INPUT_ENABLEMENT);
            Assert.isNotNull(expressions, NavigatorMessages.LinkHelperRegistry_6);
            Assert.isLegal(expressions.length == 1, NavigatorMessages.LinkHelperRegistry_7);
            this.editorInputEnablement = new ActionExpression(expressions[0]);
            expressions = this.configElement.getChildren(SELECTION_ENABLEMENT);
            if (expressions.length > 0) {
                this.navigatorContentExtensionId = expressions[0].getAttribute(ATT_NAVIGATOR_CONTENT_EXTENSION_ID);
                if (expressions[0].getChildren() != null && expressions[0].getChildren().length > 0) {
                    this.selectionEnablement = new ActionExpression(expressions[0]);
                }
            }
        }

        public String getId() {
            return this.id;
        }

        public ILinkHelper getLinkHelper() {
            if (this.linkHelper == null) {
                try {
                    this.linkHelper = (ILinkHelper)this.configElement.createExecutableExtension(ATT_CLASS);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            return this.linkHelper;
        }

        public boolean isEnabledFor(IEditorInput anInput) {
            return this.editorInputEnablement != null ? this.editorInputEnablement.isEnabledFor((Object)anInput) : false;
        }

        public boolean isEnabledFor(String aNavigatorContentExtensionId) {
            return this.navigatorContentExtensionId != null ? this.navigatorContentExtensionId.equals(aNavigatorContentExtensionId) : false;
        }

        public boolean isEnabledFor(IStructuredSelection aSelection) {
            return this.selectionEnablement != null ? this.selectionEnablement.isEnabledFor(aSelection) : false;
        }
    }
}

