/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.extensions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentExtension;
import org.eclipse.wst.common.navigator.internal.provisional.views.Priority;
import org.eclipse.wst.common.navigator.internal.views.deferred.ProxyContentExtension;
import org.eclipse.wst.common.navigator.internal.views.extensions.EMFExpression;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentExtension;

public class NavigatorContentDescriptor {
    public static final String ATT_ID = "id";
    public static final String ATT_NAME = "name";
    public static final String ATT_CLASS = "class";
    private static final String ATT_ROOT_LABEL = "rootLabel";
    private String id;
    private String name;
    private String className;
    private IConfigurationElement configElement;
    private String rootLabel;
    private static final String CHILD_ENABLEMENT = "enables";
    private static final String EMF_ENABLEMENT = "emfEnablement";
    private static final String CONTRIBUTION_ENABLEMENT = "contributes";
    private static final String ATT_PRIORITY = "priority";
    private static final String ATT_ICON = "icon";
    private static final String ENABLED_BY_DEFAULT = "enabledByDefault";
    public static final String ATT_CONTENT_PROVIDER = "contentProvider";
    public static final String ATT_LABEL_PROVIDER = "labelProvider";
    public static final String ATT_ACTION_PROVIDER = "actionProvider";
    public static final String ATT_OPEN_LISTENER = "openListener";
    public static final String ATT_SORTER = "sorter";
    private int priority = Integer.MAX_VALUE;
    private ActionExpression enablement;
    private ActionExpression contributionEnablement;
    private boolean root;
    private String icon;
    private String declaringPluginId;
    private boolean enabledByDefault;
    private IPluginContribution contribution;
    private boolean hasLoadingFailed;
    private EMFExpression emfEnablement;

    public NavigatorContentDescriptor(IConfigurationElement configElement) throws WorkbenchException {
        this.configElement = configElement;
        this.readConfigElement();
    }

    public INavigatorContentExtension createExtension() {
        return this.createExtension(null, true);
    }

    public INavigatorContentExtension createExtension(String aViewerId) {
        return this.createExtension(aViewerId, true);
    }

    public INavigatorContentExtension createExtension(boolean proxyIfNecessary) {
        return this.createExtension(null, proxyIfNecessary);
    }

    public INavigatorContentExtension createExtension(String aViewerId, boolean proxyIfNecessary) {
        INavigatorContentExtension extension = null;
        try {
            if (proxyIfNecessary && this.isRoot() && this.getRootLabel() != null) {
                extension = new ProxyContentExtension(this);
            } else if (this.getConfigurationElement().getAttribute(ATT_CLASS) != null) {
                extension = (INavigatorContentExtension)this.getConfigurationElement().createExecutableExtension(ATT_CLASS);
            } else if (aViewerId != null) {
                extension = new NavigatorContentExtension();
            }
        }
        catch (CoreException exception) {
            WorkbenchPlugin.log((String)("Unable to create navigator extension: " + this.getClassName()), (IStatus)exception.getStatus());
            this.hasLoadingFailed = true;
        }
        catch (Exception e) {
            WorkbenchPlugin.log((String)("Unable to create navigator extension: " + this.getClassName()), (Throwable)e);
            e.printStackTrace();
            this.hasLoadingFailed = true;
        }
        return extension;
    }

    public boolean isEnabledFor(IStructuredSelection aStructuredSelection) {
        return this.enablement != null && this.enablement.isEnabledFor(aStructuredSelection) || this.emfEnablement != null && this.emfEnablement.isEnabledFor(aStructuredSelection);
    }

    public boolean isEnabledFor(Object anElement) {
        return this.enablement != null && this.enablement.isEnabledFor(anElement) || this.emfEnablement != null && this.emfEnablement.isEnabledFor(anElement);
    }

    public String getClassName() {
        return this.className;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    public ActionExpression getContributionEnablement() {
        return this.contributionEnablement;
    }

    public ActionExpression getEnableExpression() {
        return this.enablement;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isRoot() {
        return this.root;
    }

    protected String getRootLabel() {
        return this.rootLabel;
    }

    void readConfigElement() throws WorkbenchException {
        this.id = this.configElement.getAttribute(ATT_ID);
        this.name = this.configElement.getAttribute(ATT_NAME);
        this.className = this.configElement.getAttribute(ATT_CLASS);
        String priorityString = this.configElement.getAttribute(ATT_PRIORITY);
        this.icon = this.configElement.getAttribute(ATT_ICON);
        this.rootLabel = this.configElement.getAttribute(ATT_ROOT_LABEL);
        this.declaringPluginId = this.configElement.getDeclaringExtension().getNamespace();
        String enabledByDefaultString = this.configElement.getAttribute(ENABLED_BY_DEFAULT);
        boolean bl = this.enabledByDefault = enabledByDefaultString != null && enabledByDefaultString.length() > 0 ? Boolean.valueOf(this.configElement.getAttribute(ENABLED_BY_DEFAULT)) : true;
        if (this.className == null && (this.configElement.getAttribute(ATT_CONTENT_PROVIDER) == null || this.configElement.getAttribute(ATT_LABEL_PROVIDER) == null)) {
            throw new WorkbenchException("Missing attribute: class or one or both of contentProvider and labelProvider in navigator extension: " + this.configElement.getDeclaringExtension().getUniqueIdentifier());
        }
        if (priorityString != null) {
            try {
                Priority p = Priority.get(priorityString);
                this.priority = p != null ? p.getValue() : -1;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (this.id == null) {
            throw new WorkbenchException("Missing attribute: id in navigator extension: " + this.configElement.getDeclaringExtension().getUniqueIdentifier());
        }
        IConfigurationElement[] children = this.configElement.getChildren(CHILD_ENABLEMENT);
        if (children.length == 1) {
            this.enablement = new ActionExpression(children[0]);
        } else if (children.length > 1) {
            throw new WorkbenchException("More than one element: enables in content provider: " + this.configElement.getDeclaringExtension().getUniqueIdentifier());
        }
        children = this.configElement.getChildren(CONTRIBUTION_ENABLEMENT);
        if (children.length == 1) {
            this.contributionEnablement = new ActionExpression(children[0]);
        } else if (children.length > 1) {
            throw new WorkbenchException("More than one element: contributes in navigator extension: " + this.configElement.getDeclaringExtension().getUniqueIdentifier());
        }
        children = this.configElement.getChildren(EMF_ENABLEMENT);
        if (children.length == 1) {
            this.emfEnablement = new EMFExpression(children[0]);
        } else if (children.length > 1) {
            throw new WorkbenchException("More than one element: emfEnablement in navigator extension: " + this.configElement.getDeclaringExtension().getUniqueIdentifier());
        }
        this.contribution = new IPluginContribution(){

            public String getLocalId() {
                return NavigatorContentDescriptor.this.configElement.getDeclaringExtension().getSimpleIdentifier();
            }

            public String getPluginId() {
                return NavigatorContentDescriptor.this.configElement.getDeclaringExtension().getNamespace();
            }
        };
    }

    void setRoot(boolean root) {
        this.root = root;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getDeclaringPluginId() {
        return this.declaringPluginId;
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public IPluginContribution getContribution() {
        return this.contribution;
    }

    public boolean hasLoadingFailed() {
        return this.hasLoadingFailed;
    }
}

