/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.extensions;

import java.util.Comparator;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonActionProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonLabelProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonOpenListener;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentExtension;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.extensions.DelegateCommonLabelProvider;
import org.eclipse.wst.common.navigator.internal.views.extensions.IdentityComparator;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentExtension;
import org.eclipse.wst.common.navigator.internal.views.extensions.SkeletonActionProvider;
import org.eclipse.wst.common.navigator.internal.views.extensions.SkeletonLabelProvider;
import org.eclipse.wst.common.navigator.internal.views.extensions.SkeletonNavigatorContentExtension;
import org.eclipse.wst.common.navigator.internal.views.extensions.SkeletonOpenListener;
import org.eclipse.wst.common.navigator.internal.views.extensions.SkeletonTreeContentProvider;

public class NavigatorContentDescriptorInstance {
    private final NavigatorContentDescriptor descriptor;
    private final NavigatorContentService contentService;
    private final String viewerId;
    private INavigatorContentExtension contentExtension;
    private ITreeContentProvider contentProvider;
    private ICommonLabelProvider labelProvider;
    private ICommonActionProvider actionProvider;
    private ICommonOpenListener openListener;
    private Comparator sorter;
    private boolean isDisposed = false;
    static /* synthetic */ Class class$0;

    public NavigatorContentDescriptorInstance(NavigatorContentDescriptor aDescriptor, NavigatorContentService aManager, String aViewerId) {
        if (aDescriptor == null) {
            StringBuffer stringBuffer = new StringBuffer("The parameter aDescriptor (of type ");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new IllegalArgumentException(stringBuffer.append(clazz.getName()).append(") cannot be null!").toString());
        }
        this.descriptor = aDescriptor;
        this.contentService = aManager;
        this.viewerId = aViewerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITreeContentProvider getContentProvider() {
        this.complainDisposedIfNecessary();
        if (this.contentProvider != null) {
            return this.contentProvider;
        }
        NavigatorContentDescriptorInstance navigatorContentDescriptorInstance = this;
        synchronized (navigatorContentDescriptorInstance) {
            if (this.contentProvider == null) {
                try {
                    this.contentProvider = this.getContentExtension().getContentProvider();
                    this.contentService.initialize((IStructuredContentProvider)this.contentProvider);
                }
                catch (RuntimeException re) {
                    this.contentProvider = SkeletonTreeContentProvider.INSTANCE;
                    re.printStackTrace();
                }
            }
        }
        return this.contentProvider;
    }

    public ICommonLabelProvider getLabelProvider() {
        this.complainDisposedIfNecessary();
        if (this.labelProvider == null) {
            try {
                ICommonLabelProvider provider = this.getContentExtension().getLabelProvider();
                this.labelProvider = provider == null ? SkeletonLabelProvider.INSTANCE : (provider instanceof ICommonLabelProvider ? provider : new DelegateCommonLabelProvider(provider));
            }
            catch (RuntimeException re) {
                this.labelProvider = SkeletonLabelProvider.INSTANCE;
                re.printStackTrace();
            }
        }
        return this.labelProvider;
    }

    public ICommonOpenListener getOpenListener() {
        this.complainDisposedIfNecessary();
        if (this.openListener == null) {
            try {
                if (this.getContentExtension() instanceof NavigatorContentExtension) {
                    this.openListener = ((NavigatorContentExtension)this.getContentExtension()).getOpenListener();
                }
            }
            catch (RuntimeException re) {
                re.printStackTrace();
            }
            if (this.openListener == null) {
                this.openListener = SkeletonOpenListener.INSTANCE;
            }
        }
        return this.openListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommonActionProvider getActionProvider() {
        this.complainDisposedIfNecessary();
        if (this.actionProvider != null) {
            return this.actionProvider;
        }
        NavigatorContentDescriptorInstance navigatorContentDescriptorInstance = this;
        synchronized (navigatorContentDescriptorInstance) {
            if (this.actionProvider == null) {
                this.actionProvider = this.getContentExtension() instanceof NavigatorContentExtension ? ((NavigatorContentExtension)this.getContentExtension()).getActionProvider() : SkeletonActionProvider.INSTANCE;
            }
        }
        return this.actionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Comparator getSorter() {
        this.complainDisposedIfNecessary();
        if (this.sorter != null) {
            return this.sorter;
        }
        NavigatorContentDescriptorInstance navigatorContentDescriptorInstance = this;
        synchronized (navigatorContentDescriptorInstance) {
            if (this.sorter == null) {
                this.sorter = this.getContentExtension() instanceof NavigatorContentExtension ? ((NavigatorContentExtension)this.getContentExtension()).getComparator() : IdentityComparator.INSTANCE;
            }
        }
        return this.sorter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        NavigatorContentDescriptorInstance navigatorContentDescriptorInstance = this;
        synchronized (navigatorContentDescriptorInstance) {
            this.getContentExtension().dispose();
            this.contentExtension = null;
            this.isDisposed = true;
        }
    }

    public boolean isLoaded() {
        return this.contentProvider != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INavigatorContentExtension getContentExtension() {
        if (this.contentExtension != null) {
            return this.contentExtension;
        }
        NavigatorContentDescriptorInstance navigatorContentDescriptorInstance = this;
        synchronized (navigatorContentDescriptorInstance) {
            try {
                if (this.contentExtension == null) {
                    this.contentExtension = this.descriptor.createExtension(this.viewerId);
                    this.contentExtension.init(this.descriptor, this.contentService);
                }
            }
            catch (RuntimeException re) {
                re.printStackTrace();
                this.contentExtension = SkeletonNavigatorContentExtension.INSTANCE;
            }
        }
        return this.contentExtension;
    }

    public boolean hasLoadingFailed() {
        if (this.contentExtension == null) {
            return false;
        }
        if (this.contentExtension instanceof NavigatorContentExtension) {
            NavigatorContentExtension internalExtension = (NavigatorContentExtension)this.contentExtension;
            return internalExtension.hasContentProviderInitializationFailed() || internalExtension.hasLabelProviderInitializationFailed();
        }
        return false;
    }

    protected final void complainDisposedIfNecessary() {
        if (this.isDisposed) {
            throw new IllegalStateException("NavigatorContentDescriptorInstance \"" + this.descriptor.getId() + "\" is disposed!");
        }
    }
}

