/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorActivationService;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorViewerDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.RegistryReader;

public class NavigatorContentDescriptorRegistry
extends RegistryReader {
    private static final NavigatorContentDescriptorRegistry INSTANCE = new NavigatorContentDescriptorRegistry();
    private static final NavigatorActivationService NAVIGATOR_ACTIVATION_SERVICE = NavigatorActivationService.getInstance();
    protected static final String NAVIGATOR_CONTENT = "navigatorContent";
    private static boolean isInitialized = false;
    private final Map contentDescriptors = new HashMap();
    private static final Comparator EXTENSION_COMPARATOR = new Comparator(){

        public int compare(Object lvalue, Object rvalue) {
            return ((NavigatorContentDescriptor)lvalue).getPriority() - ((NavigatorContentDescriptor)rvalue).getPriority();
        }
    };
    private ImageRegistry imageRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigatorContentDescriptorRegistry getInstance() {
        if (isInitialized) {
            return INSTANCE;
        }
        NavigatorContentDescriptorRegistry navigatorContentDescriptorRegistry = INSTANCE;
        synchronized (navigatorContentDescriptorRegistry) {
            if (!isInitialized) {
                INSTANCE.readRegistry();
                isInitialized = true;
            }
        }
        return INSTANCE;
    }

    public NavigatorContentDescriptorRegistry() {
        super(NavigatorPlugin.PLUGIN_ID, NAVIGATOR_CONTENT);
    }

    public NavigatorContentDescriptor[] getAllContentDescriptors() {
        NavigatorContentDescriptor[] finalDescriptors = new NavigatorContentDescriptor[this.contentDescriptors.size()];
        this.contentDescriptors.values().toArray(finalDescriptors);
        Arrays.sort(finalDescriptors, EXTENSION_COMPARATOR);
        return finalDescriptors;
    }

    public List getEnabledContentDescriptors(Object anElement) {
        ArrayList<NavigatorContentDescriptor> descriptors = new ArrayList<NavigatorContentDescriptor>();
        Iterator contentDescriptorsItr = this.contentDescriptors.values().iterator();
        while (contentDescriptorsItr.hasNext()) {
            NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)contentDescriptorsItr.next();
            if (!descriptor.isEnabledFor(anElement)) continue;
            descriptors.add(descriptor);
        }
        Collections.sort(descriptors, EXTENSION_COMPARATOR);
        return Collections.unmodifiableList(descriptors);
    }

    public List getEnabledContentDescriptors(IStructuredSelection aStructuredSelection) {
        ArrayList<NavigatorContentDescriptor> descriptors = new ArrayList<NavigatorContentDescriptor>();
        Iterator contentDescriptorsItr = this.contentDescriptors.values().iterator();
        while (contentDescriptorsItr.hasNext()) {
            NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)contentDescriptorsItr.next();
            if (!descriptor.isEnabledFor(aStructuredSelection)) continue;
            descriptors.add(descriptor);
        }
        Collections.sort(descriptors, EXTENSION_COMPARATOR);
        return Collections.unmodifiableList(descriptors);
    }

    public List getEnabledContentDescriptors(Object anElement, NavigatorViewerDescriptor aViewerDescriptor) {
        ArrayList<NavigatorContentDescriptor> descriptors = new ArrayList<NavigatorContentDescriptor>();
        Iterator contentDescriptorsItr = this.contentDescriptors.values().iterator();
        while (contentDescriptorsItr.hasNext()) {
            NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)contentDescriptorsItr.next();
            if (!NAVIGATOR_ACTIVATION_SERVICE.isNavigatorExtensionActive(aViewerDescriptor.getViewerId(), descriptor.getId()) || aViewerDescriptor.filtersContentDescriptor(descriptor) || !descriptor.isEnabledFor(anElement)) continue;
            descriptors.add(descriptor);
        }
        Collections.sort(descriptors, EXTENSION_COMPARATOR);
        return Collections.unmodifiableList(descriptors);
    }

    public NavigatorContentDescriptor getContentDescriptor(String id) {
        return (NavigatorContentDescriptor)this.contentDescriptors.get(id);
    }

    public void removeContentDescriptor(String id) {
        this.contentDescriptors.remove(id);
    }

    public String getText(String descriptorId) {
        NavigatorContentDescriptor descriptor = this.getContentDescriptor(descriptorId);
        if (descriptor != null) {
            return descriptor.getName();
        }
        return descriptorId;
    }

    public Image getImage(String descriptorId) {
        return this.retrieveAndStoreImage(descriptorId);
    }

    protected Image retrieveAndStoreImage(String descriptorId) {
        ImageDescriptor imageDescriptor;
        String icon;
        NavigatorContentDescriptor contentDescriptor = this.getContentDescriptor(descriptorId);
        Image image = null;
        if (contentDescriptor != null && (icon = contentDescriptor.getIcon()) != null && ((image = this.getImageRegistry().get(icon)) == null || image.isDisposed()) && (imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)contentDescriptor.getDeclaringPluginId(), (String)icon)) != null && (image = imageDescriptor.createImage()) != null) {
            this.getImageRegistry().put(icon, image);
        }
        return image;
    }

    protected boolean readElement(IConfigurationElement element) {
        if (NAVIGATOR_CONTENT.equals(element.getName())) {
            try {
                NavigatorContentDescriptor desc = new NavigatorContentDescriptor(element);
                this.addNavigatorContentDescriptor(desc);
                return true;
            }
            catch (WorkbenchException e) {
                NavigatorPlugin.log("Unable to create navigator descriptor.", e.getStatus());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNavigatorContentDescriptor(NavigatorContentDescriptor desc) {
        if (desc == null) {
            return;
        }
        Map map = this.contentDescriptors;
        synchronized (map) {
            this.contentDescriptors.put(desc.getId(), desc);
        }
    }

    private ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = new ImageRegistry();
        }
        return this.imageRegistry;
    }
}

