/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.extensions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorViewerDescriptor;

public class NavigatorRegistry {
    private Map rootContentDescriptors = new HashMap();
    private Map viewDescriptors = new HashMap();
    private List contentDescriptors = new ArrayList();

    void add(NavigatorContentDescriptor descriptor) {
        this.contentDescriptors.add(descriptor);
        Collections.sort(this.contentDescriptors, new Comparator(){

            public int compare(Object o1, Object o2) {
                NavigatorContentDescriptor descriptor1 = null;
                NavigatorContentDescriptor descriptor2 = null;
                if (o1 instanceof NavigatorContentDescriptor) {
                    descriptor1 = (NavigatorContentDescriptor)o1;
                }
                if (o2 instanceof NavigatorContentDescriptor) {
                    descriptor2 = (NavigatorContentDescriptor)o2;
                }
                if (descriptor1 != null && descriptor2 != null) {
                    return descriptor1.getPriority() - descriptor2.getPriority();
                }
                return -1;
            }
        });
    }

    void add(NavigatorViewerDescriptor descriptor) {
        ArrayList<NavigatorViewerDescriptor> list;
        String viewTargetId = descriptor.getViewerId();
        String id = descriptor.getRootExtensionId();
        NavigatorContentDescriptor extDesc = this.getContentDescriptor(id);
        if (extDesc != null) {
            list = (ArrayList<NavigatorViewerDescriptor>)this.rootContentDescriptors.get(viewTargetId);
            if (list == null) {
                list = new ArrayList<NavigatorViewerDescriptor>();
                this.rootContentDescriptors.put(viewTargetId, list);
            }
            extDesc.setRoot(true);
            list.add((NavigatorViewerDescriptor)((Object)extDesc));
        }
        if ((list = (List)this.viewDescriptors.get(viewTargetId)) == null) {
            list = new ArrayList();
            this.viewDescriptors.put(viewTargetId, list);
        }
        list.add(descriptor);
    }

    public NavigatorContentDescriptor getBestContentDescriptor(Object element) {
        NavigatorContentDescriptor extDescriptor = null;
        int priority = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.contentDescriptors.size()) {
            NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)this.contentDescriptors.get(i);
            if (descriptor.isEnabledFor(element) && descriptor.getPriority() < priority) {
                priority = descriptor.getPriority();
                extDescriptor = descriptor;
            }
            ++i;
        }
        return extDescriptor;
    }

    public NavigatorContentDescriptor[] getAllContentDescriptors() {
        NavigatorContentDescriptor[] finalDescriptors = new NavigatorContentDescriptor[this.contentDescriptors.size()];
        this.contentDescriptors.toArray(finalDescriptors);
        return finalDescriptors;
    }

    public List getEnabledContentDescriptors(Object element) {
        ArrayList<NavigatorContentDescriptor> descriptors = new ArrayList<NavigatorContentDescriptor>();
        int i = 0;
        while (i < this.contentDescriptors.size()) {
            NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)this.contentDescriptors.get(i);
            if (descriptor.isEnabledFor(element)) {
                descriptors.add(descriptor);
            }
            ++i;
        }
        return descriptors;
    }

    public NavigatorContentDescriptor getBestContentContributionDescriptor(Object element) {
        NavigatorContentDescriptor extDescriptor = null;
        int priority = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.contentDescriptors.size()) {
            NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)this.contentDescriptors.get(i);
            ActionExpression enablement = descriptor.getContributionEnablement();
            if (enablement == null) {
                if (descriptor.getPriority() < priority) {
                    extDescriptor = descriptor;
                }
            } else if (enablement.isEnabledFor(element) && descriptor.getPriority() < priority) {
                priority = descriptor.getPriority();
                extDescriptor = descriptor;
            }
            ++i;
        }
        return extDescriptor;
    }

    public NavigatorContentDescriptor getContentDescriptor(String id) {
        if (id == null) {
            return null;
        }
        int i = 0;
        while (i < this.contentDescriptors.size()) {
            NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)this.contentDescriptors.get(i);
            if (descriptor.getId().equals(id)) {
                return descriptor;
            }
            ++i;
        }
        return null;
    }

    public void removeContentDescriptor(String id) {
        int i = 0;
        while (i < this.contentDescriptors.size()) {
            NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)this.contentDescriptors.get(i);
            if (descriptor.getId().equals(id)) {
                this.contentDescriptors.remove(i);
            }
            ++i;
        }
    }

    public int getCategoryForContentDescriptor(String descriptorID) {
        return this.getCategoryForContentDescriptor(this.getContentDescriptor(descriptorID));
    }

    public int getBestCategory(Object element) {
        return this.getCategoryForContentDescriptor(this.getBestContentContributionDescriptor(element));
    }

    protected int getCategoryForContentDescriptor(NavigatorContentDescriptor descriptor) {
        if (descriptor != null) {
            return descriptor.getPriority();
        }
        return Integer.MAX_VALUE;
    }

    public List getRootContentDescriptors(String viewerId) {
        return (List)this.rootContentDescriptors.get(viewerId);
    }

    public List getViewDescriptors(String viewerId) {
        return (List)this.viewDescriptors.get(viewerId);
    }
}

