/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.extensions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.UIJob;

public class StructuredViewerManager {
    private Viewer viewer;
    private Object cachedOldInput;
    private Object cachedNewInput;

    public StructuredViewerManager(Viewer aViewer) {
        this.viewer = aViewer;
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public void inputChanged(Object anOldInput, Object aNewInput) {
        this.cachedOldInput = anOldInput;
        this.cachedNewInput = aNewInput;
    }

    public void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        this.viewer = aViewer;
        this.cachedOldInput = anOldInput;
        this.cachedNewInput = aNewInput;
    }

    public boolean initialize(IStructuredContentProvider aContentProvider) {
        boolean result = true;
        try {
            if (aContentProvider != null) {
                aContentProvider.inputChanged(this.viewer, this.cachedOldInput, this.cachedNewInput);
            }
        }
        catch (RuntimeException re) {
            System.err.println("Recovering from problem initializing Content Provider");
            re.printStackTrace();
            result = false;
        }
        return result;
    }

    public void safeRefresh() {
        UIJob refreshJob = new UIJob("Refresh Common Viewer Tree"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (StructuredViewerManager.this.viewer != null) {
                    StructuredViewerManager.this.viewer.refresh();
                }
                return Status.OK_STATUS;
            }
        };
        refreshJob.schedule();
    }
}

