/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.ICategory;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.VersionFormatException;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.IVersion;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetsManagerImpl;
import org.eclipse.wst.common.project.facet.core.internal.VersionMatchExpr;
import org.eclipse.wst.common.project.facet.core.internal.Versionable;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public final class ProjectFacet
extends Versionable
implements IProjectFacet {
    private static final Versionable.IVersionAdapter VERSION_ADAPTER = new Versionable.IVersionAdapter(){

        public String adapt(Object obj) {
            return ((IProjectFacetVersion)obj).getVersionString();
        }
    };
    private String id;
    private String plugin;
    private String label;
    private String description;
    private ICategory category;
    private final List actionDefinitions = new ArrayList();

    ProjectFacet() {
    }

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public String getPluginId() {
        return this.plugin;
    }

    void setPluginId(String plugin) {
        this.plugin = plugin;
    }

    public String getLabel() {
        return this.label;
    }

    void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
    }

    public ICategory getCategory() {
        return this.category;
    }

    void setCategory(ICategory category) {
        this.category = category;
    }

    public IProjectFacetVersion getVersion(String version) {
        IProjectFacetVersion fv = (IProjectFacetVersion)this.versions.get(version);
        if (fv == null) {
            String msg = "Could not find version " + version + " of project facet " + this.id + ".";
            throw new IllegalArgumentException(msg);
        }
        return fv;
    }

    void addVersion(IProjectFacetVersion version) {
        this.versions.add(version.getVersionString(), version);
    }

    public IProjectFacetVersion getLatestVersion() throws VersionFormatException, CoreException {
        Comparator comp = this.getVersionComparator(true, VERSION_ADAPTER);
        Object max = Collections.max(this.versions, comp);
        return (IProjectFacetVersion)max;
    }

    public IProjectFacetVersion getLatestSupportedVersion(IRuntime r) throws CoreException {
        Iterator itr = this.getSortedVersions(false).iterator();
        while (itr.hasNext()) {
            IProjectFacetVersion fv = (IProjectFacetVersion)itr.next();
            if (!r.supports(fv)) continue;
            return fv;
        }
        return null;
    }

    protected Versionable.IVersionAdapter getVersionAdapter() {
        return VERSION_ADAPTER;
    }

    ActionDefinition getActionDefinition(IProjectFacetVersion fv, IDelegate.Type type) throws CoreException {
        ActionDefinition result = null;
        Iterator itr = this.actionDefinitions.iterator();
        while (itr.hasNext()) {
            ActionDefinition def = (ActionDefinition)itr.next();
            if (def.type != type || !def.versionMatchExpr.evaluate((IVersion)((Object)fv))) continue;
            if (result == null) {
                result = def;
                continue;
            }
            String msg = Resources.bind(Resources.multipleActionDefinitions, fv.getProjectFacet().getId(), fv.getVersionString(), type.toString());
            FacetCorePlugin.log(msg);
            break;
        }
        return result;
    }

    void addActionDefinition(ActionDefinition actionDefinition) {
        this.actionDefinitions.add(actionDefinition);
    }

    public Object getAdapter(Class type) {
        return Platform.getAdapterManager().loadAdapter((Object)this, type.getName());
    }

    public String createVersionNotFoundErrMsg(String verstr) {
        return NLS.bind((String)ProjectFacetsManagerImpl.Resources.facetVersionNotDefinedNoPlugin, (Object)this.id, (Object)verstr);
    }

    public String toString() {
        return this.label;
    }

    static final class ActionDefinition {
        public IDelegate.Type type;
        public VersionMatchExpr versionMatchExpr;
        public String delegateClassName;
        public String configFactoryClassName;

        ActionDefinition() {
        }
    }

    public static final class Resources
    extends NLS {
        public static String multipleActionDefinitions;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.ProjectFacet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.ProjectFacet$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        public static String bind(String template, Object arg1, Object arg2, Object arg3) {
            return NLS.bind((String)template, (Object[])new Object[]{arg1, arg2, arg3});
        }
    }
}

