/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.IVersion;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetsManagerImpl;
import org.eclipse.wst.common.project.facet.core.internal.VersionMatchExpr;

public final class ProjectFacetRef {
    private final IProjectFacet f;
    private final VersionMatchExpr vexpr;

    public ProjectFacetRef(IProjectFacet f, VersionMatchExpr vexpr) {
        this.f = f;
        this.vexpr = vexpr;
    }

    public boolean check(Set facets) throws CoreException {
        Iterator itr = facets.iterator();
        while (itr.hasNext()) {
            IProjectFacetVersion fv = (IProjectFacetVersion)itr.next();
            if (this.f != fv.getProjectFacet()) continue;
            if (this.vexpr != null) {
                return this.vexpr.evaluate((IVersion)((Object)fv));
            }
            return true;
        }
        return false;
    }

    public static ProjectFacetRef read(IConfigurationElement config) {
        String id = config.getAttribute("id");
        if (id == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, "id");
            return null;
        }
        if (!ProjectFacetsManager.isProjectFacetDefined(id)) {
            ProjectFacetsManagerImpl.reportMissingFacet(id, config.getNamespace());
            return null;
        }
        IProjectFacet f = ProjectFacetsManager.getProjectFacet(id);
        String v = config.getAttribute("version");
        VersionMatchExpr vexpr = null;
        if (v != null) {
            try {
                vexpr = new VersionMatchExpr(f, v);
            }
            catch (CoreException e) {
                FacetCorePlugin.log(e.getStatus());
                return null;
            }
        }
        return new ProjectFacetRef(f, vexpr);
    }
}

