/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.ICategory;
import org.eclipse.wst.common.project.facet.core.IConstraint;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.IGroup;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.internal.Category;
import org.eclipse.wst.common.project.facet.core.internal.Constraint;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProject;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.internal.Group;
import org.eclipse.wst.common.project.facet.core.internal.IndexedSet;
import org.eclipse.wst.common.project.facet.core.internal.Preset;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacet;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.internal.ValidationProblem;
import org.eclipse.wst.common.project.facet.core.internal.VersionMatchExpr;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class ProjectFacetsManagerImpl {
    private static final String EXTENSION_ID = "facets";
    private static final Set facetsReportedMissing = new HashSet();
    private final IndexedSet facets = new IndexedSet();
    private final IndexedSet categories = new IndexedSet();
    private final IndexedSet presets = new IndexedSet();
    private final IndexedSet templates = new IndexedSet();
    private final IndexedSet groups = new IndexedSet();
    private final Map projects = new HashMap();

    public ProjectFacetsManagerImpl() {
        this.readMetadata();
        this.readUserPresets();
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ResourceChangeListener ls = new ResourceChangeListener();
        ws.addResourceChangeListener((IResourceChangeListener)ls, 1);
    }

    public Set getProjectFacets() {
        return this.facets.getUnmodifiable();
    }

    public boolean isProjectFacetDefined(String id) {
        return this.facets.containsKey(id);
    }

    public IProjectFacet getProjectFacet(String id) {
        IProjectFacet f = (IProjectFacet)this.facets.get(id);
        if (f == null) {
            String msg = "Could not find project facet " + id + ".";
            throw new IllegalArgumentException(msg);
        }
        return f;
    }

    public Set getCategories() {
        return this.categories.getUnmodifiable();
    }

    public boolean isCategoryDefined(String id) {
        return this.categories.containsKey(id);
    }

    public ICategory getCategory(String id) {
        ICategory category = (ICategory)this.categories.get(id);
        if (category == null) {
            String msg = "Could not find category " + id + ".";
            throw new IllegalArgumentException(msg);
        }
        return category;
    }

    public Set getPresets() {
        return this.presets.getUnmodifiable();
    }

    public boolean isPresetDefined(String id) {
        return this.presets.containsKey(id);
    }

    public IPreset getPreset(String id) {
        IPreset preset = (IPreset)this.presets.get(id);
        if (preset == null) {
            String msg = "Could not find preset " + id + ".";
            throw new IllegalArgumentException(msg);
        }
        return preset;
    }

    public IPreset definePreset(String name, Set facets) {
        return this.definePreset(name, facets, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPreset definePreset(String name, Set facets, boolean save) {
        IndexedSet indexedSet = this.presets;
        synchronized (indexedSet) {
            String id;
            int i = 0;
            do {
                id = ".usr." + i;
                ++i;
            } while (this.presets.containsKey(id));
            Preset preset = new Preset();
            preset.setId(id);
            preset.setLabel(name);
            preset.addProjectFacet(facets);
            preset.setUserDefined(true);
            this.presets.add(id, preset);
            if (save) {
                this.saveUserPresets();
            }
            return preset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deletePreset(IPreset preset) {
        IndexedSet indexedSet = this.presets;
        synchronized (indexedSet) {
            block5: {
                if (preset.isUserDefined()) break block5;
                return false;
            }
            boolean res = this.presets.delete(preset.getId());
            if (res) {
                this.saveUserPresets();
            }
            return res;
        }
    }

    public Set getTemplates() {
        return this.templates.getUnmodifiable();
    }

    public boolean isTemplateDefined(String id) {
        return this.templates.containsKey(id);
    }

    public IFacetedProjectTemplate getTemplate(String id) {
        IFacetedProjectTemplate template = (IFacetedProjectTemplate)this.templates.get(id);
        if (template == null) {
            String msg = "Could not find template " + id + ".";
            throw new IllegalArgumentException(msg);
        }
        return template;
    }

    public Set getGroups() {
        return this.groups.getUnmodifiable();
    }

    public boolean isGroupDefined(String id) {
        return this.groups.containsKey(id);
    }

    public IGroup getGroup(String id) {
        IGroup group = (IGroup)this.groups.get(id);
        if (group == null) {
            String msg = "Could not find group " + id + ".";
            throw new IllegalArgumentException(msg);
        }
        return group;
    }

    public Set getFacetedProjects() throws CoreException {
        return this.getFacetedProjects(null, null);
    }

    public Set getFacetedProjects(IProjectFacet f) throws CoreException {
        return this.getFacetedProjects(f, null);
    }

    public Set getFacetedProjects(IProjectFacetVersion fv) throws CoreException {
        return this.getFacetedProjects(null, fv);
    }

    private Set getFacetedProjects(IProjectFacet f, IProjectFacetVersion fv) throws CoreException {
        IProject[] all = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        HashSet<IFacetedProject> result = new HashSet<IFacetedProject>();
        int i = 0;
        while (i < all.length) {
            IProject proj = all[i];
            IFacetedProject fproj = this.create(proj);
            if (fproj != null && (f == null || fproj.hasProjectFacet(f)) && (fv == null || fproj.hasProjectFacet(fv))) {
                result.add(fproj);
            }
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFacetedProject create(IProject project) throws CoreException {
        if (project.isNatureEnabled("org.eclipse.wst.common.project.facet.core.nature")) {
            Map map = this.projects;
            synchronized (map) {
                FacetedProject fproj = (FacetedProject)this.projects.get(project.getName());
                if (fproj == null) {
                    fproj = new FacetedProject(project);
                    this.projects.put(project.getName(), fproj);
                } else {
                    fproj.refresh();
                }
                return fproj;
            }
        }
        return null;
    }

    public IFacetedProject create(IProject project, boolean convertIfNecessary, IProgressMonitor monitor) throws CoreException {
        IFacetedProject iFacetedProject;
        block4: {
            if (monitor != null) {
                monitor.beginTask("", 2);
            }
            try {
                if (project.exists() && convertIfNecessary) {
                    IProjectDescription description = project.getDescription();
                    String[] prevNatures = description.getNatureIds();
                    String[] newNatures = new String[prevNatures.length + 1];
                    System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
                    newNatures[prevNatures.length] = "org.eclipse.wst.common.project.facet.core.nature";
                    description.setNatureIds(newNatures);
                    project.setDescription(description, ProjectFacetsManagerImpl.submon(monitor, 1));
                }
                project.open(128, ProjectFacetsManagerImpl.submon(monitor, 1));
                iFacetedProject = this.create(project);
                Object var7_8 = null;
                if (monitor == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var7_9 = null;
                    if (monitor == null) break block5;
                    monitor.done();
                }
                throw throwable;
            }
            monitor.done();
        }
        return iFacetedProject;
    }

    public IFacetedProject create(String name, IPath location, IProgressMonitor monitor) throws CoreException {
        IFacetedProject iFacetedProject;
        block3: {
            if (monitor != null) {
                monitor.beginTask("", 2);
            }
            try {
                IWorkspace ws = ResourcesPlugin.getWorkspace();
                IProject project = ws.getRoot().getProject(name);
                IProjectDescription desc = ws.newProjectDescription(name);
                desc.setLocation(location);
                project.create(desc, ProjectFacetsManagerImpl.submon(monitor, 1));
                project.open(128, ProjectFacetsManagerImpl.submon(monitor, 1));
                desc.setNatureIds(new String[]{"org.eclipse.wst.common.project.facet.core.nature"});
                project.setDescription(desc, null);
                iFacetedProject = this.create(project);
                Object var7_8 = null;
                if (monitor == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var7_9 = null;
                    if (monitor == null) break block4;
                    monitor.done();
                }
                throw throwable;
            }
            monitor.done();
        }
        return iFacetedProject;
    }

    public IStatus check(Set base, Set actions) {
        IFacetedProject.Action action;
        ValidationProblem.Type ptype;
        Iterator itr2;
        IFacetedProject.Action action2;
        IProjectFacetVersion fv;
        MultiStatus result = Constraint.createMultiStatus();
        Iterator itr = actions.iterator();
        while (itr.hasNext()) {
            ValidationProblem.Type ptype2;
            IFacetedProject.Action action3 = (IFacetedProject.Action)itr.next();
            if (action3.getProjectFacetVersion().supports(action3.getType())) continue;
            if (action3.getType() == IFacetedProject.Action.Type.INSTALL) {
                ptype2 = ValidationProblem.Type.INSTALL_NOT_SUPPORTED;
            } else if (action3.getType() == IFacetedProject.Action.Type.UNINSTALL) {
                ptype2 = ValidationProblem.Type.UNINSTALL_NOT_SUPPORTED;
            } else if (action3.getType() == IFacetedProject.Action.Type.VERSION_CHANGE) {
                ptype2 = ValidationProblem.Type.VERSION_CHANGE_NOT_SUPPORTED;
            } else {
                throw new IllegalStateException();
            }
            fv = action3.getProjectFacetVersion();
            ValidationProblem vp = new ValidationProblem(ptype2, fv.getProjectFacet().getLabel(), fv.getVersionString());
            result.add((IStatus)vp);
        }
        HashMap<IProjectFacet, HashSet<IFacetedProject.Action>> facetToActionsMap = new HashMap<IProjectFacet, HashSet<IFacetedProject.Action>>();
        Iterator itr3 = actions.iterator();
        while (itr3.hasNext()) {
            action2 = (IFacetedProject.Action)itr3.next();
            IProjectFacet f = action2.getProjectFacetVersion().getProjectFacet();
            HashSet<IFacetedProject.Action> group = (HashSet<IFacetedProject.Action>)facetToActionsMap.get(f);
            if (group == null) {
                group = new HashSet<IFacetedProject.Action>();
                facetToActionsMap.put(f, group);
            }
            group.add(action2);
        }
        Iterator itr1 = facetToActionsMap.entrySet().iterator();
        while (itr1.hasNext()) {
            Map.Entry entry = itr1.next();
            Set group = (Set)entry.getValue();
            if (group.size() <= 1) continue;
            boolean bad = true;
            if (group.size() == 2) {
                IFacetedProject.Action install = null;
                IFacetedProject.Action uninstall = null;
                itr2 = group.iterator();
                while (itr2.hasNext()) {
                    IFacetedProject.Action action4 = (IFacetedProject.Action)itr2.next();
                    if (action4.getType() == IFacetedProject.Action.Type.INSTALL) {
                        install = action4;
                        continue;
                    }
                    if (action4.getType() != IFacetedProject.Action.Type.UNINSTALL) break;
                    uninstall = action4;
                }
                if (install != null && uninstall != null && base.contains(uninstall.getProjectFacetVersion())) {
                    bad = false;
                }
            }
            if (!bad) continue;
            ptype = ValidationProblem.Type.MULTIPLE_ACTIONS_NOT_SUPPORTED;
            result.add((IStatus)new ValidationProblem(ptype));
            break;
        }
        itr1 = actions.iterator();
        while (itr1.hasNext()) {
            action2 = (IFacetedProject.Action)((Object)itr1.next());
            fv = action2.getProjectFacetVersion();
            IProjectFacet f = fv.getProjectFacet();
            ptype = null;
            if (action2.getType() == IFacetedProject.Action.Type.UNINSTALL) {
                if (!base.contains(fv)) {
                    ptype = ValidationProblem.Type.CANNOT_UNINSTALL;
                }
            } else {
                IProjectFacetVersion existing = null;
                itr2 = base.iterator();
                while (itr2.hasNext()) {
                    IProjectFacetVersion temp = (IProjectFacetVersion)itr2.next();
                    if (temp.getProjectFacet() != f) continue;
                    existing = temp;
                    break;
                }
                if (action2.getType() == IFacetedProject.Action.Type.VERSION_CHANGE && existing == null) {
                    ptype = ValidationProblem.Type.CANNOT_CHANGE_VERSION;
                } else if (action2.getType() == IFacetedProject.Action.Type.INSTALL && existing != null) {
                    ptype = ValidationProblem.Type.FACET_ALREADY_INSTALLED;
                }
            }
            if (ptype == null) continue;
            result.add((IStatus)new ValidationProblem(ptype, f.getLabel(), fv.getVersionString()));
        }
        if (!result.isOK()) {
            return result;
        }
        HashSet all = new HashSet(base);
        Iterator itr4 = actions.iterator();
        while (itr4.hasNext()) {
            action = (IFacetedProject.Action)itr4.next();
            if (action.getType() != IFacetedProject.Action.Type.UNINSTALL) continue;
            ProjectFacetsManagerImpl.apply(all, action);
        }
        itr4 = actions.iterator();
        while (itr4.hasNext()) {
            action = (IFacetedProject.Action)itr4.next();
            if (action.getType() == IFacetedProject.Action.Type.UNINSTALL) continue;
            ProjectFacetsManagerImpl.apply(all, action);
        }
        itr4 = all.iterator();
        while (itr4.hasNext()) {
            IStatus st;
            fv = (IProjectFacetVersion)itr4.next();
            IConstraint constraint = fv.getConstraint();
            if (constraint == null || (st = constraint.check(all)).isOK()) continue;
            result.addAll(st);
        }
        HashSet<IStatus> problems = new HashSet<IStatus>();
        IStatus[] children = result.getChildren();
        int i = 0;
        while (i < children.length) {
            problems.add(children[i]);
            ++i;
        }
        HashSet<ValidationProblem> toremove = new HashSet<ValidationProblem>();
        Iterator itr5 = problems.iterator();
        while (itr5.hasNext()) {
            ValidationProblem problem = (ValidationProblem)((Object)itr5.next());
            if (toremove.contains((Object)problem)) {
                itr5.remove();
                continue;
            }
            if (problem.getType() != ValidationProblem.Type.CONFLICTS) continue;
            Object[] p = problem.getParameters();
            ValidationProblem reverse = new ValidationProblem(ValidationProblem.Type.CONFLICTS, new Object[]{p[1], p[0]});
            toremove.add(reverse);
        }
        if (children.length != problems.size()) {
            children = problems.toArray(new IStatus[problems.size()]);
            result = Constraint.createMultiStatus(children);
        }
        return result;
    }

    public void sort(Set base, List actions) {
        int count = actions.size();
        IStatus st = this.check(base, new HashSet(actions));
        if (!st.isOK()) {
            FacetCorePlugin.log(st);
            return;
        }
        int i = 0;
        int j = 0;
        while (j < count) {
            IFacetedProject.Action action = (IFacetedProject.Action)actions.get(j);
            if (action.getType() == IFacetedProject.Action.Type.UNINSTALL && i != j) {
                actions.set(j, actions.get(i));
                actions.set(i, action);
                ++i;
            }
            ++j;
        }
        HashSet fnl = new HashSet(base);
        Iterator itr = actions.iterator();
        while (itr.hasNext()) {
            ProjectFacetsManagerImpl.apply(fnl, (IFacetedProject.Action)itr.next());
        }
        boolean makeAnotherPass = true;
        block2: while (makeAnotherPass) {
            makeAnotherPass = false;
            HashSet state = new HashSet(base);
            int i2 = 0;
            while (i2 < count) {
                IFacetedProject.Action action = (IFacetedProject.Action)actions.get(i2);
                IFacetedProject.Action.Type type = action.getType();
                IProjectFacetVersion fv = action.getProjectFacetVersion();
                IConstraint constraint = fv.getConstraint();
                if (type == IFacetedProject.Action.Type.UNINSTALL) {
                    if (!constraint.check(state, true).isOK() && constraint.check(base, true).isOK()) {
                        ProjectFacetsManagerImpl.moveToFront(actions, i2);
                        makeAnotherPass = true;
                        continue block2;
                    }
                    ProjectFacetsManagerImpl.apply(state, action);
                    ++i2;
                    continue;
                }
                if (type == IFacetedProject.Action.Type.VERSION_CHANGE) {
                    HashSet copy = new HashSet(state);
                    ProjectFacetsManagerImpl.apply(state, action);
                    if (!constraint.check(copy, true).isOK() && constraint.check(fnl, true).isOK()) {
                        ProjectFacetsManagerImpl.moveToEnd(actions, i2);
                        continue;
                    }
                    state = copy;
                    ++i2;
                    continue;
                }
                if (constraint.check(state).isOK() && (constraint.check(state, true).isOK() || !constraint.check(fnl, true).isOK())) {
                    ProjectFacetsManagerImpl.apply(state, action);
                    ++i2;
                    continue;
                }
                ProjectFacetsManagerImpl.moveToEnd(actions, i2);
            }
        }
    }

    static void apply(Set facets, IFacetedProject.Action action) {
        IFacetedProject.Action.Type type = action.getType();
        IProjectFacetVersion fv = action.getProjectFacetVersion();
        if (type == IFacetedProject.Action.Type.INSTALL) {
            facets.add(fv);
        } else if (type == IFacetedProject.Action.Type.UNINSTALL) {
            facets.remove(fv);
        } else if (type == IFacetedProject.Action.Type.VERSION_CHANGE) {
            Iterator itr = facets.iterator();
            while (itr.hasNext()) {
                IProjectFacetVersion x = (IProjectFacetVersion)itr.next();
                if (x.getProjectFacet() != fv.getProjectFacet()) continue;
                itr.remove();
                break;
            }
            facets.add(fv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportMissingFacet(String fid, String plugin) {
        Set set = facetsReportedMissing;
        synchronized (set) {
            if (!facetsReportedMissing.contains(fid)) {
                String msg = Resources.bind((String)Resources.facetNotDefinedFromPlugin, (Object)fid, (Object)plugin);
                FacetCorePlugin.log(msg);
                facetsReportedMissing.add(fid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportMissingFacet(String fid, IProjectFacetVersion fv) {
        Set set = facetsReportedMissing;
        synchronized (set) {
            if (!facetsReportedMissing.contains(fid)) {
                String msg = Resources.bind(Resources.facetNotDefinedFromFacet, fid, fv.getProjectFacet().getId(), fv.getVersionString());
                FacetCorePlugin.log(msg);
                facetsReportedMissing.add(fid);
            }
        }
    }

    private static IProgressMonitor submon(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return null;
        }
        return new SubProgressMonitor(monitor, ticks);
    }

    private static void moveToFront(List actions, int index) {
        IFacetedProject.Action action = (IFacetedProject.Action)actions.get(index);
        int i = index;
        while (i > 0) {
            actions.set(i, actions.get(i - 1));
            --i;
        }
        actions.set(0, action);
    }

    private static void moveToEnd(List actions, int index) {
        IFacetedProject.Action action = (IFacetedProject.Action)actions.get(index);
        int i = index + 1;
        int n = actions.size();
        while (i < n) {
            actions.set(i - 1, actions.get(i));
            ++i;
        }
        actions.set(actions.size() - 1, action);
    }

    private void readMetadata() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.wst.common.project.facet.core", EXTENSION_ID);
        if (point == null) {
            throw new RuntimeException("Extension point not found!");
        }
        ArrayList<IConfigurationElement> cfgels = new ArrayList<IConfigurationElement>();
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                cfgels.add(elements[j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        int n = cfgels.size();
        while (i < n) {
            IConfigurationElement config = (IConfigurationElement)cfgels.get(i);
            if (config.getName().equals("category")) {
                this.readCategory(config);
            }
            ++i;
        }
        i = 0;
        n = cfgels.size();
        while (i < n) {
            IConfigurationElement config = (IConfigurationElement)cfgels.get(i);
            if (config.getName().equals("project-facet")) {
                this.readProjectFacet(config);
            }
            ++i;
        }
        i = 0;
        n = cfgels.size();
        while (i < n) {
            IConfigurationElement config = (IConfigurationElement)cfgels.get(i);
            if (config.getName().equals("project-facet-version")) {
                this.readProjectFacetVersion(config);
            }
            ++i;
        }
        i = 0;
        n = cfgels.size();
        while (i < n) {
            IConfigurationElement config = (IConfigurationElement)cfgels.get(i);
            if (config.getName().equals("action")) {
                this.readAction(config);
            }
            ++i;
        }
        i = 0;
        n = cfgels.size();
        while (i < n) {
            IConfigurationElement config = (IConfigurationElement)cfgels.get(i);
            if (config.getName().equals("preset")) {
                this.readPreset(config);
            }
            ++i;
        }
        i = 0;
        n = cfgels.size();
        while (i < n) {
            IConfigurationElement config = (IConfigurationElement)cfgels.get(i);
            if (config.getName().equals("template")) {
                this.readTemplate(config);
            }
            ++i;
        }
    }

    private void readCategory(IConfigurationElement config) {
        Category category = new Category();
        category.setPluginId(config.getDeclaringExtension().getNamespace());
        String id = config.getAttribute("id");
        if (id == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, "id");
            return;
        }
        category.setId(id);
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals("label")) {
                category.setLabel(child.getValue().trim());
            } else if (childName.equals("description")) {
                category.setDescription(child.getValue().trim());
            }
            ++i;
        }
        this.categories.add(id, category);
    }

    private void readProjectFacet(IConfigurationElement config) {
        String id = config.getAttribute("id");
        if (id == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, "id");
            return;
        }
        ProjectFacet descriptor = new ProjectFacet();
        descriptor.setId(id);
        descriptor.setPluginId(config.getDeclaringExtension().getNamespace());
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals("label")) {
                descriptor.setLabel(child.getValue().trim());
            } else if (childName.equals("description")) {
                descriptor.setDescription(child.getValue().trim());
            } else if (childName.equals("version-comparator")) {
                String clname = child.getAttribute("class");
                if (clname == null) {
                    ProjectFacetsManagerImpl.reportMissingAttribute(child, "class");
                    return;
                }
                descriptor.setVersionComparator(clname);
            } else if (childName.equals("category")) {
                String catname = child.getValue().trim();
                Category category = (Category)this.categories.get(catname);
                if (category == null) {
                    String msg = NLS.bind((String)Resources.categoryNotDefined, (Object)child.getNamespace(), (Object)catname);
                    FacetCorePlugin.log(msg);
                    return;
                }
                descriptor.setCategory(category);
                category.addProjectFacet(descriptor);
            }
            ++i;
        }
        this.facets.add(id, descriptor);
    }

    private void readProjectFacetVersion(IConfigurationElement config) {
        String childName;
        IConfigurationElement child;
        String fid = config.getAttribute("facet");
        if (fid == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, "facet");
            return;
        }
        String ver = config.getAttribute("version");
        if (ver == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, "version");
            return;
        }
        ProjectFacet f = (ProjectFacet)this.facets.get(fid);
        if (f == null) {
            ProjectFacetsManagerImpl.reportMissingFacet(fid, config.getNamespace());
            return;
        }
        ProjectFacetVersion fv = new ProjectFacetVersion();
        fv.setProjectFacet(f);
        fv.setVersionString(ver);
        fv.setPlugin(config.getDeclaringExtension().getNamespace());
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            child = children[i];
            childName = child.getName();
            if (childName.equals("constraint")) {
                IConfigurationElement[] ops = child.getChildren();
                ArrayList<IConstraint> parsed = new ArrayList<IConstraint>();
                int j = 0;
                while (j < ops.length) {
                    IConstraint op = this.readConstraint(ops[j], fv);
                    if (op != null) {
                        parsed.add(op);
                    }
                    ++j;
                }
                if (parsed.size() == 1) {
                    fv.setConstraint((IConstraint)parsed.get(0));
                } else if (parsed.size() > 1) {
                    Constraint and = new Constraint(fv, IConstraint.Type.AND, parsed.toArray());
                    fv.setConstraint(and);
                }
            } else if (childName.equals("group-member")) {
                String id = child.getAttribute("id");
                if (id == null) {
                    ProjectFacetsManagerImpl.reportMissingAttribute(child, "id");
                    return;
                }
                Group group = (Group)this.groups.get(id);
                if (group == null) {
                    group = new Group();
                    group.setId(id);
                    this.groups.add(id, group);
                }
                group.addMember(fv);
            }
            ++i;
        }
        f.addVersion(fv);
        i = 0;
        while (i < children.length) {
            child = children[i];
            childName = child.getName();
            if (childName.equals("action")) {
                this.readAction(child, f, ver);
            }
            ++i;
        }
    }

    private void readAction(IConfigurationElement config) {
        String fid = config.getAttribute("facet");
        if (fid == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, "facet");
            return;
        }
        ProjectFacet f = (ProjectFacet)this.facets.get(fid);
        if (f == null) {
            ProjectFacetsManagerImpl.reportMissingFacet(fid, config.getNamespace());
            return;
        }
        String ver = config.getAttribute("version");
        if (ver == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, "version");
            return;
        }
        this.readAction(config, f, ver);
    }

    private void readAction(IConfigurationElement config, ProjectFacet f, String version) {
        ProjectFacet.ActionDefinition def = new ProjectFacet.ActionDefinition();
        String type = config.getAttribute("type");
        if (type == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, "type");
            return;
        }
        if (type.equals("install")) {
            def.type = IDelegate.Type.INSTALL;
        } else if (type.equals("uninstall")) {
            def.type = IDelegate.Type.UNINSTALL;
        } else if (type.equals("version-change")) {
            def.type = IDelegate.Type.VERSION_CHANGE;
        } else if (type.equals("runtime-changed")) {
            def.type = IDelegate.Type.RUNTIME_CHANGED;
        } else {
            String msg = NLS.bind((String)Resources.invalidActionType, (Object)config.getNamespace(), (Object)type);
            FacetCorePlugin.log(msg);
            return;
        }
        try {
            def.versionMatchExpr = new VersionMatchExpr(f, version);
        }
        catch (CoreException e) {
            FacetCorePlugin.log((Exception)((Object)e));
            return;
        }
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            String clname;
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals("config-factory")) {
                clname = child.getAttribute("class");
                if (clname == null) {
                    ProjectFacetsManagerImpl.reportMissingAttribute(child, "class");
                    return;
                }
                def.configFactoryClassName = clname;
            } else if (childName.equals("delegate")) {
                clname = child.getAttribute("class");
                if (clname == null) {
                    ProjectFacetsManagerImpl.reportMissingAttribute(config, "class");
                    return;
                }
                def.delegateClassName = clname;
            }
            ++i;
        }
        f.addActionDefinition(def);
    }

    private IConstraint readConstraint(IConfigurationElement root, ProjectFacetVersion fv) {
        Object[] operands;
        IConstraint.Type type = IConstraint.Type.get(root.getName());
        if (type == IConstraint.Type.AND || type == IConstraint.Type.OR) {
            IConfigurationElement[] children = root.getChildren();
            operands = new IConstraint[children.length];
            int i = 0;
            while (i < children.length) {
                operands[i] = this.readConstraint(children[i], fv);
                ++i;
            }
        } else if (type == IConstraint.Type.REQUIRES) {
            String fid = root.getAttribute("facet");
            if (fid == null) {
                ProjectFacetsManagerImpl.reportMissingAttribute(root, "facet");
                return null;
            }
            String vexpr = root.getAttribute("version");
            if (vexpr == null) {
                ProjectFacetsManagerImpl.reportMissingAttribute(root, "version");
                return null;
            }
            String softStr = root.getAttribute("soft");
            Boolean soft = Boolean.FALSE;
            if (softStr != null && softStr.equals("true")) {
                soft = Boolean.TRUE;
            }
            operands = new Object[]{fid, vexpr, soft};
        } else if (type == IConstraint.Type.CONFLICTS) {
            String group = root.getAttribute("group");
            if (group == null) {
                ProjectFacetsManagerImpl.reportMissingAttribute(root, "group");
                return null;
            }
            operands = new Object[]{group};
        } else {
            throw new IllegalStateException();
        }
        return new Constraint(fv, type, operands);
    }

    private void readTemplate(IConfigurationElement config) {
        FacetedProjectTemplate template = new FacetedProjectTemplate();
        String id = config.getAttribute("id");
        if (id == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, "id");
            return;
        }
        template.setId(id);
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals("label")) {
                template.setLabel(child.getValue().trim());
            } else if (childName.equals("fixed")) {
                String fid = child.getAttribute("facet");
                if (fid == null) {
                    ProjectFacetsManagerImpl.reportMissingAttribute(child, "facet");
                    return;
                }
                if (!this.isProjectFacetDefined(fid)) {
                    ProjectFacetsManagerImpl.reportMissingFacet(fid, child.getNamespace());
                    return;
                }
                template.addFixedProjectFacet(this.getProjectFacet(fid));
            } else if (childName.equals("preset")) {
                String pid = child.getAttribute("id");
                if (pid == null) {
                    ProjectFacetsManagerImpl.reportMissingAttribute(child, "id");
                    return;
                }
                if (!this.isPresetDefined(pid)) {
                    String msg = NLS.bind((String)Resources.presetNotDefined, (Object)child.getNamespace(), (Object)pid);
                    FacetCorePlugin.log(msg);
                    return;
                }
                template.setInitialPreset(this.getPreset(pid));
            }
            ++i;
        }
        this.templates.add(id, template);
    }

    private void readPreset(IConfigurationElement config) {
        Preset preset = new Preset();
        String id = config.getAttribute("id");
        if (id == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, "id");
            return;
        }
        preset.setId(id);
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals("label")) {
                preset.setLabel(child.getValue().trim());
            } else if (childName.equals("facet")) {
                String fid = child.getAttribute("id");
                if (fid == null) {
                    ProjectFacetsManagerImpl.reportMissingAttribute(child, "id");
                    return;
                }
                String fver = child.getAttribute("version");
                if (fver == null) {
                    ProjectFacetsManagerImpl.reportMissingAttribute(child, "version");
                    return;
                }
                IProjectFacetVersion fv = this.getProjectFacet(fid).getVersion(fver);
                preset.addProjectFacet(fv);
            }
            ++i;
        }
        this.presets.add(id, preset);
    }

    static void reportMissingAttribute(IConfigurationElement el, String attribute) {
        Object[] params = new String[]{el.getNamespace(), el.getName(), attribute};
        String msg = NLS.bind((String)Resources.missingAttribute, (Object[])params);
        FacetCorePlugin.log(msg);
    }

    private void saveUserPresets() {
        try {
            Preferences root = ProjectFacetsManagerImpl.getUserPresetsPreferences();
            String[] children = root.childrenNames();
            int i = 0;
            while (i < children.length) {
                root.node(children[i]).removeNode();
                ++i;
            }
            Iterator itr = this.presets.iterator();
            while (itr.hasNext()) {
                IPreset preset = (IPreset)itr.next();
                if (!preset.isUserDefined()) continue;
                Preferences pnode = root.node(preset.getId());
                pnode.put("label", preset.getLabel());
                int counter = 1;
                Iterator itr2 = preset.getProjectFacets().iterator();
                while (itr2.hasNext()) {
                    IProjectFacetVersion f = (IProjectFacetVersion)itr2.next();
                    Preferences fnode = pnode.node(String.valueOf(counter));
                    fnode.put("id", f.getProjectFacet().getId());
                    fnode.put("version", f.getVersionString());
                    ++counter;
                }
            }
            root.flush();
        }
        catch (BackingStoreException e) {
            FacetCorePlugin.log((Exception)((Object)e));
        }
    }

    private void readUserPresets() {
        try {
            Preferences root = ProjectFacetsManagerImpl.getUserPresetsPreferences();
            String[] pkeys = root.childrenNames();
            int i = 0;
            while (i < pkeys.length) {
                Preferences pnode = root.node(pkeys[i]);
                String label = pnode.get("label", null);
                if (label != null) {
                    String[] fkeys = pnode.childrenNames();
                    HashSet<IProjectFacetVersion> facets = new HashSet<IProjectFacetVersion>();
                    int j = 0;
                    while (j < fkeys.length) {
                        IProjectFacet f;
                        Preferences fnode = pnode.node(fkeys[j]);
                        String id = fnode.get("id", null);
                        String version = fnode.get("version", null);
                        if (id == null || version == null) {
                            facets = null;
                            break;
                        }
                        if (this.isProjectFacetDefined(id)) {
                            f = this.getProjectFacet(id);
                            if (!f.hasVersion(version)) {
                                facets = null;
                                break;
                            }
                        } else {
                            facets = null;
                            break;
                        }
                        facets.add(f.getVersion(version));
                        ++j;
                    }
                    if (facets != null) {
                        this.definePreset(label, facets, false);
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (BackingStoreException e) {
            FacetCorePlugin.log((Exception)((Object)e));
        }
    }

    private static Preferences getUserPresetsPreferences() {
        InstanceScope scope = new InstanceScope();
        IEclipsePreferences pluginRoot = scope.getNode("org.eclipse.wst.common.project.facet.core");
        return pluginRoot.node("user.presets");
    }

    private final class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            Map map = ProjectFacetsManagerImpl.this.projects;
            synchronized (map) {
                Iterator itr = ProjectFacetsManagerImpl.this.projects.values().iterator();
                while (itr.hasNext()) {
                    FacetedProject fproj = (FacetedProject)itr.next();
                    IResourceDelta subdelta = delta.findMember(fproj.f.getFullPath());
                    if (subdelta == null) continue;
                    try {
                        fproj.refresh();
                    }
                    catch (CoreException e) {
                        FacetCorePlugin.log((Exception)((Object)e));
                    }
                }
            }
        }
    }

    public static final class Resources
    extends NLS {
        public static String missingAttribute;
        public static String categoryNotDefined;
        public static String facetNotDefinedFromPlugin;
        public static String facetNotDefinedFromFacet;
        public static String facetVersionNotDefined;
        public static String facetVersionNotDefinedNoPlugin;
        public static String presetNotDefined;
        public static String invalidActionType;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.ProjectFacetsManagerImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.ProjectFacetsManagerImpl$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        public static String bind(String template, Object arg1, Object arg2, Object arg3) {
            return NLS.bind((String)template, (Object[])new Object[]{arg1, arg2, arg3});
        }
    }
}

