/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.runtime.internal;

import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.VersionFormatException;
import org.eclipse.wst.common.project.facet.core.internal.Versionable;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.internal.RuntimeManagerImpl;

public final class RuntimeComponentType
extends Versionable
implements IRuntimeComponentType {
    private static final Versionable.IVersionAdapter VERSION_ADAPTER = new Versionable.IVersionAdapter(){

        public String adapt(Object obj) {
            return ((IRuntimeComponentVersion)obj).getVersionString();
        }
    };
    private String id;
    private String plugin;

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public String getPluginId() {
        return this.plugin;
    }

    void setPluginId(String plugin) {
        this.plugin = plugin;
    }

    void addVersion(IRuntimeComponentVersion ver) {
        this.versions.add(ver.getVersionString(), ver);
    }

    public IRuntimeComponentVersion getVersion(String version) {
        IRuntimeComponentVersion rcv = (IRuntimeComponentVersion)this.versions.get(version);
        if (rcv == null) {
            String msg = "Could not find version " + version + " of runtime component " + this.id + ".";
            throw new IllegalArgumentException(msg);
        }
        return rcv;
    }

    public IRuntimeComponentVersion getLatestVersion() throws VersionFormatException, CoreException {
        Comparator comp = this.getVersionComparator(true, VERSION_ADAPTER);
        Object max = Collections.max(this.versions, comp);
        return (IRuntimeComponentVersion)max;
    }

    public Object getAdapter(Class type) {
        return Platform.getAdapterManager().loadAdapter((Object)this, type.getName());
    }

    protected Versionable.IVersionAdapter getVersionAdapter() {
        return VERSION_ADAPTER;
    }

    public String createVersionNotFoundErrMsg(String verstr) {
        return NLS.bind((String)RuntimeManagerImpl.Resources.runtimeComponentVersionNotDefinedNoPlugin, (Object)this.id, (Object)verstr);
    }

    public String toString() {
        return this.id;
    }
}

