/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.contentproperties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.Logger;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CSSContentProperties {
    static final String CSSCORE_ID = CSSCorePlugin.getDefault().getBundle().getSymbolicName();
    private static final String PROJECT_KEY = "<project>";
    public static final String CSS_PROFILE = "css-profile";

    static String getKeyFor(IPath resourcePath) {
        String key = PROJECT_KEY;
        if (resourcePath != null && resourcePath.segmentCount() > 1) {
            key = resourcePath.removeFirstSegments(1).toString();
        }
        return key;
    }

    static Preferences getPreferences(IProject project, String preferenceKey, boolean create) {
        if (create) {
            return new ProjectScope(project).getNode(CSSCORE_ID).node(preferenceKey);
        }
        Preferences node = Platform.getPreferencesService().getRootNode().node("project");
        try {
            if (!node.nodeExists(project.getName())) {
                return null;
            }
            if (!(node = node.node(project.getName())).nodeExists(CSSCORE_ID)) {
                return null;
            }
            if (!(node = node.node(CSSCORE_ID)).nodeExists(preferenceKey)) {
                return null;
            }
            return node.node(preferenceKey);
        }
        catch (BackingStoreException e) {
            Logger.log(202, "Could not retrieve preference node", e);
            return null;
        }
    }

    public static String getProperty(String key, IResource resource, boolean recurse) {
        Preferences preferences;
        IProject project;
        String val = null;
        if (resource != null && (project = resource.getProject()) != null && (preferences = CSSContentProperties.getPreferences(project, key, false)) != null) {
            val = CSSContentProperties.internalGetProperty(resource, recurse, preferences);
        }
        return val;
    }

    private static String internalGetProperty(IResource resource, boolean recurse, Preferences preferences) {
        String value = preferences.get(CSSContentProperties.getKeyFor(resource.getFullPath()), null);
        if (value == null && resource != resource.getProject() && recurse) {
            value = preferences.get(CSSContentProperties.getKeyFor(null), null);
        }
        return value;
    }

    public static void setProperty(String key, IResource resource, String value) throws CoreException {
        IProject project;
        if (resource != null && (project = resource.getProject()) != null) {
            Preferences preferences = CSSContentProperties.getPreferences(project, key, true);
            if (value == null || value.trim().length() == 0) {
                preferences.remove(CSSContentProperties.getKeyFor(resource.getFullPath()));
            } else {
                preferences.put(CSSContentProperties.getKeyFor(resource.getFullPath()), value);
            }
            try {
                preferences.flush();
            }
            catch (BackingStoreException e) {
                throw new CoreException((IStatus)new Status(4, CSSCORE_ID, 4, "Unable to set property", (Throwable)e));
            }
        }
    }
}

