/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.contentproperties;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.css.core.internal.CSSCoreMessages;
import org.eclipse.wst.css.core.internal.Logger;
import org.eclipse.wst.css.core.internal.contentproperties.CSSContentProperties;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CSSContentPropertiesManager {
    private static CSSContentPropertiesManager _instance = null;
    private IResourceChangeListener fResourceChangeListener = new ResourceChangeListener();
    ContentPropertiesManagerJob fJob = new ContentPropertiesManagerJob();

    public static synchronized void startup() {
        _instance = new CSSContentPropertiesManager();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(CSSContentPropertiesManager._instance.fResourceChangeListener, 1);
    }

    public static synchronized void shutdown() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(CSSContentPropertiesManager._instance.fResourceChangeListener);
        _instance = null;
    }

    private class ContentPropertiesManagerJob
    extends Job {
        private static final int PROPERTIES_UPDATE_DELAY = 500;
        private List asyncChanges = new ArrayList();

        public ContentPropertiesManagerJob() {
            super(CSSCoreMessages.CSSContentPropertiesManager_Updating);
            this.setSystem(true);
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChanges(Set newChanges) {
            if (newChanges.isEmpty()) {
                return;
            }
            List list = this.asyncChanges;
            synchronized (list) {
                this.asyncChanges.addAll(newChanges);
                this.asyncChanges.notify();
            }
            this.schedule(500L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IProject getNextChange() {
            List list = this.asyncChanges;
            synchronized (list) {
                return this.asyncChanges.isEmpty() ? null : (IProject)this.asyncChanges.remove(this.asyncChanges.size() - 1);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            MultiStatus result;
            block10: {
                IStatus iStatus;
                result = new MultiStatus(CSSContentProperties.CSSCORE_ID, 382, CSSCoreMessages.CSSContentPropertiesManager_Updating, null);
                monitor = monitor == null ? new NullProgressMonitor() : monitor;
                try {
                    monitor.beginTask(CSSCoreMessages.CSSContentPropertiesManager_Updating, this.asyncChanges.size());
                    while (true) {
                        IProject next;
                        if ((next = this.getNextChange()) == null) {
                            monitor.worked(1);
                            break block10;
                        }
                        if (Platform.getBundle((String)"org.eclipse.osgi").getState() != 32) {
                            iStatus = Status.OK_STATUS;
                            Object var6_9 = null;
                            break;
                        }
                        try {
                            Preferences projectPrefs;
                            if (!next.isAccessible() || (projectPrefs = CSSContentProperties.getPreferences(next, "css-profile", false)) == null) continue;
                            projectPrefs.flush();
                        }
                        catch (BackingStoreException e) {
                            String detailMessage = NLS.bind((String)CSSCoreMessages.CSSContentPropertiesManager_Problems_Updating, (Object)next.getFullPath());
                            result.add((IStatus)new Status(4, "org.eclipse.core.resources", 382, detailMessage, (Throwable)e));
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
                return iStatus;
            }
            Object var6_11 = null;
            monitor.done();
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldRun() {
            List list = this.asyncChanges;
            synchronized (list) {
                return !this.asyncChanges.isEmpty();
            }
        }
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        private void processEntryChanges(IResourceDelta projectDelta, Set projectsToSave) {
            boolean resourceChanges = false;
            IProject currentProject = (IProject)projectDelta.getResource();
            resourceChanges = this.processPreferences(currentProject, "css-profile", projectDelta, projectsToSave);
            if (resourceChanges) {
                projectsToSave.add(currentProject);
            }
        }

        private boolean processPreferences(IProject currentProject, String key, IResourceDelta projectDelta, Set projectsToSave) {
            String[] affectedResources;
            boolean resourceChanges = false;
            Preferences projectPrefs = CSSContentProperties.getPreferences(currentProject, key, false);
            if (projectPrefs == null) {
                return false;
            }
            try {
                affectedResources = projectPrefs.keys();
            }
            catch (BackingStoreException e) {
                Logger.log(202, "Problem retreiving JSP Fragment preferences", e);
                return false;
            }
            int i = 0;
            while (i < affectedResources.length) {
                IResourceDelta memberDelta = projectDelta.findMember((IPath)new Path(affectedResources[i]));
                if (memberDelta != null && memberDelta.getKind() == 2) {
                    resourceChanges = true;
                    String currentValue = projectPrefs.get(affectedResources[i], null);
                    projectPrefs.remove(affectedResources[i]);
                    if ((memberDelta.getFlags() & 0x2000) != 0) {
                        IProject targetProject = ResourcesPlugin.getWorkspace().getRoot().getProject(memberDelta.getMovedToPath().segment(0));
                        Preferences targetPrefs = CSSContentProperties.getPreferences(targetProject, key, true);
                        targetPrefs.put(CSSContentProperties.getKeyFor(memberDelta.getMovedToPath()), currentValue);
                        if (targetProject != currentProject) {
                            projectsToSave.add(targetProject);
                        }
                    }
                }
                ++i;
            }
            return resourceChanges;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            IResourceDelta[] projectDeltas = delta.getAffectedChildren();
            HashSet projectsToSave = new HashSet();
            int i = 0;
            while (i < projectDeltas.length) {
                if (projectDeltas[i].getKind() == 4 && (projectDeltas[i].getFlags() & 0x4000) == 0) {
                    this.processEntryChanges(projectDeltas[i], projectsToSave);
                }
                ++i;
            }
            CSSContentPropertiesManager.this.fJob.addChanges(projectsToSave);
        }
    }
}

