/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import java.io.IOException;
import org.eclipse.wst.css.core.internal.Logger;
import org.eclipse.wst.css.core.internal.document.CSSRuleImpl;
import org.eclipse.wst.css.core.internal.provisional.adapters.IModelProvideAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSImportRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.css.core.internal.util.CSSLinkConverter;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.css.core.internal.util.URLModelProviderCSS;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

class CSSImportRuleImpl
extends CSSRuleImpl
implements ICSSImportRule {
    private boolean fDirty = true;
    private ICSSStyleSheet fStyleSheet;
    static /* synthetic */ Class class$0;

    CSSImportRuleImpl() {
    }

    CSSImportRuleImpl(CSSImportRuleImpl that) {
        super(that);
    }

    public ICSSNode cloneNode(boolean deep) {
        CSSImportRuleImpl cloned = new CSSImportRuleImpl(this);
        if (deep) {
            this.cloneChildNodes(cloned, deep);
        }
        return cloned;
    }

    void closeStyleSheet() {
        if (this.fStyleSheet != null) {
            IModelProvideAdapter adapter;
            ICSSStyleSheet sheet = this.fStyleSheet;
            this.fStyleSheet = null;
            sheet.getModel().removeStyleListener(this.getOwnerDocument().getModel());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.css.core.internal.provisional.adapters.IModelProvideAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IModelProvideAdapter)this.getAdapterFor(clazz)) != null) {
                adapter.modelRemoved(sheet.getModel());
            }
            sheet.getModel().releaseFromRead();
        }
    }

    public String getHref() {
        return CSSUtil.extractUriContents(this.getAttribute("href"));
    }

    public MediaList getMedia() {
        ICSSNode media = this.getFirstChild();
        if (media != null && media instanceof MediaList) {
            return (MediaList)((Object)media);
        }
        return null;
    }

    public short getNodeType() {
        return 3;
    }

    public CSSStyleSheet getStyleSheet() {
        if (this.fDirty) {
            try {
                Class<?> clazz;
                this.closeStyleSheet();
                if (this.getHref() == null || this.getHref().length() <= 0) {
                    this.fDirty = false;
                    return null;
                }
                ICSSModel baseModel = this.getOwnerDocument().getModel();
                if (this.getOwnerDocument().getModel().getStyleSheetType() == "embeddedCSS") {
                    baseModel = ((IDOMNode)this.getOwnerDocument().getModel().getOwnerDOMNode()).getModel();
                }
                if ((clazz = class$0) == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.css.core.internal.provisional.adapters.IModelProvideAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IModelProvideAdapter adapter = (IModelProvideAdapter)this.getAdapterFor(clazz);
                URLModelProviderCSS provider = new URLModelProviderCSS();
                IStructuredModel newModel = provider.getModelForRead(baseModel, this.getHref());
                this.fDirty = false;
                if (newModel == null) {
                    return null;
                }
                if (!(newModel instanceof ICSSModel)) {
                    newModel.releaseFromRead();
                    return null;
                }
                if (adapter != null) {
                    adapter.modelProvided(newModel);
                }
                this.fStyleSheet = (ICSSStyleSheet)((ICSSModel)newModel).getDocument();
                if (this.fStyleSheet != null) {
                    this.fStyleSheet.getModel().addStyleListener(this.getOwnerDocument().getModel());
                }
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
        return this.fStyleSheet;
    }

    public short getType() {
        return 3;
    }

    public void refreshStyleSheet() {
        if (!this.fDirty) {
            this.closeStyleSheet();
            this.fDirty = true;
            this.notify(1, this.getAttributeNode("href"), null, null, this.getStartOffset());
        }
    }

    void releaseRule() {
        if (this.fStyleSheet != null) {
            IModelProvideAdapter adapter;
            ICSSStyleSheet sheet = this.fStyleSheet;
            this.fStyleSheet = null;
            sheet.getModel().removeStyleListener(this.getOwnerDocument().getModel());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.css.core.internal.provisional.adapters.IModelProvideAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IModelProvideAdapter)this.getAdapterFor(clazz)) != null) {
                adapter.modelReleased(sheet.getModel());
            }
            sheet.getModel().releaseFromRead();
        }
    }

    public void setHref(String href) throws DOMException {
        this.fDirty = true;
        this.setAttribute("href", CSSLinkConverter.addFunc(href));
    }
}

