/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.metamodelimpl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.css.core.internal.Logger;
import org.eclipse.wst.css.core.internal.metamodel.CSSMetaModel;
import org.eclipse.wst.css.core.internal.metamodel.CSSProfile;
import org.eclipse.wst.css.core.internal.metamodelimpl.ProfileLoader;
import org.osgi.framework.Bundle;

class CSSProfileImpl
implements CSSProfile {
    String fID = null;
    String fName = null;
    URL fURL = null;
    CSSMetaModel fMetaModel = null;
    String fOwnerPluginID = null;
    boolean fDefault = false;
    boolean fLogging = false;

    private CSSProfileImpl() {
    }

    public CSSProfileImpl(String id, URL url) {
        this.fID = id;
        this.fURL = url;
    }

    public String getProfileID() {
        return this.fID;
    }

    public String getProfileName() {
        return this.fName == null ? this.fID : this.fName;
    }

    public CSSMetaModel getMetaModel() {
        if (this.fMetaModel == null) {
            try {
                InputStream input = this.getProfileURL().openStream();
                ProfileLoader loader = new ProfileLoader(this.getResourceBundle(), this.getLogging());
                this.fMetaModel = loader.loadProfile(input);
            }
            catch (IOException e) {
                Logger.logException("Cannot open stream for profile", e);
            }
        }
        return this.fMetaModel;
    }

    private ResourceBundle getResourceBundle() {
        String profileURLString;
        int lastSlashPos;
        Bundle bundle;
        ClassLoader targetLoader = null;
        String pluginID = this.getOwnerPluginID();
        if (pluginID != null && (bundle = Platform.getBundle((String)pluginID)) != null) {
            targetLoader = bundle.getClass().getClassLoader();
        }
        if (targetLoader == null) {
            targetLoader = this.getClass().getClassLoader();
        }
        if (1 < (lastSlashPos = (profileURLString = this.getProfileURL().toString()).lastIndexOf(47))) {
            String profileURLBase = profileURLString.substring(0, lastSlashPos + 1);
            try {
                URL[] urls = new URL[]{new URL(profileURLBase)};
                targetLoader = URLClassLoader.newInstance(urls, targetLoader);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        try {
            return ResourceBundle.getBundle("cssprofile", Locale.getDefault(), targetLoader);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public URL getProfileURL() {
        return this.fURL;
    }

    void setProfileName(String name) {
        this.fName = name;
    }

    public boolean isDefault() {
        return this.fDefault;
    }

    void setDefault(boolean isDefault) {
        this.fDefault = isDefault;
    }

    public String getOwnerPluginID() {
        return this.fOwnerPluginID;
    }

    void setOwnerPluginID(String pluginID) {
        this.fOwnerPluginID = pluginID;
    }

    void setLogging(boolean logging) {
        this.fLogging = logging;
    }

    boolean getLogging() {
        return this.fLogging;
    }
}

