/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.modelquery;

import java.util.Hashtable;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLCMDocumentFactory;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeEntry;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeRegistry;
import org.eclipse.wst.html.core.internal.modelquery.CMDocumentForBuddySystem;
import org.eclipse.wst.html.core.internal.modelquery.XHTMLAssociationProvider;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQueryCMProvider;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDocumentCache;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;

public class HTMLModelQueryCMProvider
implements ModelQueryCMProvider {
    private static CMDocument staticHTML = HTMLCMDocumentFactory.getCMDocument("HTML");
    private static CMDocument staticCHTML = HTMLCMDocumentFactory.getCMDocument("CHTML");
    private static HTMLDocumentTypeRegistry doctypeRegistry = HTMLDocumentTypeRegistry.getInstance();
    private static Hashtable buddyCache = new Hashtable();
    private XHTMLAssociationProvider xhtmlassoc = null;

    public HTMLModelQueryCMProvider(CMDocumentCache cache, URIResolver idResolver) {
        this.xhtmlassoc = new XHTMLAssociationProvider(cache, idResolver);
    }

    public CMDocument getCorrespondingCMDocument(Node node) {
        IDOMDocument owner = this.getOwnerXMLDocument(node);
        if (owner == null) {
            return null;
        }
        String pid = this.getPublicId(owner);
        if (pid == null) {
            return staticHTML;
        }
        HTMLDocumentTypeEntry entry = doctypeRegistry.getEntry(pid);
        if (entry == null) {
            return staticHTML;
        }
        pid = entry.getPublicId();
        CMDocument dtdcm = this.xhtmlassoc.getXHTMLCMDocument(pid, entry.getSystemId());
        if (dtdcm == null) {
            if (pid != null && pid.equals("-//W3C//DTD Compact HTML 1.0 Draft//EN")) {
                return staticCHTML;
            }
            return staticHTML;
        }
        CMDocument buddycm = (CMDocument)buddyCache.get(pid);
        if (buddycm != null) {
            return buddycm;
        }
        buddycm = new CMDocumentForBuddySystem(dtdcm, entry.isXMLType());
        buddyCache.put(pid, buddycm);
        return buddycm;
    }

    private IDOMDocument getOwnerXMLDocument(Node node) {
        Document owner;
        if (node == null) {
            return null;
        }
        Document document = owner = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        if (owner == null) {
            return null;
        }
        if (!(owner instanceof IDOMDocument)) {
            return null;
        }
        return (IDOMDocument)owner;
    }

    private String getPublicId(IDOMDocument doc) {
        if (doc == null) {
            return null;
        }
        DocumentType doctype = doc.getDoctype();
        return doctype != null ? doctype.getPublicId() : doc.getDocumentTypeId();
    }
}

