/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.common.preferences.ui;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.javascript.core.internal.JavaScriptCorePlugin;
import org.eclipse.wst.javascript.ui.internal.common.JSCommonUIMessages;
import org.eclipse.wst.javascript.ui.internal.common.preferences.JSCommonUIPreferenceNames;
import org.eclipse.wst.javascript.ui.internal.editor.JSEditorPlugin;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;

public class JavaScriptSourcePreferencePage
extends AbstractPreferencePage
implements ModifyListener,
SelectionListener,
IWorkbenchPreferencePage {
    protected Label fLineWidthLabel;
    protected Text fLineWidthText;
    protected Button fSplitMultiAttrs;
    protected Button fIndentUsingTabs;
    protected Button fClearAllBlankLines;
    protected Button fAutoPropose;
    protected Label fAutoProposeLabel;
    protected Text fAutoProposeText;
    protected Button fUseInferredGrammar;

    protected Preferences getModelPreferences() {
        return JavaScriptCorePlugin.getDefault().getPluginPreferences();
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        this.createContentsForContentAssistGroup(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.javascript.ui.webx0041");
        this.setSize(composite);
        this.loadPreferences();
        return composite;
    }

    protected void createContentsForContentAssistGroup(Composite parent) {
        Group contentAssistGroup = this.createGroup(parent, 2);
        contentAssistGroup.setText(JSCommonUIMessages.Content_assist_UI_);
        this.fAutoPropose = this.createCheckBox((Composite)contentAssistGroup, JSCommonUIMessages.Automatically_make_suggest_UI_);
        ((GridData)this.fAutoPropose.getLayoutData()).horizontalSpan = 2;
        this.fAutoPropose.addSelectionListener((SelectionListener)this);
        this.fAutoProposeLabel = this.createLabel((Composite)contentAssistGroup, JSCommonUIMessages.Prompt_when_these_characte_UI_);
        this.fAutoProposeText = this.createTextField((Composite)contentAssistGroup);
    }

    protected void performDefaults() {
        this.performDefaultsForContentAssistGroup();
        this.validateValues();
        this.enableValues();
        super.performDefaults();
    }

    protected void performDefaultsForContentAssistGroup() {
        this.fAutoPropose.setSelection(this.getPreferenceStore().getDefaultBoolean(JSCommonUIPreferenceNames.AUTO_PROPOSE));
        this.fAutoProposeText.setText(this.getPreferenceStore().getDefaultString(JSCommonUIPreferenceNames.AUTO_PROPOSE_CODE));
    }

    protected void initializeValues() {
        this.initializeValuesForContentAssistGroup();
    }

    protected void initializeValuesForContentAssistGroup() {
        this.fAutoPropose.setSelection(this.getPreferenceStore().getBoolean(JSCommonUIPreferenceNames.AUTO_PROPOSE));
        this.fAutoProposeText.setText(this.getPreferenceStore().getString(JSCommonUIPreferenceNames.AUTO_PROPOSE_CODE));
    }

    protected void validateValues() {
        boolean isError = false;
        String widthText = null;
        if (this.fLineWidthText != null) {
            try {
                widthText = this.fLineWidthText.getText();
                int formattingLineWidth = Integer.parseInt(widthText);
                if (formattingLineWidth < 0 || formattingLineWidth > 999) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setInvalidInputMessage(widthText);
                this.setValid(false);
                isError = true;
            }
        }
        if (!isError) {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    protected void enableValues() {
        if (this.fAutoPropose != null) {
            if (this.fAutoPropose.getSelection()) {
                this.fAutoProposeLabel.setEnabled(true);
                this.fAutoProposeText.setEnabled(true);
            } else {
                this.fAutoProposeLabel.setEnabled(false);
                this.fAutoProposeText.setEnabled(false);
            }
        }
    }

    protected void storeValues() {
        this.storeValuesForContentAssistGroup();
    }

    protected void storeValuesForContentAssistGroup() {
        this.getPreferenceStore().setValue(JSCommonUIPreferenceNames.AUTO_PROPOSE, this.fAutoPropose.getSelection());
        this.getPreferenceStore().setValue(JSCommonUIPreferenceNames.AUTO_PROPOSE_CODE, this.fAutoProposeText.getText());
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return JSEditorPlugin.getDefault().getPreferenceStore();
    }

    protected void doSavePreferenceStore() {
        JSEditorPlugin.getDefault().savePluginPreferences();
    }

    protected void createContentsForFormattingGroup(Composite parent) {
    }

    protected void performDefaultsForFormattingGroup() {
    }

    protected void initializeValuesForFormattingGroup() {
    }

    protected void storeValuesForFormattingGroup() {
    }

    protected void createContentsForGrammarConstraintsGroup(Composite parent) {
    }

    protected void performDefaultsForGrammarConstraintsGroup() {
    }

    protected void initializeValuesForGrammarConstraintsGroup() {
    }

    protected void storeValuesForGrammarConstraintsGroup() {
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.doSavePreferenceStore();
        return result;
    }
}

