/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.wizard;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.javascript.core.internal.JavaScriptCorePlugin;
import org.eclipse.wst.javascript.core.internal.contenttype.ContentTypeIdForJavaScript;
import org.eclipse.wst.javascript.ui.internal.editor.JSEditorPlugin;
import org.eclipse.wst.javascript.ui.internal.editor.JavaScriptUIMessages;
import org.eclipse.wst.javascript.ui.internal.editor.Logger;

public class NewJSWizard
extends Wizard
implements INewWizard {
    static String PAGE_IMAGE = "/icons/full/wizban/newjscriptfile_wiz.gif";
    private WizardNewFileCreationPage fNewFilePage;
    private IStructuredSelection fSelection;
    private IContentType fContentType;
    private List fValidExtensions = null;

    String addDefaultExtension(String filename) {
        StringBuffer newFileName = new StringBuffer(filename);
        Preferences preference = JavaScriptCorePlugin.getDefault().getPluginPreferences();
        String ext = preference.getString("defaultExtension");
        newFileName.append(".");
        newFileName.append(ext);
        return newFileName.toString();
    }

    IContentType getContentType() {
        if (this.fContentType == null) {
            this.fContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForJavaScript.ContentTypeID_JAVASCRIPT);
        }
        return this.fContentType;
    }

    List getValidExtensions() {
        if (this.fValidExtensions == null) {
            IContentType type = this.getContentType();
            this.fValidExtensions = new ArrayList<String>(Arrays.asList(type.getFileSpecs(8)));
        }
        return this.fValidExtensions;
    }

    public void addPages() {
        this.fNewFilePage = new WizardNewFileCreationPage("JSWizardNewFileCreationPage", (IStructuredSelection)new StructuredSelection(IDE.computeSelectedResources((IStructuredSelection)this.fSelection))){

            protected boolean validatePage() {
                IContentType type = NewJSWizard.this.getContentType();
                String fileName = this.getFileName();
                IPath fullPath = this.getContainerFullPath();
                if (fullPath != null && !fullPath.isEmpty() && fileName != null) {
                    if (fileName.lastIndexOf(46) != -1 && !type.isAssociatedWith(fileName)) {
                        this.setErrorMessage(NLS.bind((String)JavaScriptUIMessages._ERROR_FILENAME_MUST_END_JS, (Object)NewJSWizard.this.getValidExtensions().toString()));
                        return false;
                    }
                    if (fileName.lastIndexOf(46) == -1) {
                        String newFileName = NewJSWizard.this.addDefaultExtension(fileName);
                        IPath resourcePath = fullPath.append(newFileName);
                        IWorkspace workspace = ResourcesPlugin.getWorkspace();
                        IStatus result = workspace.validatePath(resourcePath.toString(), 2);
                        if (!result.isOK()) {
                            this.setErrorMessage(result.getMessage());
                            return false;
                        }
                        if (workspace.getRoot().getFolder(resourcePath).exists() || workspace.getRoot().getFile(resourcePath).exists()) {
                            this.setErrorMessage(JavaScriptUIMessages.ResourceGroup_nameExists);
                            return false;
                        }
                    }
                }
                this.setErrorMessage(null);
                return super.validatePage();
            }
        };
        this.fNewFilePage.setTitle(JavaScriptUIMessages._UI_WIZARD_NEW_HEADING);
        this.fNewFilePage.setDescription(JavaScriptUIMessages._UI_WIZARD_NEW_DESCRIPTION);
        this.addPage((IWizardPage)this.fNewFilePage);
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection aSelection) {
        this.fSelection = aSelection;
        this.setWindowTitle(JavaScriptUIMessages._UI_WIZARD_NEW_TITLE);
        if (PAGE_IMAGE != null) {
            ImageDescriptor descriptor = JSEditorPlugin.getDefault().getImageRegistry().getDescriptor(PAGE_IMAGE);
            if (descriptor == null) {
                descriptor = ImageDescriptor.createFromURL((URL)JSEditorPlugin.getDefault().getBundle().getEntry(PAGE_IMAGE));
                JSEditorPlugin.getDefault().getImageRegistry().put(PAGE_IMAGE, descriptor);
            }
            this.setDefaultPageImageDescriptor(descriptor);
        }
    }

    private void openEditor(final IFile file) {
        if (file != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        Logger.log(202, e.getMessage(), e);
                    }
                }
            });
        }
    }

    public boolean performFinish() {
        IFile file;
        boolean performedOK = false;
        String fileName = this.fNewFilePage.getFileName();
        if (fileName.lastIndexOf(46) == -1) {
            String newFileName = this.addDefaultExtension(fileName);
            this.fNewFilePage.setFileName(newFileName);
        }
        if ((file = this.fNewFilePage.createNewFile()) != null) {
            this.openEditor(file);
            performedOK = true;
        }
        return performedOK;
    }
}

