/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.core.connection;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionAdapter;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfoImpl;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManager;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManagerListener;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

public class ConnectionManagerImpl
implements ConnectionManager {
    private static final String CONNECTION_URI = "ConnectionURI";
    private static final String CONNECTION_URI_KEY = "ConnectionKey";
    public static final String CONNECTION = "connection/";
    public static final String PRODUCT = "Product";
    public static final String VERSION = "Version";
    public static final String LOADING_PATH = "LoadingPath";
    public static final String DRIVER_CLASS_NAME = "DriverClassName";
    public static final String URL = "URL";
    public static final String INFO_FILE_EXTENSION = "info";
    public static final String DATABASE_NAME = "DatabaseNameInternal";
    public static final String IDENTIFIER_QUOTE_STRING = "IdentiferQuoteString";
    public static final String DATABASE_PRODUCT_VERSION = "DatabaseProductVersion";
    public static final String FILTER = "filter";
    public static final String CUSTOM_PROPERTY_PREFIX = "@@_CUSTOMPROPERTY_";
    public static final ConnectionManagerImpl INSTANCE = new ConnectionManagerImpl();
    private Map infoMap = new HashMap();
    private Collection listeners = new LinkedList();
    private Map loaderMap = new HashMap();

    private ConnectionManagerImpl() {
    }

    public ConnectionInfo getConnectionInfo(DatabaseDefinition def) {
        if (def == null) {
            throw new NullPointerException();
        }
        if (this.infoMap.containsKey(def)) {
            return (ConnectionInfo)this.infoMap.get(def);
        }
        return this.loadConnectionInfo(def);
    }

    public ConnectionInfo getConnectionInfo(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.trim().equals("")) {
            throw new IllegalArgumentException();
        }
        String nameKey = name.toUpperCase();
        if (this.infoMap.containsKey(nameKey)) {
            return (ConnectionInfo)this.infoMap.get(nameKey);
        }
        return this.loadConnectionInfo(name);
    }

    public ConnectionInfo createConnectionInfo(DatabaseDefinition def, String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.trim().equals("")) {
            throw new IllegalArgumentException();
        }
        if (def == null) {
            throw new NullPointerException();
        }
        String nameKey = name.toUpperCase();
        if (this.infoMap.containsKey(nameKey)) {
            throw new IllegalArgumentException();
        }
        if (this.loadConnectionInfo(name) != null) {
            throw new IllegalArgumentException();
        }
        ConnectionInfoImpl info = new ConnectionInfoImpl(def, name);
        this.infoMap.put(nameKey, info);
        LinkedList c = new LinkedList();
        c.addAll(this.listeners);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            ConnectionManagerListener l = (ConnectionManagerListener)it.next();
            try {
                l.connectionInfoCreated(info);
            }
            catch (Throwable throwable) {
                this.removeListener(l);
            }
        }
        return info;
    }

    public ConnectionInfo[] getAllNamedConnectionInfo() {
        IPath path = RDBCorePlugin.getDefault().getStateLocation();
        File dir = (path = path.append(CONNECTION)).toFile();
        if (dir.exists()) {
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                String n;
                String nKey;
                if (files[i].isDirectory() && !this.infoMap.containsKey(nKey = (n = files[i].getName()).toUpperCase())) {
                    this.loadConnectionInfo(n);
                }
                ++i;
            }
        }
        Vector v = new Vector();
        Iterator it = this.infoMap.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (!(key instanceof String)) continue;
            v.add(this.infoMap.get(key));
        }
        Object[] namedInfo = new ConnectionInfo[v.size()];
        v.copyInto(namedInfo);
        return namedInfo;
    }

    public void removeConnectionInfo(String name) {
        IPath path;
        IPath infoPath;
        File dir;
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.trim().equals("")) {
            throw new IllegalArgumentException();
        }
        boolean removed = false;
        String nameKey = name.toUpperCase();
        if (this.infoMap.containsKey(nameKey)) {
            this.infoMap.remove(nameKey);
            removed = true;
        }
        if ((dir = (infoPath = (path = RDBCorePlugin.getDefault().getStateLocation()).append(CONNECTION + name)).toFile()).exists()) {
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                files[i].delete();
                ++i;
            }
            dir.delete();
            removed = true;
        }
        if (removed) {
            LinkedList c = new LinkedList();
            c.addAll(this.listeners);
            Iterator it = c.iterator();
            while (it.hasNext()) {
                ConnectionManagerListener l = (ConnectionManagerListener)it.next();
                try {
                    l.connectionInfoRemoved(name);
                }
                catch (Throwable throwable) {
                    this.removeListener(l);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public Connection connect(ConnectionInfo info) throws FileNotFoundException, ClassNotFoundException, IllegalAccessException, InstantiationException, SQLException {
        Driver driver = this.getDriver(info);
        Connection cnn = driver.connect(info.getURL(), info.getProperties());
        if (cnn == null) {
            return null;
        }
        ConnectionAdapter connection = new ConnectionAdapter(info, cnn);
        if (info.getIdentifierQuoteString() == null) {
            try {
                ((ConnectionInfoImpl)info).setIdentifierQuoteString(cnn.getMetaData().getIdentifierQuoteString());
            }
            catch (Throwable throwable) {}
        }
        if (info.getDatabaseProductVersion() == null) {
            try {
                ((ConnectionInfoImpl)info).setDatabaseProductVersion(cnn.getMetaData().getDatabaseProductVersion());
            }
            catch (Throwable throwable) {}
        }
        LinkedList c = new LinkedList();
        c.addAll(this.listeners);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            ConnectionManagerListener l = (ConnectionManagerListener)it.next();
            try {
                l.connected(info, connection);
            }
            catch (Throwable throwable) {
                this.removeListener(l);
            }
        }
        return connection;
    }

    public String getConnectionEAnnotationUri() {
        return CONNECTION_URI;
    }

    public String getConnectionEAnnotationKey() {
        return CONNECTION_URI_KEY;
    }

    public String[] getSchemaNames(Connection connection) throws SQLException {
        Vector<String> schemas = new Vector<String>();
        DatabaseMetaData meta = connection.getMetaData();
        if (meta.supportsCatalogsInTableDefinitions()) {
            connection.getCatalog();
        }
        ResultSet resultSet = meta.getSchemas();
        while (resultSet.next()) {
            String schemaName = resultSet.getString("TABLE_SCHEM");
            schemas.add(schemaName);
        }
        resultSet.close();
        Object[] result = new String[schemas.size()];
        schemas.copyInto(result);
        return result;
    }

    public void setConnectionInfo(SQLObject obj, String infoName) {
        if (infoName == null) {
            throw new NullPointerException();
        }
        EAnnotation annotation = obj.getEAnnotation(this.getConnectionEAnnotationUri());
        if (annotation == null) {
            annotation = obj.addEAnnotation(this.getConnectionEAnnotationUri());
        }
        obj.addEAnnotationDetail(annotation, this.getConnectionEAnnotationKey(), infoName);
    }

    public void setConnectionInfo(SQLObject obj, ConnectionInfo info) {
        this.setConnectionInfo(obj, info.getName());
    }

    public String getConnectionInfoName(SQLObject obj) {
        EAnnotation annotation = obj.getEAnnotation(this.getConnectionEAnnotationUri());
        if (annotation == null) {
            return null;
        }
        return obj.getEAnnotationDetail(annotation, this.getConnectionEAnnotationKey());
    }

    public ConnectionInfo getConnectionInfo(SQLObject obj) {
        String name = this.getConnectionInfoName(obj);
        if (name == null) {
            return null;
        }
        return this.getConnectionInfo(name);
    }

    public DriverPropertyInfo[] getDriverPropertyInfo(ConnectionInfo info) throws FileNotFoundException, SQLException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Driver driver = this.getDriver(info);
        return driver.getPropertyInfo(info.getURL(), info.getProperties());
    }

    public boolean addListener(ConnectionManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            if (listener != it.next()) continue;
            return false;
        }
        this.listeners.add(listener);
        return true;
    }

    public boolean removeListener(ConnectionManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            if (listener != it.next()) continue;
            it.remove();
            return true;
        }
        return false;
    }

    void rename(String oldName, String newName) {
        String oldNameKey = oldName.toUpperCase();
        String newNameKey = newName.toUpperCase();
        Object info = this.infoMap.get(oldNameKey);
        if (info == null) {
            throw new IllegalStateException();
        }
        this.infoMap.remove(oldNameKey);
        this.infoMap.put(newNameKey, info);
        IPath path = RDBCorePlugin.getDefault().getStateLocation();
        IPath oldPath = path.append(CONNECTION + oldName);
        IPath newPath = path.append(CONNECTION + newName);
        File oldFile = oldPath.toFile();
        File newFile = newPath.toFile();
        if (!oldFile.exists()) {
            oldFile.renameTo(newFile);
        }
        LinkedList c = new LinkedList();
        c.addAll(this.listeners);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            ConnectionManagerListener l = (ConnectionManagerListener)it.next();
            try {
                l.connectionInfoRenamed(oldName, (ConnectionInfo)info);
            }
            catch (Throwable throwable) {
                this.removeListener(l);
            }
        }
    }

    void disconnect(ConnectionInfo info, Connection connection) {
        LinkedList c = new LinkedList();
        c.addAll(this.listeners);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            ConnectionManagerListener l = (ConnectionManagerListener)it.next();
            try {
                l.disconnected(info, connection);
            }
            catch (Throwable throwable) {
                this.removeListener(l);
            }
        }
    }

    private Driver getDriver(ConnectionInfo info) throws FileNotFoundException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        return this.getDriver(info.getLoadingPath(), info.getDriverClassName());
    }

    private Driver getDriver(String loadingPath, String driverClassName) throws FileNotFoundException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        URL[] urls = this.getURLs(loadingPath);
        String key = this.getLoaderKey(urls);
        if (!this.loaderMap.containsKey(key)) {
            URLClassLoader l = new URLClassLoader(urls, this.getClass().getClassLoader());
            this.loaderMap.put(key, l);
        }
        ClassLoader loader = (ClassLoader)this.loaderMap.get(key);
        return (Driver)loader.loadClass(driverClassName).newInstance();
    }

    private URL[] getURLs(String loadingPath) throws FileNotFoundException {
        if (loadingPath == null) {
            return new URL[0];
        }
        ArrayList<URL> urls = new ArrayList<URL>(3);
        StringTokenizer st = new StringTokenizer(loadingPath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String fileName = st.nextToken();
            File file = new File(fileName);
            if (file.exists()) {
                try {
                    URL url = file.toURL();
                    urls.add(url);
                }
                catch (MalformedURLException malformedURLException) {}
                continue;
            }
            throw new FileNotFoundException(fileName);
        }
        URL[] urlArray = new URL[urls.size()];
        return urls.toArray(urlArray);
    }

    private String getLoaderKey(URL[] urls) {
        String key = "";
        int i = 0;
        while (i < urls.length) {
            key = String.valueOf(key) + urls[i].getPath();
            ++i;
        }
        return key;
    }

    private ConnectionInfo loadConnectionInfo(String infoName) {
        IPath path = RDBCorePlugin.getDefault().getStateLocation();
        File file = (path = path.append(CONNECTION + infoName + "/connection.info")).toFile();
        if (!file.exists()) {
            return null;
        }
        ConnectionInfoImpl info = new ConnectionInfoImpl(null, infoName);
        try {
            Properties properties = new Properties();
            FileInputStream input = new FileInputStream(file);
            properties.load(input);
            String product = null;
            String version = null;
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (name.equals(LOADING_PATH)) {
                    info.setLoadingPath(properties.getProperty(name));
                    continue;
                }
                if (name.equals(DRIVER_CLASS_NAME)) {
                    info.setDriverClassName(properties.getProperty(name));
                    continue;
                }
                if (name.equals(URL)) {
                    info.setURL(properties.getProperty(name));
                    continue;
                }
                if (name.equals(PRODUCT)) {
                    product = properties.getProperty(name);
                    continue;
                }
                if (name.equals(VERSION)) {
                    version = properties.getProperty(name);
                    continue;
                }
                if (name.equals(IDENTIFIER_QUOTE_STRING)) {
                    info.setIdentifierQuoteString(properties.getProperty(name));
                    continue;
                }
                if (name.equals(DATABASE_PRODUCT_VERSION)) {
                    info.setDatabaseProductVersion(properties.getProperty(name));
                    continue;
                }
                if (name.equals(DATABASE_NAME)) {
                    info.setDatabaseName(properties.getProperty(name));
                    continue;
                }
                if (name.startsWith(CUSTOM_PROPERTY_PREFIX)) {
                    info.setCustomProperty(name.substring(CUSTOM_PROPERTY_PREFIX.length()), properties.getProperty(name));
                    continue;
                }
                info.getProperties().setProperty(name, properties.getProperty(name));
            }
            ((InputStream)input).close();
            info.setDatabaseDefinition(RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(product, version));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
        String infoNameKey = infoName.toUpperCase();
        this.infoMap.put(infoNameKey, info);
        return info;
    }

    private ConnectionInfo loadConnectionInfo(DatabaseDefinition def) {
        ConnectionInfoImpl info = new ConnectionInfoImpl(def, null);
        IPath path = RDBCorePlugin.getDefault().getStateLocation();
        path = path.append(CONNECTION);
        String filename = String.valueOf(def.getProduct()) + " " + def.getVersion() + "." + INFO_FILE_EXTENSION;
        File file = (path = path.append(filename)).toFile();
        if (file.exists()) {
            try {
                Properties properties = new Properties();
                FileInputStream input = new FileInputStream(file);
                properties.load(input);
                Enumeration<?> e = properties.propertyNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    if (name.equals(LOADING_PATH)) {
                        info.setLoadingPath(properties.getProperty(name));
                        continue;
                    }
                    if (name.equals(DRIVER_CLASS_NAME)) {
                        info.setDriverClassName(properties.getProperty(name));
                        continue;
                    }
                    if (name.equals(URL)) {
                        info.setURL(properties.getProperty(name));
                        continue;
                    }
                    info.getProperties().setProperty(name, properties.getProperty(name));
                }
                ((InputStream)input).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        }
        this.infoMap.put(def, info);
        return info;
    }
}

