/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.derby.catalog;

import com.ibm.icu.util.StringTokenizer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.core.rte.RefreshManager;
import org.eclipse.wst.rdb.internal.derby.DerbyPlugin;
import org.eclipse.wst.rdb.internal.derby.catalog.DerbyCatalogDatabase;
import org.eclipse.wst.rdb.internal.derby.catalog.DerbyCatalogParameter;
import org.eclipse.wst.rdb.internal.models.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.PredefinedDataType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.SQLDataType;
import org.eclipse.wst.rdb.internal.models.sql.routines.DataAccess;
import org.eclipse.wst.rdb.internal.models.sql.routines.ParameterMode;
import org.eclipse.wst.rdb.internal.models.sql.routines.Routine;
import org.eclipse.wst.rdb.internal.models.sql.routines.impl.ProcedureImpl;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;

public class DerbyCatalogProcedure
extends ProcedureImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3691042079895859506L;
    static final String rsKeyword = "RESULT SETS";
    private boolean loaded = false;
    private boolean parameterLoaded = false;

    public void refresh() {
        if (this.parameterLoaded) {
            this.parameters.clear();
            this.parameterLoaded = false;
        }
        this.loaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((DerbyCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public EList getParameters() {
        if (!this.parameterLoaded) {
            this.loadParameters();
        }
        return this.parameters;
    }

    public String getExternalName() {
        if (!this.loaded) {
            this.load();
        }
        return this.externalName;
    }

    public String getLanguage() {
        if (!this.loaded) {
            this.load();
        }
        return this.language;
    }

    public int getMaxResultSets() {
        if (!this.loaded) {
            this.load();
        }
        return this.maxResultSets;
    }

    public String getParameterStyle() {
        if (!this.loaded) {
            this.load();
        }
        return this.parameterStyle;
    }

    public DataAccess getSqlDataAccess() {
        if (!this.loaded) {
            this.load();
        }
        return this.sqlDataAccess;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 15) {
            this.getParameters();
        } else if (id == 14) {
            this.getExternalName();
        } else if (id == 6) {
            this.getLanguage();
        } else if (id == 18) {
            this.getMaxResultSets();
        } else if (id == 7) {
            this.getParameterStyle();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadParameters() {
        if (this.parameterLoaded) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            DerbyCatalogProcedure.loadParameters(this.getConnection(), super.getParameters(), (Routine)this);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.parameterLoaded = true;
        this.eSetDeliver(deliver);
    }

    public static void loadParameters(Connection connection, EList parameterList, Routine routine) throws SQLException {
        Database database = routine.getSchema().getDatabase();
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        databaseDefinition.getDataModelElementFactory();
        DatabaseMetaData metaData = connection.getMetaData();
        ResultSet r = metaData.getProcedureColumns(null, routine.getSchema().getName(), routine.getName(), null);
        try {
            while (r.next()) {
                DerbyCatalogParameter parameter = new DerbyCatalogParameter();
                String name = r.getString(4);
                parameter.setName(name);
                short columntype = r.getShort(5);
                if (columntype == 2) {
                    parameter.setMode(ParameterMode.INOUT_LITERAL);
                } else if (columntype == 4) {
                    parameter.setMode(ParameterMode.OUT_LITERAL);
                } else if (columntype == 1) {
                    parameter.setMode(ParameterMode.IN_LITERAL);
                }
                String typeName = r.getString(7);
                PredefinedDataTypeDefinition typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(typeName);
                if (typeDefinition != null) {
                    EStructuralFeature feature;
                    int length;
                    PredefinedDataType type = databaseDefinition.getPredefinedDataType(typeDefinition);
                    if (typeDefinition.isLengthSupported()) {
                        length = r.getInt(9);
                        feature = type.eClass().getEStructuralFeature("length");
                        type.eSet(feature, (Object)new Integer(length));
                    } else if (typeDefinition.isPrecisionSupported()) {
                        length = r.getInt(8);
                        feature = type.eClass().getEStructuralFeature("precision");
                        type.eSet(feature, (Object)new Integer(length));
                    }
                    if (typeDefinition.isScaleSupported()) {
                        length = r.getInt(10);
                        feature = type.eClass().getEStructuralFeature("scale");
                        type.eSet(feature, (Object)new Integer(length));
                    }
                    parameter.setContainedType((SQLDataType)type);
                }
                parameterList.add((Object)parameter);
            }
            r.close();
        }
        catch (Exception exception) {}
    }

    private synchronized void load() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection connection = this.getConnection();
        RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase()).getDataModelElementFactory();
        try {
            String sql = "SELECT ALIAS,JAVACLASSNAME,ALIASINFO FROM SYS.SYSALIASES A,SYS.SYSSCHEMAS B WHERE A.SCHEMAID=B.SCHEMAID AND B.SCHEMANAME = ?  AND A.ALIAS = ?";
            PreparedStatement stmt = connection.prepareStatement(sql);
            stmt.setString(1, this.getSchema().getName());
            stmt.setString(2, this.getName());
            ResultSet r = stmt.executeQuery();
            while (r.next()) {
                this.language = "JAVA";
                this.parameterStyle = "JAVA";
                String javaClassName = r.getString(2);
                Object aliasInfo = r.getObject(3);
                this.setRestOfMetaData(javaClassName, aliasInfo);
            }
            r.close();
            stmt.close();
        }
        catch (Exception e) {
            Status status = new Status(4, DerbyPlugin.getDefault().getBundle().getSymbolicName(), 4, "###Error..org.eclipse.wst.rdb.internal.derby.catalog.DerbyCatalogProcedure.setRestOfMetaData", (Throwable)e);
            DerbyPlugin.getDefault().getLog().log((IStatus)status);
        }
        this.eSetDeliver(deliver);
    }

    protected void setRestOfMetaData(String javaClassName, Object aliasInfo) {
        try {
            String aliasInfoString = aliasInfo.toString();
            this.setSqlDataAccess(aliasInfoString);
            int index = aliasInfoString.lastIndexOf(rsKeyword);
            if (index != -1) {
                StringTokenizer tokenizer = new StringTokenizer(aliasInfoString.substring(index + rsKeyword.length()));
                String nextToken = tokenizer.nextToken();
                try {
                    int resultSets = Integer.parseInt(nextToken);
                    this.setMaxResultSets(resultSets);
                }
                catch (Exception exception) {}
            }
            index = aliasInfoString.indexOf("(");
            String methodName = aliasInfoString.substring(0, index);
            this.setExternalName(String.valueOf(javaClassName) + "." + methodName);
        }
        catch (Exception e) {
            Status status = new Status(4, DerbyPlugin.getDefault().getBundle().getSymbolicName(), 4, "###Error..org.eclipse.wst.rdb.internal.derby.catalog.DerbyCatalogProcedure.load", (Throwable)e);
            DerbyPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    protected void setSqlDataAccess(String aliasInfo) {
        int index = aliasInfo.indexOf("NO SQL");
        if (index != -1) {
            this.setSqlDataAccess(DataAccess.NO_SQL_LITERAL);
        } else {
            index = aliasInfo.indexOf("MODIFIES SQL DATA");
            if (index != -1) {
                this.setSqlDataAccess(DataAccess.MODIFIES_SQL_DATA_LITERAL);
            } else {
                index = aliasInfo.indexOf("CONTAINS SQL");
                if (index != -1) {
                    this.setSqlDataAccess(DataAccess.CONTAINS_SQL_LITERAL);
                } else {
                    index = aliasInfo.indexOf("READS SQL DATA");
                    if (index != -1) {
                        this.setSqlDataAccess(DataAccess.READS_SQL_DATA_LITERAL);
                    }
                }
            }
        }
    }
}

