/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerType;
import org.eclipse.wst.server.core.util.PublishAdapter;
import org.eclipse.wst.server.ui.ServerUIUtil;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.ServerUIPreferences;
import org.eclipse.wst.server.ui.internal.TerminationDialog;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.actions.RunOnServerActionDelegate;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorCore;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorInput;
import org.eclipse.wst.server.ui.internal.viewers.InitialSelectionProvider;
import org.eclipse.wst.server.ui.internal.wizard.ClosableWizardDialog;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.WizardTaskUtil;
import org.eclipse.wst.server.ui.internal.wizard.fragment.NewRuntimeWizardFragment;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.osgi.framework.BundleContext;

public class ServerUIPlugin
extends AbstractUIPlugin {
    protected static final String VIEW_ID = "org.eclipse.wst.server.ui.ServersView";
    public static final String PLUGIN_ID = "org.eclipse.wst.server.ui";
    protected static final String EXTENSION_SERVER_IMAGES = "serverImages";
    private static final String EXTENSION_WIZARD_FRAGMENTS = "wizardFragments";
    public static final String EXTENSION_EDITOR_PAGES = "editorPages";
    public static final String EXTENSION_EDITOR_PAGE_SECTIONS = "editorPageSections";
    public static final byte STOP = 1;
    private static ServerUIPlugin singleton;
    protected Map imageDescriptors = new HashMap();
    private static Map wizardFragments;
    private static InitialSelectionProvider selectionProvider;
    private static IRegistryChangeListener registryListener;
    protected static List terminationWatches;
    protected IServerLifecycleListener serverLifecycleListener = new IServerLifecycleListener(){

        public void serverAdded(IServer server) {
            server.addServerListener(serverListener);
            ((Server)server).addPublishListener(publishListener);
        }

        public void serverChanged(IServer server) {
        }

        public void serverRemoved(IServer server) {
            server.removeServerListener(serverListener);
            ((Server)server).removePublishListener(publishListener);
        }
    };
    protected static IServerListener serverListener;
    protected static IPublishListener publishListener;
    static /* synthetic */ Class class$0;

    static {
        terminationWatches = new ArrayList();
        serverListener = new IServerListener(){

            public void serverChanged(ServerEvent event) {
                int eventKind = event.getKind();
                if ((eventKind & 1) != 0) {
                    ServerUIPlugin.showServersView(true);
                } else if ((eventKind & 0x10) != 0) {
                    ServerUIPlugin.showServersView(false);
                }
            }
        };
        publishListener = new PublishAdapter(){

            public void publishStarted(IServer server) {
                ServerUIPlugin.showServersView(false);
            }

            public void publishFinished(IServer server, IStatus status) {
                ServerUIPlugin.showServersView(false);
            }
        };
    }

    public ServerUIPlugin() {
        singleton = this;
    }

    public static ServerUIPlugin getInstance() {
        return singleton;
    }

    public static void log(IStatus status) {
        ServerUIPlugin.getInstance().getLog().log(status);
    }

    public static ServerUIPreferences getPreferences() {
        return new ServerUIPreferences();
    }

    public void start(BundleContext context) throws Exception {
        Trace.trace(Trace.CONFIG, "----->----- Server UI plugin start ----->-----");
        super.start(context);
        ServerUIPreferences prefs = ServerUIPlugin.getPreferences();
        prefs.setDefaults();
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this.serverLifecycleListener);
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                servers[i].addServerListener(serverListener);
                ((Server)servers[i]).addPublishListener(publishListener);
                ++i;
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        Trace.trace(Trace.CONFIG, "-----<----- Server UI plugin stop -----<-----");
        super.stop(context);
        if (registryListener != null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.removeRegistryChangeListener(registryListener);
        }
        ImageResource.dispose();
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                servers[i].removeServerListener(serverListener);
                ((Server)servers[i]).removePublishListener(publishListener);
                ++i;
            }
        }
        ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this.serverLifecycleListener);
    }

    public static void addTerminationWatch(Shell shell, IServer server, int mode) {
        IServerListener listener;
        if (terminationWatches.contains(server)) {
            return;
        }
        terminationWatches.add(server);
        class TerminateThread
        extends Thread {
            public boolean alive;
            public IServerListener listener;
            private final /* synthetic */ IServer val$server;
            private final /* synthetic */ int val$mode;
            private final /* synthetic */ Shell val$shell;

            public TerminateThread(IServer iServer, int n, Shell shell) {
                super("Server Termination Thread");
                this.val$server = iServer;
                this.val$mode = n;
                this.val$shell = shell;
                this.alive = true;
            }

            public void run() {
                while (this.alive) {
                    ServerType serverType = (ServerType)this.val$server.getServerType();
                    int delay = serverType.getStartTimeout();
                    if (this.val$mode == 1) {
                        delay = serverType.getStopTimeout();
                    } else if (this.val$mode == 2) {
                        delay += serverType.getStopTimeout();
                    }
                    if (delay < 0) {
                        return;
                    }
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.val$server.getServerState() == 4) {
                        this.alive = false;
                    }
                    if (this.alive) {
                        Display.getDefault().syncExec(new Runnable(this, this.val$shell, this.val$server){
                            final /* synthetic */ TerminateThread this$1;
                            private final /* synthetic */ Shell val$shell;
                            private final /* synthetic */ IServer val$server;
                            {
                                this.this$1 = terminateThread;
                                this.val$shell = shell;
                                this.val$server = iServer;
                            }

                            public void run() {
                                TerminationDialog dialog = new TerminationDialog(this.val$shell, this.val$server.getName());
                                dialog.open();
                                if (dialog.getReturnCode() == 0) {
                                    if (this.val$server.getServerState() != 4) {
                                        this.val$server.stop(true);
                                    }
                                    this.this$1.alive = false;
                                }
                            }
                        });
                    }
                    if (this.alive) continue;
                    if (this.listener != null) {
                        this.val$server.removeServerListener(this.listener);
                    }
                    terminationWatches.remove(this.val$server);
                }
            }
        }
        final TerminateThread t = new TerminateThread(server, mode, shell);
        t.setDaemon(true);
        t.setPriority(3);
        t.listener = listener = new IServerListener(){
            {
            }

            public void serverChanged(ServerEvent event) {
                int eventKind = event.getKind();
                IServer server2 = event.getServer();
                if (eventKind == 17 && server2.getServerState() == 4 && t != null) {
                    t.alive = false;
                }
            }
        };
        server.addServerListener(listener);
        t.start();
    }

    public static IServer findServer(IFile file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                if (file.equals((Object)((Server)servers[i]).getFile())) {
                    return servers[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static IRuntime[] getRuntimes(IRuntimeType runtimeType) {
        ArrayList<IRuntime> list = new ArrayList<IRuntime>();
        IRuntime[] runtimes = ServerCore.getRuntimes();
        if (runtimes != null) {
            int size = runtimes.length;
            int i = 0;
            while (i < size) {
                if (runtimes[i].getRuntimeType() != null && runtimes[i].getRuntimeType().equals(runtimeType)) {
                    list.add(runtimes[i]);
                }
                ++i;
            }
        }
        IRuntime[] r = new IRuntime[list.size()];
        list.toArray(r);
        return r;
    }

    public static void editServer(IServer server) {
        if (server == null) {
            return;
        }
        ServerUIPlugin.editServer(server.getId());
    }

    protected static void editServer(String serverId) {
        if (serverId == null) {
            return;
        }
        IWorkbenchWindow workbenchWindow = ServerUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        try {
            ServerEditorInput input = new ServerEditorInput(serverId);
            page.openEditor((IEditorInput)input, "org.eclipse.wst.server.ui.editor");
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error opening server editor", e);
        }
    }

    public static boolean saveEditors() {
        byte b = ServerUIPlugin.getPreferences().getSaveEditors();
        if (b == 0) {
            return true;
        }
        return ServerUIPlugin.getInstance().getWorkbench().saveAllEditors(b == 1);
    }

    public static boolean promptIfDirty(Shell shell, IServer server) {
        if (server == null) {
            return false;
        }
        if (!(server instanceof IServerWorkingCopy)) {
            return true;
        }
        String title = Messages.resourceDirtyDialogTitle;
        IServerWorkingCopy wc = (IServerWorkingCopy)server;
        if (wc.isDirty()) {
            String message = NLS.bind((String)Messages.resourceDirtyDialogMessage, (Object)server.getName());
            String[] labels = new String[]{Messages.resourceDirtyDialogContinue, IDialogConstants.CANCEL_LABEL};
            MessageDialog dialog = new MessageDialog(shell, title, null, message, 2, labels, 0);
            if (dialog.open() != 0) {
                return false;
            }
        }
        return true;
    }

    protected static void showServersView(final boolean bringToFront) {
        if (!ServerUIPlugin.getPreferences().getShowOnActivity()) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                block7: {
                    try {
                        IWorkbench workbench = ServerUIPlugin.getInstance().getWorkbench();
                        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
                        IWorkbenchPage page = workbenchWindow.getActivePage();
                        IViewPart view2 = page.findView(ServerUIPlugin.VIEW_ID);
                        if (view2 != null) {
                            if (bringToFront) {
                                page.bringToTop((IWorkbenchPart)view2);
                                break block7;
                            }
                            IWorkbenchPartSite iWorkbenchPartSite = view2.getSite();
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            IWorkbenchSiteProgressService wsps = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz);
                            wsps.warnOfContentChange();
                            break block7;
                        }
                        page.showView(ServerUIPlugin.VIEW_ID);
                    }
                    catch (Exception e) {
                        Trace.trace(Trace.SEVERE, "Error opening TCP/IP view", e);
                    }
                }
            }
        });
    }

    public static boolean isCompatibleWithLaunchMode(IServer server, String launchMode) {
        if (server == null || launchMode == null) {
            return false;
        }
        int state = server.getServerState();
        if (state == 2 && launchMode.equals(server.getMode())) {
            return true;
        }
        return server.getServerType().supportsLaunchMode(launchMode);
    }

    public static boolean showNewRuntimeWizard(Shell shell, final String type, final String version, final String runtimeTypeId) {
        WizardFragment fragment = new WizardFragment(){

            protected void createChildFragments(List list) {
                list.add(new NewRuntimeWizardFragment(type, version, runtimeTypeId));
                list.add(new WizardFragment(this){
                    final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void performFinish(IProgressMonitor monitor) throws CoreException {
                        WizardTaskUtil.saveRuntime(this.getTaskModel(), monitor);
                    }
                });
            }
        };
        TaskWizard wizard = new TaskWizard(Messages.wizNewRuntimeWizardTitle, fragment);
        wizard.setForcePreviousAndNextButtons(true);
        ClosableWizardDialog dialog = new ClosableWizardDialog(shell, wizard);
        return dialog.open() == 0;
    }

    public static boolean showNewRuntimeWizard(Shell shell, final String runtimeTypeId) {
        IRuntimeType runtimeType = null;
        if (runtimeTypeId != null) {
            runtimeType = ServerCore.findRuntimeType((String)runtimeTypeId);
        }
        if (runtimeType != null) {
            try {
                IRuntimeWorkingCopy runtime = runtimeType.createRuntime(null, null);
                TaskModel taskModel = new TaskModel();
                taskModel.putObject("runtime", (Object)runtime);
                WizardFragment fragment = new WizardFragment(){

                    protected void createChildFragments(List list) {
                        list.add(ServerUIPlugin.getWizardFragment(runtimeTypeId));
                        list.add(new WizardFragment(this){
                            final /* synthetic */ 9 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void performFinish(IProgressMonitor monitor) throws CoreException {
                                WizardTaskUtil.saveRuntime(this.getTaskModel(), monitor);
                            }
                        });
                    }
                };
                TaskWizard wizard = new TaskWizard(Messages.wizNewRuntimeWizardTitle, fragment, taskModel);
                wizard.setForcePreviousAndNextButtons(true);
                ClosableWizardDialog dialog = new ClosableWizardDialog(shell, wizard);
                return dialog.open() == 0;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return ServerUIPlugin.showNewRuntimeWizard(shell, null, null, runtimeTypeId);
    }

    public static boolean showNewRuntimeWizard(Shell shell) {
        return ServerUIUtil.showNewRuntimeWizard(shell, null, null);
    }

    public static WizardFragment getWizardFragment(String typeId) {
        if (typeId == null) {
            return null;
        }
        if (wizardFragments == null) {
            ServerUIPlugin.loadWizardFragments();
        }
        Iterator iterator = wizardFragments.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!typeId.equals(key)) continue;
            WizardFragmentData data = (WizardFragmentData)wizardFragments.get(key);
            return ServerUIPlugin.getWizardFragment(data);
        }
        return null;
    }

    private static synchronized void loadWizardFragments() {
        if (wizardFragments != null) {
            return;
        }
        Trace.trace(Trace.CONFIG, "->- Loading .wizardFragments extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, EXTENSION_WIZARD_FRAGMENTS);
        wizardFragments = new HashMap(cf.length);
        ServerUIPlugin.loadWizardFragments(cf);
        ServerUIPlugin.addRegistryListener();
        Trace.trace(Trace.CONFIG, "-<- Done loading .wizardFragments extension point -<-");
    }

    private static synchronized void loadWizardFragments(IConfigurationElement[] cf) {
        int i = 0;
        while (i < cf.length) {
            try {
                String id = cf[i].getAttribute("typeIds");
                wizardFragments.put(id, new WizardFragmentData(id, cf[i]));
                Trace.trace(Trace.CONFIG, "  Loaded wizardFragment: " + id);
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load wizardFragment: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
    }

    public static InitialSelectionProvider getInitialSelectionProvider() {
        if (selectionProvider == null) {
            ServerUIPlugin.loadInitialSelectionProvider();
        }
        return selectionProvider;
    }

    private static synchronized void loadInitialSelectionProvider() {
        if (selectionProvider != null) {
            return;
        }
        Trace.trace(Trace.CONFIG, "->- Loading .initialSelectionProvider extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "initialSelectionProvider");
        if (cf.length == 1) {
            try {
                selectionProvider = (InitialSelectionProvider)((Object)cf[0].createExecutableExtension("class"));
                Trace.trace(Trace.CONFIG, "  Loaded initialSelectionProvider: " + cf[0].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load initialSelectionProvider: " + cf[0].getAttribute("id"), t);
            }
        } else if (cf.length > 1) {
            Trace.trace(Trace.WARNING, "More that one initial selection provider found - ignoring");
        } else {
            Trace.trace(Trace.CONFIG, "No initial selection provider found");
        }
        if (selectionProvider == null) {
            selectionProvider = new InitialSelectionProvider();
        }
        Trace.trace(Trace.CONFIG, "-<- Done loading .initialSelectionProvider extension point -<-");
    }

    protected static WizardFragment getWizardFragment(WizardFragmentData fragment) {
        if (fragment == null) {
            return null;
        }
        if (fragment.fragment == null) {
            try {
                fragment.fragment = (WizardFragment)fragment.ce.createExecutableExtension("class");
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "Could not create wizardFragment: " + fragment.ce.getAttribute("id"), t);
            }
        }
        return fragment.fragment;
    }

    public static void runOnServer(Object object, String launchMode) {
        RunOnServerActionDelegate delegate = new RunOnServerActionDelegate();
        Action action = new Action(){};
        if (object != null) {
            StructuredSelection sel = new StructuredSelection(object);
            delegate.selectionChanged((IAction)action, (ISelection)sel);
        } else {
            delegate.selectionChanged((IAction)action, null);
        }
        delegate.run((IAction)action);
    }

    public static synchronized void addRegistryListener() {
        if (registryListener != null) {
            return;
        }
        registryListener = new RegistryChangeListener();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener(registryListener, PLUGIN_ID);
    }

    protected static void handleWizardFragmentDelta(IExtensionDelta delta) {
        if (wizardFragments == null) {
            return;
        }
        IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
        if (delta.getKind() == 1) {
            ServerUIPlugin.loadWizardFragments(cf);
        }
    }

    private static class RegistryChangeListener
    implements IRegistryChangeListener {
        RegistryChangeListener() {
        }

        public void registryChanged(IRegistryChangeEvent event) {
            int i;
            IExtensionDelta[] deltas = event.getExtensionDeltas(ServerUIPlugin.PLUGIN_ID, ServerUIPlugin.EXTENSION_WIZARD_FRAGMENTS);
            if (deltas != null) {
                i = 0;
                while (i < deltas.length) {
                    ServerUIPlugin.handleWizardFragmentDelta(deltas[i]);
                    ++i;
                }
            }
            if ((deltas = event.getExtensionDeltas(ServerUIPlugin.PLUGIN_ID, ServerUIPlugin.EXTENSION_SERVER_IMAGES)) != null) {
                i = 0;
                while (i < deltas.length) {
                    ImageResource.handleServerImageDelta(deltas[i]);
                    ++i;
                }
            }
            if ((deltas = event.getExtensionDeltas(ServerUIPlugin.PLUGIN_ID, ServerUIPlugin.EXTENSION_EDITOR_PAGES)) != null) {
                i = 0;
                while (i < deltas.length) {
                    ServerEditorCore.handleEditorPageFactoriesDelta(deltas[i]);
                    ++i;
                }
            }
            if ((deltas = event.getExtensionDeltas(ServerUIPlugin.PLUGIN_ID, ServerUIPlugin.EXTENSION_EDITOR_PAGE_SECTIONS)) != null) {
                i = 0;
                while (i < deltas.length) {
                    ServerEditorCore.handleEditorPageSectionFactoriesDelta(deltas[i]);
                    ++i;
                }
            }
        }
    }

    static class WizardFragmentData {
        String id;
        IConfigurationElement ce;
        WizardFragment fragment;

        public WizardFragmentData(String id, IConfigurationElement ce) {
            this.id = id;
            this.ce = ce;
        }
    }
}

