/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wst.server.ui.internal.Messages;

public abstract class AbstractTreeComposite
extends Composite {
    protected Tree tree;
    protected TreeViewer treeViewer;
    protected Label description;

    public AbstractTreeComposite(Composite parent, int style) {
        super(parent, style);
        this.createWidgets();
    }

    protected void createWidgets() {
        GridData data;
        Label label;
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        String descriptionText = this.getDescriptionLabel();
        if (descriptionText != null) {
            label = new Label((Composite)this, 64);
            label.setText(descriptionText);
            data = new GridData(772);
            data.horizontalSpan = 2;
            label.setLayoutData((Object)data);
        }
        label = new Label((Composite)this, 64);
        label.setText(this.getTitleLabel());
        data = new GridData(772);
        if (descriptionText != null) {
            data.verticalIndent = 7;
        }
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        String details = this.getDetailsLabel();
        if (details != null) {
            Link prefLink = new Link((Composite)this, 0);
            data = new GridData(128);
            data.horizontalSpan = 2;
            prefLink.setLayoutData((Object)data);
            prefLink.setText("<a>" + details + "</a>");
            prefLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractTreeComposite.this.detailsSelected();
                }
            });
        }
        this.tree = new Tree((Composite)this, 2820);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        this.tree.setLayoutData((Object)data);
        this.treeViewer = new TreeViewer(this.tree);
        this.treeViewer.setSorter(new ViewerSorter());
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                Object element = s.getFirstElement();
                if (AbstractTreeComposite.this.treeViewer.isExpandable(element)) {
                    AbstractTreeComposite.this.treeViewer.setExpandedState(element, !AbstractTreeComposite.this.treeViewer.getExpandedState(element));
                }
            }
        });
        label = new Label((Composite)this, 0);
        label.setText("");
        data = new GridData(772);
        label.setLayoutData((Object)data);
        Composite comp = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        comp.setLayout((Layout)layout);
        data = new GridData(132);
        comp.setLayoutData((Object)data);
        label = new Label(comp, 0);
        label.setText(Messages.viewBy);
        data = new GridData(132);
        label.setLayoutData((Object)data);
        final Combo combo = new Combo(comp, 12);
        combo.setItems(this.getComboOptions());
        combo.select(1);
        combo.setLayoutData((Object)new GridData(644));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sel = combo.getSelectionIndex();
                AbstractTreeComposite.this.viewOptionSelected((byte)sel);
            }
        });
        if (this.hasDescription()) {
            this.description = new Label((Composite)this, 64);
            this.description.setText(Messages.wizDescription);
            data = new GridData(772);
            data.horizontalSpan = 2;
            data.heightHint = 35;
            this.description.setLayoutData((Object)data);
        }
        this.tree.forceFocus();
    }

    protected abstract String getDescriptionLabel();

    protected abstract String getTitleLabel();

    protected abstract String[] getComboOptions();

    protected boolean hasDescription() {
        return true;
    }

    protected void setDescription(String text) {
        if (this.description != null && text != null) {
            this.description.setText(String.valueOf(Messages.wizDescription) + " " + text);
        }
    }

    protected abstract void viewOptionSelected(byte var1);

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected Object getSelection(ISelection sel2) {
        IStructuredSelection sel = (IStructuredSelection)sel2;
        return sel.getFirstElement();
    }

    public void refresh() {
        this.treeViewer.refresh();
    }

    public void refresh(Object obj) {
        this.treeViewer.refresh(obj);
    }

    public void remove(Object obj) {
        this.treeViewer.remove(obj);
    }

    protected String getDetailsLabel() {
        return null;
    }

    protected void detailsSelected() {
    }
}

