/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.ProjectProperties;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.ui.internal.EclipseUtil;
import org.eclipse.wst.server.ui.internal.Trace;

public class WizardTaskUtil {
    private WizardTaskUtil() {
    }

    public static void saveRuntime(TaskModel taskModel, IProgressMonitor monitor) throws CoreException {
        IRuntimeWorkingCopy workingCopy;
        IRuntime runtime = (IRuntime)taskModel.getObject("runtime");
        if (runtime != null && runtime instanceof IRuntimeWorkingCopy && (workingCopy = (IRuntimeWorkingCopy)runtime).isDirty()) {
            taskModel.putObject("runtime", (Object)workingCopy.save(false, monitor));
        }
    }

    public static void saveServer(TaskModel taskModel, IProgressMonitor monitor) throws CoreException {
        IServerWorkingCopy workingCopy;
        IServer server = (IServer)taskModel.getObject("server");
        if (server != null && server instanceof IServerWorkingCopy && (workingCopy = (IServerWorkingCopy)server).isDirty()) {
            IFile file = ((Server)workingCopy).getFile();
            if (file != null) {
                ProjectProperties pp;
                IProject project = file.getProject();
                if (!file.getProject().exists()) {
                    EclipseUtil.createNewServerProject(null, project.getName(), null, monitor);
                }
                if (!(pp = ServerPlugin.getProjectProperties((IProject)project)).isServerProject()) {
                    pp.setServerProject(true, monitor);
                }
            }
            taskModel.putObject("server", (Object)workingCopy.save(false, monitor));
        }
    }

    public static void tempSaveRuntime(TaskModel taskModel, IProgressMonitor monitor) throws CoreException {
        IRuntime runtime = (IRuntime)taskModel.getObject("runtime");
        if (runtime != null && runtime instanceof IRuntimeWorkingCopy) {
            IRuntimeWorkingCopy workingCopy = (IRuntimeWorkingCopy)runtime;
            if (!workingCopy.isDirty()) {
                return;
            }
            runtime = workingCopy.save(false, monitor);
            taskModel.putObject("runtime", (Object)runtime.createWorkingCopy());
        }
    }

    public static void tempSaveServer(TaskModel taskModel, IProgressMonitor monitor) throws CoreException {
        IServer server = (IServer)taskModel.getObject("server");
        if (server != null && server instanceof IServerWorkingCopy) {
            IServerWorkingCopy workingCopy = (IServerWorkingCopy)server;
            if (!workingCopy.isDirty()) {
                return;
            }
            IFile file = ((Server)workingCopy).getFile();
            if (file != null) {
                ProjectProperties pp;
                IProject project = file.getProject();
                if (!file.getProject().exists()) {
                    EclipseUtil.createNewServerProject(null, project.getName(), null, monitor);
                }
                if (!(pp = ServerPlugin.getProjectProperties((IProject)project)).isServerProject()) {
                    pp.setServerProject(true, monitor);
                }
            }
            IRuntime runtime = workingCopy.getRuntime();
            server = workingCopy.save(false, monitor);
            workingCopy = server.createWorkingCopy();
            workingCopy.setRuntime(runtime);
            if (workingCopy.getServerType().hasServerConfiguration()) {
                ((ServerWorkingCopy)workingCopy).importConfiguration(runtime, null);
            }
            taskModel.putObject("server", (Object)workingCopy);
        }
    }

    public static void addModule(IModule module, TaskModel taskModel, IProgressMonitor monitor) throws CoreException {
        if (module == null) {
            return;
        }
        IServer server = (IServer)taskModel.getObject("server");
        IModule parentModule = null;
        try {
            IModule[] parents = server.getRootModules(module, monitor);
            if (parents != null && parents.length > 0) {
                parentModule = parents[0];
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Could not find parent module", e);
        }
        if (parentModule == null) {
            parentModule = module;
        }
        IModule[] modules = server.getModules();
        int size = modules.length;
        int i = 0;
        while (i < size) {
            if (parentModule.equals(modules[i])) {
                return;
            }
            ++i;
        }
        IServerWorkingCopy workingCopy = server.createWorkingCopy();
        workingCopy.modifyModules(new IModule[]{parentModule}, new IModule[0], monitor);
        taskModel.putObject("server", (Object)workingCopy.save(false, monitor));
    }

    public static void modifyModules(List add, List remove, TaskModel taskModel, IProgressMonitor monitor) throws CoreException {
        IFile file;
        if ((add == null || add.isEmpty()) && (remove == null || remove.isEmpty())) {
            return;
        }
        IServerWorkingCopy workingCopy = (IServerWorkingCopy)taskModel.getObject("server");
        IModule[] remove2 = new IModule[]{};
        if (remove != null) {
            remove2 = new IModule[remove.size()];
            remove.toArray(remove2);
        }
        IModule[] add2 = new IModule[]{};
        if (add != null) {
            add2 = new IModule[add.size()];
            add.toArray(add2);
        }
        if ((file = ((Server)workingCopy).getFile()) != null) {
            ProjectProperties pp;
            IProject project = file.getProject();
            if (!file.getProject().exists()) {
                EclipseUtil.createNewServerProject(null, project.getName(), null, monitor);
            }
            if (!(pp = ServerPlugin.getProjectProperties((IProject)project)).isServerProject()) {
                pp.setServerProject(true, monitor);
            }
        }
        workingCopy.modifyModules(add2, remove2, monitor);
    }
}

