/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.ServerUICore;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class ModifyModulesComposite
extends Composite {
    protected IWizardHandle wizard;
    protected IServerAttributes server;
    protected Map childModuleMap = new HashMap();
    protected Map parentModuleMap = new HashMap();
    protected List originalModules = new ArrayList();
    protected List modules = new ArrayList();
    protected List deployed = new ArrayList();
    protected TreeViewer availableTreeViewer;
    protected TreeViewer deployedTreeViewer;
    protected Button add;
    protected Button addAll;
    protected Button remove;
    protected Button removeAll;
    protected TaskModel taskModel;
    protected IModule newModule;
    protected IModule origNewModule;
    protected Map errorMap;

    public ModifyModulesComposite(Composite parent, IWizardHandle wizard, IModule module) {
        super(parent, 0);
        this.wizard = wizard;
        this.origNewModule = module;
        wizard.setTitle(Messages.wizModuleTitle);
        wizard.setDescription(Messages.wizModuleDescription);
        wizard.setImageDescriptor(ImageResource.getImageDescriptor("selectServer"));
        this.createControl();
    }

    public void setServer(IServerAttributes server) {
        IModule[] children;
        IModule[] modules2;
        if (server == this.server) {
            return;
        }
        this.server = server;
        this.originalModules = new ArrayList();
        this.deployed = new ArrayList();
        this.modules = new ArrayList();
        this.childModuleMap = new HashMap();
        if (server == null) {
            return;
        }
        IModule[] currentModules = server.getModules();
        if (currentModules != null) {
            int size = currentModules.length;
            int i = 0;
            while (i < size) {
                this.originalModules.add(currentModules[i]);
                this.deployed.add(currentModules[i]);
                ++i;
            }
        }
        this.newModule = null;
        this.errorMap = new HashMap();
        if (this.origNewModule != null) {
            try {
                IModule[] parents = server.getRootModules(this.origNewModule, null);
                this.newModule = parents != null && parents.length > 0 ? parents[0] : this.origNewModule;
            }
            catch (CoreException ce) {
                this.errorMap.put(this.newModule, ce.getStatus());
                this.newModule = null;
            }
            catch (Exception e) {
                Trace.trace(Trace.WARNING, "Could not find root module", e);
                this.newModule = null;
            }
        }
        if (this.newModule != null && !this.deployed.contains(this.newModule)) {
            this.deployed.add(this.newModule);
        }
        if ((modules2 = ServerUtil.getModules((IModuleType[])server.getServerType().getRuntimeType().getModuleTypes())) != null) {
            int size = modules2.length;
            int i = 0;
            while (i < size) {
                IModule module = modules2[i];
                if (!this.deployed.contains(module)) {
                    try {
                        IModule[] parents = server.getRootModules(module, null);
                        if (parents != null) {
                            int size2 = parents.length;
                            int j = 0;
                            while (j < size2) {
                                if (parents[j].equals(module)) {
                                    IStatus status = server.canModifyModules(new IModule[]{module}, null, null);
                                    if (status != null && !status.isOK()) {
                                        this.errorMap.put(module, status);
                                    }
                                    this.modules.add(module);
                                }
                                ++j;
                            }
                        }
                    }
                    catch (CoreException ce) {
                        this.errorMap.put(module, ce.getStatus());
                        this.modules.add(module);
                    }
                }
                ++i;
            }
        }
        Iterator iterator = this.deployed.iterator();
        while (iterator.hasNext()) {
            IModule module = (IModule)iterator.next();
            try {
                children = server.getChildModules(new IModule[]{module}, null);
                if (children == null || children.length <= 0) continue;
                this.childModuleMap.put(new ChildModuleMapKey(module), children);
            }
            catch (Exception exception) {}
        }
        iterator = this.modules.iterator();
        while (iterator.hasNext()) {
            IModule module = (IModule)iterator.next();
            try {
                children = server.getChildModules(new IModule[]{module}, null);
                if (children == null || children.length <= 0) continue;
                this.childModuleMap.put(new ChildModuleMapKey(module), children);
            }
            catch (Exception exception) {}
        }
        if (this.availableTreeViewer != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        ModifyModulesComposite.this.availableTreeViewer.refresh();
                        ModifyModulesComposite.this.deployedTreeViewer.refresh();
                        ModifyModulesComposite.this.setEnablement();
                    }
                    catch (Exception exception) {}
                }
            });
        }
        this.updateTaskModel();
    }

    public void setTaskModel(TaskModel model) {
        this.taskModel = model;
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        layout.numColumns = 3;
        this.setLayout((Layout)layout);
        this.setFont(this.getParent().getFont());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "org.eclipse.wst.server.ui.swmm0000");
        Label label = new Label((Composite)this, 0);
        GridData data = new GridData(770);
        data.horizontalSpan = 3;
        label.setLayoutData((Object)data);
        label.setText(Messages.wizModuleMessage);
        label = new Label((Composite)this, 0);
        label.setText(Messages.wizModuleAvailableList);
        label = new Label((Composite)this, 0);
        label.setText("");
        label = new Label((Composite)this, 0);
        label.setText(Messages.wizModuleDeployedList);
        Tree availableTree = new Tree((Composite)this, 2048);
        data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 150;
        availableTree.setLayoutData((Object)data);
        this.availableTreeViewer = new TreeViewer(availableTree);
        this.availableTreeViewer.setLabelProvider((IBaseLabelProvider)ServerUICore.getLabelProvider());
        this.availableTreeViewer.setContentProvider((IContentProvider)new AvailableContentProvider());
        this.availableTreeViewer.setSorter(new ViewerSorter());
        this.availableTreeViewer.setInput((Object)"root");
        this.availableTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModifyModulesComposite.this.setEnablement();
            }
        });
        this.availableTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ModifyModulesComposite.this.setEnablement();
                if (ModifyModulesComposite.this.add.isEnabled()) {
                    ModifyModulesComposite.this.add(false);
                }
            }
        });
        Composite comp = new Composite((Composite)this, 0);
        data = new GridData(1808);
        data.widthHint = 120;
        comp.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 25;
        layout.verticalSpacing = 20;
        comp.setLayout((Layout)layout);
        this.add = new Button(comp, 8);
        this.add.setText(Messages.wizModuleAdd);
        this.add.setLayoutData((Object)new GridData(768));
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ModifyModulesComposite.this.add(false);
            }
        });
        this.remove = new Button(comp, 8);
        this.remove.setText(Messages.wizModuleRemove);
        this.remove.setLayoutData((Object)new GridData(768));
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ModifyModulesComposite.this.remove(false);
            }
        });
        label = new Label(comp, 0);
        label.setText("");
        this.addAll = new Button(comp, 8);
        this.addAll.setText(Messages.wizModuleAddAll);
        this.addAll.setLayoutData((Object)new GridData(768));
        this.addAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ModifyModulesComposite.this.add(true);
            }
        });
        this.removeAll = new Button(comp, 8);
        this.removeAll.setText(Messages.wizModuleRemoveAll);
        this.removeAll.setLayoutData((Object)new GridData(768));
        this.removeAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ModifyModulesComposite.this.remove(true);
            }
        });
        Tree deployedTree = new Tree((Composite)this, 2048);
        data = new GridData(1808);
        data.widthHint = 150;
        deployedTree.setLayoutData((Object)data);
        this.deployedTreeViewer = new TreeViewer(deployedTree);
        this.deployedTreeViewer.setLabelProvider((IBaseLabelProvider)ServerUICore.getLabelProvider());
        this.deployedTreeViewer.setContentProvider((IContentProvider)new DeployedContentProvider());
        this.deployedTreeViewer.setSorter(new ViewerSorter());
        this.deployedTreeViewer.setInput((Object)"root");
        this.deployedTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModifyModulesComposite.this.setEnablement();
            }
        });
        this.deployedTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ModifyModulesComposite.this.setEnablement();
                if (ModifyModulesComposite.this.remove.isEnabled()) {
                    ModifyModulesComposite.this.remove(false);
                }
            }
        });
        this.setEnablement();
        availableTree.setFocus();
        Dialog.applyDialogFont((Control)this);
    }

    protected IModule getAvailableSelection() {
        IStructuredSelection sel = (IStructuredSelection)this.availableTreeViewer.getSelection();
        return ModifyModulesComposite.getModule((IModule[])sel.getFirstElement());
    }

    protected IModule getDeployedSelection() {
        IStructuredSelection sel = (IStructuredSelection)this.deployedTreeViewer.getSelection();
        return ModifyModulesComposite.getModule((IModule[])sel.getFirstElement());
    }

    protected static IModule getModule(IModule[] modules2) {
        if (modules2 == null) {
            return null;
        }
        return modules2[modules2.length - 1];
    }

    protected void setEnablement() {
        boolean enabled = false;
        this.wizard.setMessage(null, 0);
        IModule module = this.getAvailableSelection();
        if (module != null) {
            try {
                IStatus status = (IStatus)this.errorMap.get(module);
                if (this.modules.contains(module)) {
                    if (status == null) {
                        enabled = true;
                    } else if (status.getSeverity() == 4) {
                        this.wizard.setMessage(status.getMessage(), 3);
                    } else if (status.getSeverity() == 2) {
                        this.wizard.setMessage(status.getMessage(), 2);
                    } else if (status.getSeverity() == 1) {
                        this.wizard.setMessage(status.getMessage(), 1);
                    }
                }
            }
            catch (Exception exception) {}
        }
        this.add.setEnabled(enabled);
        this.addAll.setEnabled(this.modules.size() > 0);
        enabled = false;
        module = this.getDeployedSelection();
        if (module != null) {
            try {
                if (this.deployed.contains(module) && !module.equals(this.newModule)) {
                    enabled = true;
                }
            }
            catch (Exception exception) {}
        }
        this.remove.setEnabled(enabled);
        if (this.newModule == null) {
            this.removeAll.setEnabled(this.deployed.size() > 0);
        } else {
            this.removeAll.setEnabled(this.deployed.size() > 1);
        }
    }

    protected void add(boolean all) {
        if (all) {
            IModule[] modules2 = new IModule[this.modules.size()];
            this.modules.toArray(modules2);
            this.moveAll(modules2, true);
        } else {
            this.moveAll(new IModule[]{this.getAvailableSelection()}, true);
        }
        this.updateTaskModel();
    }

    protected void remove(boolean all) {
        if (all) {
            IModule[] modules2 = new IModule[this.deployed.size()];
            this.deployed.toArray(modules2);
            this.moveAll(modules2, false);
        } else {
            this.moveAll(new IModule[]{this.getDeployedSelection()}, false);
        }
        this.updateTaskModel();
    }

    protected void moveAll(IModule[] mods, boolean add2) {
        int size = mods.length;
        ArrayList<IModule> list = new ArrayList<IModule>();
        int i = 0;
        while (i < size) {
            IStatus status = (IStatus)this.errorMap.get(mods[i]);
            if (status == null && !list.contains(mods[i])) {
                list.add(mods[i]);
            }
            ++i;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IModule module = (IModule)iterator.next();
            if (add2) {
                this.modules.remove(module);
                this.deployed.add(module);
                continue;
            }
            if (module.equals(this.newModule)) continue;
            this.modules.add(module);
            this.deployed.remove(module);
        }
        this.availableTreeViewer.refresh();
        this.deployedTreeViewer.refresh();
        this.setEnablement();
    }

    protected void updateTaskModel() {
        if (this.taskModel == null) {
            return;
        }
        this.taskModel.putObject("modules", (Object)this.getModuleMap());
        this.wizard.update();
    }

    public List getModulesToRemove() {
        ArrayList<IModule> list = new ArrayList<IModule>();
        Iterator iterator = this.originalModules.iterator();
        while (iterator.hasNext()) {
            IModule module = (IModule)iterator.next();
            if (this.deployed.contains(module)) continue;
            list.add(module);
        }
        return list;
    }

    public List getModulesToAdd() {
        ArrayList<IModule> list = new ArrayList<IModule>();
        Iterator iterator = this.deployed.iterator();
        while (iterator.hasNext()) {
            IModule module = (IModule)iterator.next();
            if (this.originalModules.contains(module)) continue;
            list.add(module);
        }
        return list;
    }

    private void addChildMap(List map, IModule[] parents, IModule[] children) {
        if (children == null) {
            return;
        }
        int size = children.length;
        int i = 0;
        while (i < size) {
            IModule module = children[i];
            int size2 = parents.length;
            IModule[] modules2 = new IModule[size2 + 1];
            System.arraycopy(parents, 0, modules2, 0, size2);
            modules2[size2] = module;
            map.add(modules2);
            IModule[] children2 = (IModule[])this.childModuleMap.get(new ChildModuleMapKey(module));
            if (children2 != null) {
                this.addChildMap(map, modules2, children2);
            }
            ++i;
        }
    }

    public List getModuleMap() {
        ArrayList<IModule[]> map = new ArrayList<IModule[]>();
        Iterator iterator = this.deployed.iterator();
        while (iterator.hasNext()) {
            IModule module = (IModule)iterator.next();
            IModule[] moduleTree = new IModule[]{module};
            map.add(moduleTree);
            IModule[] children = (IModule[])this.childModuleMap.get(new ChildModuleMapKey(module));
            if (children == null) continue;
            this.addChildMap(map, moduleTree, children);
        }
        return map;
    }

    abstract class TreeContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            IModule[] parent = (IModule[])parentElement;
            IModule[] children = (IModule[])ModifyModulesComposite.this.childModuleMap.get(new ChildModuleMapKey(parent));
            ArrayList<IModule[]> list = new ArrayList<IModule[]>();
            if (children != null) {
                int size = children.length;
                int i = 0;
                while (i < size) {
                    IModule child = children[i];
                    ModifyModulesComposite.this.parentModuleMap.put(child, parent);
                    int size2 = parent.length;
                    IModule[] module2 = new IModule[size2 + 1];
                    System.arraycopy(parent, 0, module2, 0, size2);
                    module2[size2] = child;
                    list.add(module2);
                    ++i;
                }
            }
            return list.toArray();
        }

        public Object getParent(Object element) {
            IModule[] child = (IModule[])element;
            return (IModule[])ModifyModulesComposite.this.parentModuleMap.get(child);
        }

        public boolean hasChildren(Object element) {
            IModule[] parent = (IModule[])element;
            IModule[] children = (IModule[])ModifyModulesComposite.this.childModuleMap.get(new ChildModuleMapKey(parent));
            return children != null && children.length > 0;
        }
    }

    class AvailableContentProvider
    extends TreeContentProvider {
        AvailableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<IModule[]> list = new ArrayList<IModule[]>();
            Iterator iterator = ModifyModulesComposite.this.modules.iterator();
            while (iterator.hasNext()) {
                IModule module = (IModule)iterator.next();
                list.add(new IModule[]{module});
            }
            return list.toArray();
        }
    }

    class DeployedContentProvider
    extends TreeContentProvider {
        DeployedContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<IModule[]> list = new ArrayList<IModule[]>();
            Iterator iterator = ModifyModulesComposite.this.deployed.iterator();
            while (iterator.hasNext()) {
                IModule module = (IModule)iterator.next();
                list.add(new IModule[]{module});
            }
            return list.toArray();
        }
    }

    protected class ChildModuleMapKey {
        private IModule[] moduleTree;

        protected ChildModuleMapKey(IModule curModule) {
            if (curModule != null) {
                this.moduleTree = new IModule[]{curModule};
            }
        }

        protected ChildModuleMapKey(IModule[] curModuleTree) {
            this.moduleTree = curModuleTree;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ChildModuleMapKey)) {
                return false;
            }
            IModule[] curCompareModule = ((ChildModuleMapKey)obj).moduleTree;
            if (curCompareModule == this.moduleTree) {
                return true;
            }
            if (this.moduleTree == null || curCompareModule == null || this.moduleTree.length != curCompareModule.length) {
                return false;
            }
            int i = 0;
            while (i < curCompareModule.length) {
                if (!curCompareModule[i].equals(this.moduleTree[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public int hashCode() {
            return 12345;
        }
    }
}

