/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.event.HyperlinkEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.ui.ResourceHandler;
import org.eclipse.wst.validation.internal.ui.plugin.ValidationUIPlugin;

public class ValidationPropertiesPage
extends PropertyPage {
    static final String NEWLINE = System.getProperty("line.separator");
    static final String TAB = "\t";
    static final String NEWLINE_AND_TAB = String.valueOf(NEWLINE) + "\t";
    private IValidationPage _pageImpl = null;

    protected Control createContents(Composite parent) {
        IProject project = this.getProject();
        if (project == null || !project.isOpen()) {
            this._pageImpl = new InvalidPage(parent);
        } else {
            try {
                this._pageImpl = ConfigurationManager.getManager().getProjectConfiguration(project).numberOfValidators() == 0 ? new NoValidatorsPage(parent) : new ValidatorListPage(parent);
            }
            catch (InvocationTargetException exc) {
                this._pageImpl = new InvalidPage(parent);
                this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
            }
            catch (Throwable exc) {
                this._pageImpl = new InvalidPage(parent);
                this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
            }
        }
        return this._pageImpl.getControl();
    }

    public void dispose() {
        super.dispose();
        try {
            this._pageImpl.dispose();
        }
        catch (Throwable exc) {
            this.logError(exc);
        }
    }

    public IProject getProject() {
        IAdaptable element = this.getElement();
        if (element == null) {
            return null;
        }
        if (element instanceof IProject) {
            return (IProject)element;
        }
        return null;
    }

    protected void noDefaultAndApplyButton() {
        super.noDefaultAndApplyButton();
    }

    protected void performDefaults() {
        super.performDefaults();
        try {
            this._pageImpl.performDefaults();
        }
        catch (InvocationTargetException exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
        }
        catch (Throwable exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
        }
    }

    public boolean performOk() {
        try {
            return this._pageImpl.performOk();
        }
        catch (InvocationTargetException exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
            return false;
        }
        catch (Throwable exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
            return false;
        }
    }

    void logError(Throwable exc) {
        Logger logger = WTPUIPlugin.getLogger();
        if (logger.isLoggingLevel(Level.SEVERE)) {
            LogEntry entry = ValidationUIPlugin.getLogEntry();
            entry.setSourceIdentifier("ValidationPropertiesPage.displayAndLogError");
            entry.setMessageTypeIdentifier("VBF_EXC_INTERNAL_PAGE");
            entry.setTargetException(exc);
            logger.write(Level.SEVERE, (Object)entry);
            if (exc instanceof InvocationTargetException && ((InvocationTargetException)exc).getTargetException() != null) {
                entry.setTargetException(((InvocationTargetException)exc).getTargetException());
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    void displayAndLogError(String title, String message, Throwable exc) {
        this.logError(exc);
        this.displayMessage(title, message, 1);
    }

    private void displayMessage(String title, String message, int iIconType) {
        MessageBox messageBox = new MessageBox(this.getShell(), 0x20 | iIconType | 0x10000);
        messageBox.setMessage(message);
        messageBox.setText(title);
        messageBox.open();
    }

    protected Button getDefaultsButton() {
        return super.getDefaultsButton();
    }

    public static interface IValidationPage {
        public Composite createPage(Composite var1) throws InvocationTargetException;

        public boolean performOk() throws InvocationTargetException;

        public boolean performDefaults() throws InvocationTargetException;

        public Composite getControl();

        public void dispose();
    }

    public class InvalidPage
    implements IValidationPage {
        private Composite page = null;
        private Composite composite = null;
        private GridLayout layout = null;
        private Label messageLabel = null;

        public InvalidPage(Composite parent) {
            this.page = this.createPage(parent);
        }

        public Composite createPage(Composite parent) {
            ValidationPropertiesPage.this.noDefaultAndApplyButton();
            ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
            sc1.setLayoutData((Object)new GridData(1808));
            this.composite = new Composite((Composite)sc1, 0);
            sc1.setContent((Control)this.composite);
            this.layout = new GridLayout();
            this.composite.setLayout((Layout)this.layout);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "org.eclipse.wst.common.frameworks.ui.jvpp0000");
            this.messageLabel = new Label(this.composite, 0);
            this.messageLabel.setText(ResourceHandler.getExternalizedMessage("VBF_EXC_INVALID_REGISTER"));
            this.composite.setSize(this.composite.computeSize(-1, -1));
            return this.composite;
        }

        public boolean performDefaults() {
            return true;
        }

        public boolean performOk() {
            return true;
        }

        public Composite getControl() {
            return this.page;
        }

        public void dispose() {
            this.messageLabel.dispose();
            this.composite.dispose();
        }
    }

    public class NoValidatorsPage
    implements IValidationPage {
        private Composite page = null;
        private Composite composite = null;
        private GridLayout layout = null;
        private GridData data = null;
        private Label messageLabel = null;

        public NoValidatorsPage(Composite parent) {
            this.page = this.createPage(parent);
        }

        public Composite createPage(Composite parent) {
            ValidationPropertiesPage.this.noDefaultAndApplyButton();
            ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
            sc1.setLayoutData((Object)new GridData(1808));
            this.composite = new Composite((Composite)sc1, 0);
            sc1.setContent((Control)this.composite);
            this.layout = new GridLayout();
            this.composite.setLayout((Layout)this.layout);
            this.data = new GridData(272);
            this.composite.setLayoutData((Object)this.data);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "org.eclipse.wst.common.frameworks.ui.jvpp0000");
            this.messageLabel = new Label(this.composite, 0);
            String[] msgParm = new String[]{ValidationPropertiesPage.this.getProject().getName()};
            this.messageLabel.setText(ResourceHandler.getExternalizedMessage("VBF_UI_LBL_NOVALIDATORS_DESC", msgParm));
            this.composite.setSize(this.composite.computeSize(-1, -1));
            return this.composite;
        }

        public boolean performDefaults() {
            return true;
        }

        public boolean performOk() {
            return true;
        }

        public Composite getControl() {
            return this.page;
        }

        public void dispose() {
            this.messageLabel.dispose();
            this.composite.dispose();
        }
    }

    public class ValidatorListPage
    implements IValidationPage {
        Composite page = null;
        GridLayout layout = null;
        GridData data = null;
        Label messageLabel = null;
        TableViewer validatorList = null;
        Button overrideGlobalButton = null;
        Button disableAllValidation = null;
        private Button enableAllButton = null;
        private Button disableAllButton = null;
        Label emptyRowPlaceholder = null;
        private String[] columnProperties;
        private CellEditor[] columnEditors;
        private String[] COMBO_VALUES = new String[]{"Enabled", "Disabled"};
        private static final String ENABLED = "Enabled";
        private static final String DISABLED = "Disabled";
        private static final int ENABLED_INT = 0;
        private static final int DISABLED_INT = 1;
        private Table validatorsTable;
        private static final String VALIDATORS = "validators";
        private static final String MANUAL_CHECK = "manualCheck";
        private static final String BUILD_CHECK = "buildCheck";
        private static final int VALUE_NOT_FOUND = -1;
        private static final int MANUAL_COL = 1;
        private static final int BUILD_COL = 2;
        private Label globalPrefLink = null;
        ProjectConfiguration pagePreferences = null;
        private boolean canOverride = false;
        private ValidatorMetaData[] oldVmd = null;

        public ValidatorListPage(Composite parent) throws InvocationTargetException {
            ConfigurationManager prefMgr = ConfigurationManager.getManager();
            ValidatorManager.getManager();
            this.pagePreferences = prefMgr.getProjectConfiguration(ValidationPropertiesPage.this.getProject());
            this.canOverride = prefMgr.getGlobalConfiguration().canProjectsOverride();
            this.oldVmd = this.pagePreferences.getEnabledValidators();
            this.createPage(parent);
        }

        private void setupTableColumns(Table table, TableViewer viewer) {
            TableColumn validatorColumn = new TableColumn(table, 0);
            validatorColumn.setText("Validator");
            validatorColumn.setResizable(false);
            validatorColumn.setWidth(240);
            TableColumn manualColumn = new TableColumn(table, 0);
            manualColumn.setText("Manual");
            manualColumn.setResizable(false);
            manualColumn.setWidth(80);
            TableColumn buildColumn = new TableColumn(table, 0);
            buildColumn.setText("Build");
            buildColumn.setResizable(false);
            buildColumn.setWidth(80);
            this.setupCellModifiers(table, viewer);
        }

        private void setupCellModifiers(Table table, TableViewer viewer) {
            this.columnProperties = new String[3];
            this.columnProperties[0] = VALIDATORS;
            this.columnProperties[1] = MANUAL_CHECK;
            this.columnProperties[2] = BUILD_CHECK;
            viewer.setColumnProperties(this.columnProperties);
            this.columnEditors = new CellEditor[table.getColumnCount()];
            this.columnEditors[1] = new ComboBoxCellEditor((Composite)table, this.COMBO_VALUES, 8);
            this.columnEditors[2] = new ComboBoxCellEditor((Composite)table, this.COMBO_VALUES, 8);
            viewer.setCellEditors(this.columnEditors);
        }

        public Composite createPage(Composite parent) throws InvocationTargetException {
            ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
            sc1.setLayoutData((Object)new GridData(1808));
            this.page = new Composite((Composite)sc1, 0);
            sc1.setContent((Control)this.page);
            this.page.setLayout((Layout)new GridLayout());
            Composite validatorGroup = new Composite(this.page, 0);
            GridLayout validatorGroupLayout = new GridLayout();
            validatorGroupLayout.numColumns = 2;
            validatorGroup.setLayout((Layout)validatorGroupLayout);
            Hyperlink link = new Hyperlink(validatorGroup, 0);
            GridData layout = new GridData(128);
            layout.horizontalSpan = 2;
            link.setLayoutData((Object)layout);
            link.setUnderlined(true);
            Color color = new Color((Device)validatorGroup.getDisplay(), new RGB(0, 0, 255));
            link.setForeground(color);
            link.setText("Configure Workspace Settings...");
            link.addHyperlinkListener(new IHyperlinkListener(this){
                public static final String DATA_NO_LINK = "PropertyAndPreferencePage.nolink";
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void hyperlinkUpdate(HyperlinkEvent e) {
                }

                public void linkEntered(org.eclipse.ui.forms.events.HyperlinkEvent e) {
                }

                public void linkExited(org.eclipse.ui.forms.events.HyperlinkEvent e) {
                }

                public void linkActivated(org.eclipse.ui.forms.events.HyperlinkEvent e) {
                    String id = this.getPreferencePageID();
                    PreferencesUtil.createPreferenceDialogOn((Shell)ValidatorListPage.access$5(this.this$1).getShell(), (String)id, (String[])new String[]{id}, (Object)"PropertyAndPreferencePage.nolink").open();
                    try {
                        this.this$1.updateWidgets();
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                }

                private String getPreferencePageID() {
                    return "ValidationPreferencePage";
                }
            });
            GridData overrideData = new GridData(512);
            overrideData.horizontalSpan = 2;
            this.overrideGlobalButton = new Button(validatorGroup, 32);
            this.overrideGlobalButton.setLayoutData((Object)overrideData);
            this.overrideGlobalButton.setText(ResourceHandler.getExternalizedMessage("PROP_BUTTON_OVERRIDE", new String[]{ValidationPropertiesPage.this.getProject().getName()}));
            this.overrideGlobalButton.setFocus();
            this.overrideGlobalButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.pagePreferences.setDoesProjectOverride(this.this$1.overrideGlobalButton.getSelection());
                    try {
                        this.this$1.updateWidgets();
                    }
                    catch (InvocationTargetException exc) {
                        ValidatorListPage.access$5(this.this$1).displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                }
            });
            this.emptyRowPlaceholder = new Label(validatorGroup, 0);
            this.emptyRowPlaceholder.setLayoutData((Object)new GridData());
            GridData disableValidationData = new GridData(768);
            disableValidationData.horizontalSpan = 2;
            this.disableAllValidation = new Button(validatorGroup, 32);
            this.disableAllValidation.setLayoutData((Object)disableValidationData);
            this.disableAllValidation.setText(ResourceHandler.getExternalizedMessage("DISABLE_VALIDATION"));
            this.disableAllValidation.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.pagePreferences.setDisableAllValidation(this.this$1.disableAllValidation.getSelection());
                    this.this$1.disableAllValidation.setFocus();
                    ValidatorListPage.access$0(this.this$1).setEnabled(!this.this$1.disableAllValidation.getSelection());
                    ValidatorListPage.access$1(this.this$1).setEnabled(!this.this$1.disableAllValidation.getSelection());
                    ValidatorListPage.access$2(this.this$1).setEnabled(!this.this$1.disableAllValidation.getSelection());
                }
            });
            this.emptyRowPlaceholder = new Label(validatorGroup, 0);
            this.emptyRowPlaceholder.setLayoutData((Object)new GridData());
            GridData listLabelData = new GridData(768);
            listLabelData.horizontalSpan = 2;
            this.messageLabel = new Label(validatorGroup, 0);
            this.messageLabel.setText(ResourceHandler.getExternalizedMessage("VBF_UI_LBL_DESC", new String[]{ValidationPropertiesPage.this.getProject().getName()}));
            this.messageLabel.setLayoutData((Object)listLabelData);
            this.validatorsTable = new Table(validatorGroup, 2048);
            TableLayout tableLayout = new TableLayout();
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(160, true));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(80, true));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(80, true));
            this.validatorsTable.setHeaderVisible(true);
            this.validatorsTable.setLinesVisible(true);
            this.validatorsTable.setLayout((Layout)tableLayout);
            this.validatorList = new TableViewer(this.validatorsTable);
            GridData validatorListData = new GridData(768);
            validatorListData.horizontalSpan = 2;
            this.validatorsTable.setLayoutData((Object)validatorListData);
            this.validatorList.getTable().setLayoutData((Object)validatorListData);
            this.validatorList.setLabelProvider((IBaseLabelProvider)new ValidationLabelProvider());
            this.validatorList.setContentProvider((IContentProvider)new ValidationContentProvider());
            this.validatorList.setSorter((ViewerSorter)new ValidationViewerSorter());
            this.setupTableColumns(this.validatorsTable, this.validatorList);
            this.validatorList.setCellModifier(new ICellModifier(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public boolean canModify(Object element, String property) {
                    ComboBoxCellEditor cellEditor = this.getComboBoxCellEditor(property);
                    return cellEditor != null;
                }

                protected ComboBoxCellEditor getComboBoxCellEditor(String property) {
                    CellEditor cellEditor = this.getCellEditor(property);
                    if (cellEditor instanceof ComboBoxCellEditor) {
                        return (ComboBoxCellEditor)cellEditor;
                    }
                    return null;
                }

                protected int getPropertyIntValue(String property) {
                    if (ValidatorListPage.access$3(this.this$1) != null) {
                        int i = 0;
                        while (i < ValidatorListPage.access$3(this.this$1).length) {
                            if (ValidatorListPage.access$3(this.this$1)[i].equals(property)) {
                                return i;
                            }
                            ++i;
                        }
                    }
                    return -1;
                }

                protected CellEditor getCellEditor(String property) {
                    int comboCellEditorIndex = this.getPropertyIntValue(property);
                    if (comboCellEditorIndex == -1) {
                        return null;
                    }
                    return ValidatorListPage.access$4(this.this$1)[comboCellEditorIndex];
                }

                public Object getValue(Object element, String property) {
                    ValidatorMetaData data = (ValidatorMetaData)element;
                    if (property == "manualCheck") {
                        if (data.isManualValidation()) {
                            return new Integer(0);
                        }
                        return new Integer(1);
                    }
                    if (property == "buildCheck") {
                        if (data.isBuildValidation()) {
                            return new Integer(0);
                        }
                        return new Integer(1);
                    }
                    return new Integer(-1);
                }

                public void modify(Object element, String property, Object value) {
                    ValidatorMetaData data = (ValidatorMetaData)((TableItem)element).getData();
                    int intValue = (Integer)value;
                    if (property.equals("manualCheck")) {
                        if (intValue == 0) {
                            data.setManualValidation(true);
                        } else if (intValue == 1) {
                            data.setManualValidation(false);
                        }
                    } else if (property.equals("buildCheck")) {
                        if (intValue == 0) {
                            data.setBuildValidation(true);
                        } else if (intValue == 1) {
                            data.setBuildValidation(false);
                        }
                    }
                    this.this$1.validatorList.refresh();
                }
            });
            this.validatorList.setInput((Object)this.pagePreferences.getValidators());
            this.enableAllButton = new Button(validatorGroup, 8);
            GridData selectData = new GridData();
            this.enableAllButton.setLayoutData((Object)selectData);
            this.enableAllButton.setText(ResourceHandler.getExternalizedMessage("PREF_BUTTON_ENABLEALL"));
            this.enableAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    try {
                        this.this$1.performEnableAll();
                    }
                    catch (InvocationTargetException exc) {
                        ValidatorListPage.access$5(this.this$1).displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.enableAllButton, "org.eclipse.wst.common.frameworks.ui.jvpp0000");
            GridData deselectData = new GridData();
            this.disableAllButton = new Button(validatorGroup, 8);
            this.disableAllButton.setLayoutData((Object)deselectData);
            this.disableAllButton.setText(ResourceHandler.getExternalizedMessage("PREF_BUTTON_DISABLEALL"));
            this.disableAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    try {
                        this.this$1.performDisableAll();
                    }
                    catch (InvocationTargetException exc) {
                        ValidatorListPage.access$5(this.this$1).displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.disableAllButton, "org.eclipse.wst.common.frameworks.ui.jvpp0000");
            Composite maxGroup = new Composite(this.page, 0);
            GridLayout maxGroupLayout = new GridLayout();
            maxGroupLayout.numColumns = 2;
            maxGroup.setLayout((Layout)maxGroupLayout);
            GridData maxGroupData = new GridData(256);
            maxGroup.setLayoutData((Object)maxGroupData);
            validatorGroup.setTabList(new Control[]{this.overrideGlobalButton, this.validatorList.getTable(), this.enableAllButton, this.disableAllButton});
            this.updateWidgets();
            this.page.setSize(this.page.computeSize(-1, -1));
            return this.page;
        }

        protected void updateTable() throws InvocationTargetException {
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                ValidatorMetaData vmd = (ValidatorMetaData)item.getData();
                if (this.pagePreferences.isManualEnabled(vmd)) {
                    vmd.setManualValidation(true);
                } else {
                    vmd.setManualValidation(false);
                }
                if (this.pagePreferences.isBuildEnabled(vmd)) {
                    vmd.setBuildValidation(true);
                } else {
                    vmd.setBuildValidation(false);
                }
                ++i;
            }
            this.validatorList.refresh();
        }

        protected void enableManualAndBuildValues() {
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                ValidatorMetaData vmd = (ValidatorMetaData)item.getData();
                vmd.setManualValidation(true);
                vmd.setBuildValidation(true);
                ++i;
            }
            this.validatorList.refresh();
        }

        protected void disableManualAndBuildValues() {
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                ValidatorMetaData vmd = (ValidatorMetaData)item.getData();
                vmd.setManualValidation(false);
                vmd.setBuildValidation(false);
                ++i;
            }
            this.validatorList.refresh();
        }

        public boolean performDefaults() throws InvocationTargetException {
            this.pagePreferences.resetToDefault();
            this.updateWidgets();
            ValidationPropertiesPage.this.getDefaultsButton().setFocus();
            return true;
        }

        public boolean performEnableAll() throws InvocationTargetException {
            this.setAllValidators(true);
            this.pagePreferences.setEnabledValidators(this.getEnabledValidators());
            this.enableManualAndBuildValues();
            this.enableAllButton.setFocus();
            return true;
        }

        public boolean performDisableAll() throws InvocationTargetException {
            this.setAllValidators(false);
            this.pagePreferences.setEnabledValidators(this.getEnabledValidators());
            this.disableManualAndBuildValues();
            this.disableAllButton.setFocus();
            return true;
        }

        public ValidatorMetaData[] getEnabledValidators() {
            ArrayList<ValidatorMetaData> enabledValidators = new ArrayList<ValidatorMetaData>();
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                ValidatorMetaData validatorMetaData = (ValidatorMetaData)items[i].getData();
                if (validatorMetaData.isManualValidation() || validatorMetaData.isBuildValidation()) {
                    enabledValidators.add(validatorMetaData);
                }
                ++i;
            }
            return enabledValidators.toArray(new ValidatorMetaData[enabledValidators.size()]);
        }

        public ValidatorMetaData[] getManualEnabledValidators() {
            ArrayList<ValidatorMetaData> enabledValidators = new ArrayList<ValidatorMetaData>();
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                ValidatorMetaData validatorMetaData = (ValidatorMetaData)items[i].getData();
                if (validatorMetaData.isManualValidation()) {
                    enabledValidators.add(validatorMetaData);
                }
                ++i;
            }
            return enabledValidators.toArray(new ValidatorMetaData[enabledValidators.size()]);
        }

        public ValidatorMetaData[] getBuildEnabledValidators() {
            ArrayList<ValidatorMetaData> enabledValidators = new ArrayList<ValidatorMetaData>();
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                ValidatorMetaData validatorMetaData = (ValidatorMetaData)items[i].getData();
                if (validatorMetaData.isBuildValidation()) {
                    enabledValidators.add(validatorMetaData);
                }
                ++i;
            }
            return enabledValidators.toArray(new ValidatorMetaData[enabledValidators.size()]);
        }

        private void setAllValidators(boolean bool) {
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                ValidatorMetaData validatorMetaData = (ValidatorMetaData)items[i].getData();
                validatorMetaData.setManualValidation(bool);
                validatorMetaData.setBuildValidation(bool);
                ++i;
            }
        }

        void updateWidgets() throws InvocationTargetException {
            this.updateTable();
            this.updateAllWidgets();
        }

        protected void updateWidgetsForDefaults() throws InvocationTargetException {
            this.updateTableForDefaults();
            this.updateAllWidgets();
        }

        private void updateAllWidgets() throws InvocationTargetException {
            ConfigurationManager prefMgr = ConfigurationManager.getManager();
            this.canOverride = prefMgr.getGlobalConfiguration().canProjectsOverride();
            boolean overridePreferences = this.canOverride && this.pagePreferences.doesProjectOverride();
            this.overrideGlobalButton.setEnabled(this.canOverride);
            this.overrideGlobalButton.setSelection(overridePreferences);
            this.disableAllValidation.setEnabled(overridePreferences);
            this.disableAllValidation.setSelection(this.pagePreferences.isDisableAllValidation());
            if (overridePreferences) {
                this.enableDependentControls(!this.pagePreferences.isDisableAllValidation());
            } else {
                this.enableDependentControls(overridePreferences);
            }
            this.updateHelp();
        }

        private void updateTableForDefaults() throws InvocationTargetException {
            TableItem[] items = this.validatorsTable.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                ValidatorMetaData vmd = (ValidatorMetaData)item.getData();
                if (this.pagePreferences.isEnabled(vmd)) {
                    vmd.setManualValidation(true);
                    vmd.setBuildValidation(true);
                } else {
                    vmd.setManualValidation(false);
                    vmd.setBuildValidation(false);
                }
                ++i;
            }
            this.validatorList.refresh();
        }

        private void enableDependentControls(boolean overridePreferences) {
            this.validatorsTable.setEnabled(overridePreferences);
            this.enableAllButton.setEnabled(overridePreferences);
            this.disableAllButton.setEnabled(overridePreferences);
        }

        protected void updateHelp() throws InvocationTargetException {
            if (this.overrideGlobalButton.getEnabled()) {
                boolean doesProjectSupportBuildValidation = ValidatorManager.doesProjectSupportBuildValidation((IProject)ValidationPropertiesPage.this.getProject());
                ConfigurationManager.getManager().getGlobalConfiguration();
                if (doesProjectSupportBuildValidation) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.overrideGlobalButton, "org.eclipse.wst.common.frameworks.ui.jvpp0030");
                }
            } else {
                this.validatorList.getTable().setFocus();
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.validatorList.getTable(), "org.eclipse.wst.common.frameworks.ui.jvpp0001");
            }
        }

        private void storeValues() throws InvocationTargetException {
            this.pagePreferences.setDoesProjectOverride(this.overrideGlobalButton.getSelection());
            if (this.pagePreferences.doesProjectOverride()) {
                this.pagePreferences.setEnabledManualValidators(this.getManualEnabledValidators());
                this.pagePreferences.setEnabledBuildValidators(this.getBuildEnabledValidators());
            } else {
                this.pagePreferences.resetToDefault();
            }
            this.pagePreferences.store();
        }

        public boolean performOk() throws InvocationTargetException {
            this.addBuilder();
            this.storeValues();
            if (this.pagePreferences.hasEnabledValidatorsChanged(this.oldVmd, false)) {
                ValidatorManager.getManager().updateTaskList(ValidationPropertiesPage.this.getProject());
            }
            return true;
        }

        private void addBuilder() {
            this.overrideGlobalButton.getSelection();
        }

        public Composite getControl() {
            return this.page;
        }

        public void dispose() {
            this.enableAllButton.dispose();
            this.disableAllButton.dispose();
            this.validatorList.getTable().dispose();
            this.messageLabel.dispose();
            this.emptyRowPlaceholder.dispose();
            this.overrideGlobalButton.dispose();
            this.page.dispose();
        }

        static /* synthetic */ Table access$0(ValidatorListPage validatorListPage) {
            return validatorListPage.validatorsTable;
        }

        static /* synthetic */ Button access$1(ValidatorListPage validatorListPage) {
            return validatorListPage.enableAllButton;
        }

        static /* synthetic */ Button access$2(ValidatorListPage validatorListPage) {
            return validatorListPage.disableAllButton;
        }

        static /* synthetic */ String[] access$3(ValidatorListPage validatorListPage) {
            return validatorListPage.columnProperties;
        }

        static /* synthetic */ CellEditor[] access$4(ValidatorListPage validatorListPage) {
            return validatorListPage.columnEditors;
        }

        static /* synthetic */ ValidationPropertiesPage access$5(ValidatorListPage validatorListPage) {
            return validatorListPage.ValidationPropertiesPage.this;
        }

        public class ValidationContentProvider
        implements IStructuredContentProvider {
            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ValidatorMetaData[]) {
                    return (ValidatorMetaData[])inputElement;
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        public class ValidationLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                if (element instanceof ValidatorMetaData) {
                    return ((ValidatorMetaData)element).getValidatorDisplayName();
                }
                return super.getText(element);
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return ((ValidatorMetaData)element).getValidatorDisplayName();
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 1) {
                    if (((ValidatorMetaData)element).isManualValidation()) {
                        return ValidationUIPlugin.getPlugin().getImage("ok_tbl");
                    }
                    return ValidationUIPlugin.getPlugin().getImage("fail_tbl");
                }
                if (columnIndex == 2) {
                    if (((ValidatorMetaData)element).isBuildValidation()) {
                        return ValidationUIPlugin.getPlugin().getImage("ok_tbl");
                    }
                    return ValidationUIPlugin.getPlugin().getImage("fail_tbl");
                }
                return null;
            }
        }

        public class ValidationViewerSorter
        extends ViewerSorter {
            public int compare(Viewer viewer, Object e1, Object e2) {
                return super.compare(viewer, e1, e2);
            }
        }
    }
}

