/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.ValidationConfiguration;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class ProjectConfiguration
extends ValidationConfiguration {
    static final boolean PRJ_OVERRIDEGLOBAL_DEFAULT = false;
    private boolean _doesProjectOverride = ProjectConfiguration.getDoesProjectOverrideDefault();

    protected ProjectConfiguration(IProject project) throws InvocationTargetException {
        super((IResource)project, ProjectConfiguration.extractProjectValidators(ProjectConfiguration.convertToArray(ValidationRegistryReader.getReader().getAllValidators()), (IResource)project));
    }

    public ProjectConfiguration(ProjectConfiguration original) throws InvocationTargetException {
        original.copyTo(this);
    }

    protected boolean useGlobalPreference() {
        try {
            GlobalConfiguration gp = ConfigurationManager.getManager().getGlobalConfiguration();
            if (gp == null) {
                return false;
            }
            if (!gp.canProjectsOverride()) {
                return true;
            }
            return !this._doesProjectOverride;
        }
        catch (InvocationTargetException exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ProjectConfiguration.userGlobalPreference");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
            return false;
        }
    }

    public boolean doesProjectOverride() {
        return !this.useGlobalPreference();
    }

    public void setDoesProjectOverride(boolean does) {
        this._doesProjectOverride = does;
    }

    public ValidatorMetaData[] getEnabledValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ProjectConfiguration.extractProjectValidators(ConfigurationManager.getManager().getGlobalConfiguration().getEnabledValidators(), this.getResource());
        }
        return super.getEnabledValidators();
    }

    public ValidatorMetaData[] getManualEnabledValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ProjectConfiguration.extractProjectValidators(ConfigurationManager.getManager().getGlobalConfiguration().getManualEnabledValidators(), this.getResource());
        }
        return super.getManualEnabledValidators();
    }

    public ValidatorMetaData[] getBuildEnabledValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ProjectConfiguration.extractProjectValidators(ConfigurationManager.getManager().getGlobalConfiguration().getBuildEnabledValidators(), this.getResource());
        }
        return super.getBuildEnabledValidators();
    }

    public ValidatorMetaData[] getDisabledValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ProjectConfiguration.extractProjectValidators(ConfigurationManager.getManager().getGlobalConfiguration().getDisabledValidators(), this.getResource());
        }
        return super.getDisabledValidators();
    }

    public ValidatorMetaData[] getValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ProjectConfiguration.extractProjectValidators(ConfigurationManager.getManager().getGlobalConfiguration().getValidators(), this.getResource());
        }
        return super.getValidators();
    }

    public ValidatorMetaData[] getEnabledIncrementalValidators(boolean incremental) throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ProjectConfiguration.extractProjectValidators(ConfigurationManager.getManager().getGlobalConfiguration().getEnabledIncrementalValidators(incremental), this.getResource());
        }
        return super.getEnabledIncrementalValidators(incremental);
    }

    public boolean isEnabled(ValidatorMetaData vmd) throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ConfigurationManager.getManager().getGlobalConfiguration().isEnabled(vmd);
        }
        return super.isEnabled(vmd);
    }

    public int numberOfDisabledValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ConfigurationManager.getManager().getGlobalConfiguration().numberOfDisabledValidators();
        }
        return super.numberOfDisabledValidators();
    }

    public int numberOfEnabledIncrementalValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ConfigurationManager.getManager().getGlobalConfiguration().numberOfEnabledIncrementalValidators();
        }
        return super.numberOfEnabledIncrementalValidators();
    }

    public int numberOfEnabledValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ConfigurationManager.getManager().getGlobalConfiguration().numberOfEnabledValidators();
        }
        return super.numberOfEnabledValidators();
    }

    public int numberOfIncrementalValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ConfigurationManager.getManager().getGlobalConfiguration().numberOfIncrementalValidators();
        }
        return super.numberOfIncrementalValidators();
    }

    public int numberOfValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ConfigurationManager.getManager().getGlobalConfiguration().numberOfValidators();
        }
        return super.numberOfValidators();
    }

    public void setEnabledValidators(ValidatorMetaData[] vmds) {
        super.setEnabledValidators(ProjectConfiguration.extractProjectValidators(vmds, this.getResource()));
    }

    public void setValidators(ValidatorMetaData[] vmds) {
        super.setValidators(ProjectConfiguration.extractProjectValidators(vmds, this.getResource()));
    }

    private static ValidatorMetaData[] extractProjectValidators(ValidatorMetaData[] vmds, IResource resource) {
        ValidationRegistryReader reader = ValidationRegistryReader.getReader();
        int length = vmds == null ? 0 : vmds.length;
        ValidatorMetaData[] temp = new ValidatorMetaData[length];
        if (length == 0) {
            return temp;
        }
        int count = 0;
        IProject project = (IProject)resource;
        int i = 0;
        while (i < vmds.length) {
            ValidatorMetaData vmd = vmds[i];
            if (reader.isConfiguredOnProject(vmd, project)) {
                temp[count++] = vmd;
            }
            ++i;
        }
        ValidatorMetaData[] result = new ValidatorMetaData[count];
        System.arraycopy(temp, 0, result, 0, count);
        temp = null;
        return result;
    }

    public int getMaximumNumberOfMessages() throws InvocationTargetException {
        return -1;
    }

    public void resetToDefault() throws InvocationTargetException {
        GlobalConfiguration gp = ConfigurationManager.getManager().getGlobalConfiguration();
        this.setEnabledManualValidators(gp.getManualEnabledValidators());
        this.setEnabledBuildValidators(gp.getBuildEnabledValidators());
        this.setDoesProjectOverride(ProjectConfiguration.getDoesProjectOverrideDefault());
    }

    public void resetToDefaultForProjectDescriptionChange() throws InvocationTargetException {
        GlobalConfiguration gp = ConfigurationManager.getManager().getGlobalConfiguration();
        this.setEnabledManualValidators(gp.getManualEnabledValidators());
        this.setEnabledBuildValidators(gp.getBuildEnabledValidators());
    }

    public void resetProjectNature() {
    }

    protected IMarker[] getMarker() {
        try {
            IMarker[] allMarkers = this.getResource().findMarkers("org.eclipse.jst.j2ee.projectmarker", false, 0);
            if (allMarkers == null || allMarkers.length == 0) {
                allMarkers = this.getResource().findMarkers("org.eclipse.wst.validation.projectmarker", false, 0);
            }
            if (allMarkers.length == 1) {
                return allMarkers;
            }
            return null;
        }
        catch (CoreException exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ProjectConfiguration::getMarker");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
            return null;
        }
    }

    protected void load(IMarker[] marker) {
        block11: {
            try {
                if (marker == null) {
                    this.resetToDefault();
                    return;
                }
                IMarker prjMarker = marker[0];
                GlobalConfiguration gp = ConfigurationManager.getManager().getGlobalConfiguration();
                ValidatorMetaData[] enabledManaualVal = null;
                ValidatorMetaData[] enabledBuildVal = null;
                String enabledManualValStr = (String)this.getValue(prjMarker, "enabledManualValidatorList");
                String enabledBuildValStr = (String)this.getValue(prjMarker, "enabledBuildValidatorList");
                if (enabledManualValStr.equals(null) || enabledBuildValStr.equals(null)) {
                    gp.getEnabledValidators();
                } else {
                    enabledManaualVal = ProjectConfiguration.getStringAsEnabledElementsArray(enabledManualValStr);
                    this.setEnabledManualValidators(enabledManaualVal);
                    enabledBuildVal = ProjectConfiguration.getStringAsEnabledElementsArray(enabledManualValStr);
                    this.setEnabledBuildValidators(enabledBuildVal);
                }
                String version = this.loadVersion(marker);
                Boolean boolVal = (Boolean)this.getValue(prjMarker, "overrideGlobalPreferences");
                if (boolVal == null && version.equals("4.03")) {
                    this.setDoesProjectOverride(true);
                } else if (boolVal == null) {
                    this.setDoesProjectOverride(ProjectConfiguration.getDoesProjectOverrideDefault());
                } else {
                    this.setDoesProjectOverride(boolVal);
                }
                this.doesProjectOverride();
                this.getResource().getWorkspace().deleteMarkers(marker);
            }
            catch (CoreException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    LogEntry entry = ValidationPlugin.getLogEntry();
                    entry.setSourceIdentifier("ProjectConfiguration.loadMarker ");
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                }
            }
            catch (InvocationTargetException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block11;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ProjectConfiguration.loadMarker InvocationTargetException");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    protected void copyTo(ProjectConfiguration prjp) throws InvocationTargetException {
        super.copyTo(prjp);
        prjp.setDoesProjectOverride(this.doesProjectOverride());
    }

    public static boolean getDoesProjectOverrideDefault() {
        return false;
    }

    public boolean hasEnabledValidatorsChanged(ValidatorMetaData[] oldEnabledVmd, boolean allow) throws InvocationTargetException {
        if (super.hasEnabledValidatorsChanged(oldEnabledVmd)) {
            return true;
        }
        if (allow) {
            ValidatorMetaData[] projEnabledVmd = super.getEnabledValidators();
            GlobalConfiguration gp = ConfigurationManager.getManager().getGlobalConfiguration();
            return gp.hasEnabledValidatorsChanged(projEnabledVmd);
        }
        return false;
    }

    public void deserialize(String storedConfiguration) throws InvocationTargetException {
        if (storedConfiguration == null) {
            this.resetToDefault();
        } else if (storedConfiguration != null) {
            int prjOverrideIndex = storedConfiguration.indexOf("overrideGlobalPreferences");
            int disableAllValidationIndex = storedConfiguration.indexOf("disableAllValidation");
            int versionIndex = storedConfiguration.indexOf("version");
            if (disableAllValidationIndex != -1) {
                String disableAllValidation = storedConfiguration.substring(disableAllValidationIndex + "disableAllValidation".length(), versionIndex);
                this.setDisableAllValidation(Boolean.valueOf(disableAllValidation));
            } else {
                this.setDisableAllValidation(false);
            }
            if (disableAllValidationIndex != -1) {
                String prjOverride = storedConfiguration.substring(prjOverrideIndex + "overrideGlobalPreferences".length(), disableAllValidationIndex);
                this.setDoesProjectOverride(Boolean.valueOf(prjOverride));
            }
        }
    }

    public String serialize() throws InvocationTargetException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("overrideGlobalPreferences");
        buffer.append(String.valueOf(this.doesProjectOverride()));
        if (this.doesProjectOverride()) {
            buffer.append(super.serialize());
        }
        return buffer.toString();
    }

    public ValidatorMetaData[] getEnabledFullBuildValidators(boolean fullBuild) throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ProjectConfiguration.extractProjectValidators(ConfigurationManager.getManager().getGlobalConfiguration().getEnabledFullBuildValidators(fullBuild), this.getResource());
        }
        return super.getEnabledFullBuildValidators(fullBuild);
    }

    private static ValidatorMetaData[] extractProjectValidators(ValidatorMetaData[] vmds, IResource resource, boolean onlyReferenced) {
        ValidationRegistryReader reader = ValidationRegistryReader.getReader();
        int length = vmds == null ? 0 : vmds.length;
        ValidatorMetaData[] temp = new ValidatorMetaData[length];
        if (length == 0) {
            return temp;
        }
        int count = 0;
        IProject project = (IProject)resource;
        int i = 0;
        while (i < vmds.length) {
            ValidatorMetaData vmd = vmds[i];
            if (reader.isConfiguredOnProject(vmd, project) && (!onlyReferenced || vmd.isDependentValidator())) {
                temp[count++] = vmd;
            }
            ++i;
        }
        ValidatorMetaData[] result = new ValidatorMetaData[count];
        System.arraycopy(temp, 0, result, 0, count);
        temp = null;
        return result;
    }

    public ValidatorMetaData[] getEnabledFullBuildValidators(boolean fullBuild, boolean onlyReferenced) throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ProjectConfiguration.extractProjectValidators(ConfigurationManager.getManager().getGlobalConfiguration().getEnabledFullBuildValidators(fullBuild), this.getResource(), onlyReferenced);
        }
        return super.getEnabledFullBuildValidators(fullBuild, onlyReferenced);
    }

    public ValidatorMetaData[] getIncrementalValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ProjectConfiguration.extractProjectValidators(ConfigurationManager.getManager().getGlobalConfiguration().getIncrementalValidators(), this.getResource());
        }
        return super.getIncrementalValidators();
    }

    public int numberOfManualValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ConfigurationManager.getManager().getGlobalConfiguration().numberOfManualEnabledValidators();
        }
        return super.numberOfManualEnabledValidators();
    }

    public boolean isDisableAllValidation() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ConfigurationManager.getManager().getGlobalConfiguration().isDisableAllValidation();
        }
        return super.isDisableAllValidation();
    }
}

