/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.validation.internal.EventManager;
import org.eclipse.wst.validation.internal.RegistryConstants;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.ValidatorFilter;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.ValidatorNameFilter;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public final class ValidationRegistryReader
implements RegistryConstants {
    private static ValidationRegistryReader inst = null;
    private HashMap _validators;
    private HashMap _indexedValidators;
    private Set _defaultEnabledValidators;
    private static final String IRESOURCE = "org.eclipse.core.resources.IResource";
    private static final String UNKNOWN_PROJECT = "UNKNOWN";
    private static final String EXCLUDED_PROJECT = "EXCLUDED";
    private List _tempList;
    public HashMap projectValidationMetaData;

    private ValidationRegistryReader() {
        block2: {
            this._tempList = null;
            this.projectValidationMetaData = null;
            try {
                this._validators = new HashMap();
                this._indexedValidators = new HashMap();
                this._defaultEnabledValidators = new HashSet();
                this.readRegistry();
                this.buildCache();
            }
            catch (Throwable exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block2;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("ValidationRegistryReader()");
                entry.setTargetException(exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    private void buildCache() {
        Iterator iterator = this._indexedValidators.values().iterator();
        while (iterator.hasNext()) {
            ValidatorMetaData vmd = (ValidatorMetaData)iterator.next();
            this.buildProjectNatureCache(vmd);
            this.buildDefaultEnabledCache(vmd);
        }
        this.addRemainder();
        this._validators.remove(EXCLUDED_PROJECT);
        Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
        if (logger.isLoggingLevel(Level.FINEST)) {
            LogEntry entry = ValidationPlugin.getLogEntry();
            entry.setSourceID("ValidationRegistryReader.buildCache()");
            entry.setText(this.debug());
            logger.write(Level.FINEST, (Object)entry);
        }
    }

    private void buildProjectNatureCache(ValidatorMetaData vmd) {
        ValidatorNameFilter[] projNatureIds = vmd.getProjectNatureFilters();
        if (projNatureIds == null) {
            this.add(UNKNOWN_PROJECT, vmd);
        } else {
            boolean noneIncluded = true;
            int i = 0;
            while (i < projNatureIds.length) {
                ValidatorNameFilter pn = projNatureIds[i];
                if (pn.isInclude()) {
                    noneIncluded = false;
                    this.add(pn.getNameFilter(), vmd);
                }
                ++i;
            }
            if (noneIncluded) {
                this.add(EXCLUDED_PROJECT, vmd);
            }
        }
    }

    private void buildDefaultEnabledCache(ValidatorMetaData vmd) {
        if (vmd == null) {
            return;
        }
        if (vmd.isEnabledByDefault()) {
            this._defaultEnabledValidators.add(vmd);
        }
    }

    private void add(ValidatorMetaData vmd) {
        if (vmd == null) {
            return;
        }
        this._indexedValidators.put(vmd.getValidatorUniqueName(), vmd);
    }

    private void addRemainder() {
        this.addAnyRemainder();
        this.addExcludedRemainder();
    }

    private void addExcludedRemainder() {
        Set excludedProjVmds = (Set)this._validators.get(EXCLUDED_PROJECT);
        if (excludedProjVmds == null) {
            return;
        }
        Iterator exIterator = excludedProjVmds.iterator();
        while (exIterator.hasNext()) {
            ValidatorMetaData vmd = (ValidatorMetaData)exIterator.next();
            boolean noneIncluded = true;
            Set keys = this._validators.keySet();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String projId = (String)iterator.next();
                if (projId.equals(UNKNOWN_PROJECT) || projId.equals(EXCLUDED_PROJECT)) continue;
                ValidatorNameFilter filter = vmd.findProjectNature(projId);
                if (filter != null) {
                    if (!filter.isInclude()) continue;
                    noneIncluded = false;
                    continue;
                }
                this.add(projId, vmd);
            }
            if (!noneIncluded) continue;
            this.add(UNKNOWN_PROJECT, vmd);
        }
    }

    private void addAnyRemainder() {
        Set anyProjVmds = (Set)this._validators.get(UNKNOWN_PROJECT);
        if (anyProjVmds == null) {
            return;
        }
        Set keys = this._validators.keySet();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String projId = (String)iterator.next();
            if (projId.equals(UNKNOWN_PROJECT) || projId.equals(EXCLUDED_PROJECT)) continue;
            this.add(projId, anyProjVmds);
        }
    }

    private void add(String projectNatureId, Set vmdList) {
        if (vmdList == null || vmdList.size() == 0) {
            return;
        }
        Set pnVal = this.createSet(projectNatureId);
        pnVal.addAll(vmdList);
        this._validators.put(projectNatureId, pnVal);
    }

    private void add(String projectNatureId, ValidatorMetaData vmd) {
        if (vmd == null) {
            return;
        }
        Set pnVal = this.createSet(projectNatureId);
        pnVal.add(vmd);
        this._validators.put(projectNatureId, pnVal);
    }

    public void disableValidator(ValidatorMetaData vmd) {
        this._indexedValidators.remove(vmd.getValidatorUniqueName());
        this._defaultEnabledValidators.remove(vmd);
        Object[] keys = this._validators.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            Object key = keys[i];
            Set value = (Set)this._validators.get(key);
            if (value != null && value.contains(vmd)) {
                value.remove(vmd);
                this._validators.put(key, value);
            }
            ++i;
        }
    }

    private Set createSet(String projNature) {
        HashSet v = (HashSet)this._validators.get(projNature);
        if (v == null) {
            v = new HashSet();
        }
        return v;
    }

    private String[] getAggregateValidatorsNames(IConfigurationElement element) {
        IConfigurationElement[] filters = element.getChildren("aggregateValidator");
        if (filters.length == 0) {
            return null;
        }
        String[] names = new String[filters.length];
        int i = 0;
        while (i < names.length) {
            String nameFilter = filters[i].getAttribute("class");
            if (nameFilter != null) {
                nameFilter = nameFilter.intern();
            }
            names[i] = nameFilter;
            ++i;
        }
        return names;
    }

    private ValidatorFilter[] getFilters(IConfigurationElement element) {
        IConfigurationElement[] filters = element.getChildren("filter");
        if (filters.length == 0) {
            return null;
        }
        ValidatorFilter[] vf = new ValidatorFilter[filters.length];
        int i = 0;
        while (i < filters.length) {
            vf[i] = new ValidatorFilter(IRESOURCE);
            String nameFilter = filters[i].getAttribute("nameFilter");
            if (nameFilter != null) {
                nameFilter = nameFilter.intern();
            }
            String isCaseSensitive = filters[i].getAttribute("caseSensitive");
            vf[i].setNameFilter(nameFilter, isCaseSensitive);
            String objectClass = filters[i].getAttribute("objectClass");
            if (objectClass != null) {
                objectClass = objectClass.intern();
            }
            vf[i].setTypeFilter(objectClass);
            String actionFilter = filters[i].getAttribute("action");
            if (actionFilter != null) {
                actionFilter = actionFilter.intern();
            }
            vf[i].setActionFilter(actionFilter);
            ++i;
        }
        return vf;
    }

    public boolean getDependentValidatorValue(IConfigurationElement element) {
        IConfigurationElement[] depValidatorElement = element.getChildren("dependentValidator");
        if (depValidatorElement.length == 0) {
            return false;
        }
        String depValue = depValidatorElement[0].getAttribute("depValValue");
        boolean depBoolValue = new Boolean(depValue);
        return depBoolValue;
    }

    public String getMarkerIdValue(IConfigurationElement element) {
        IConfigurationElement[] markerId = element.getChildren("markerId");
        if (markerId.length == 0) {
            return null;
        }
        return markerId[0].getAttribute("markerIdValue");
    }

    public String[] getFacetIds(IConfigurationElement element) {
        IConfigurationElement[] facets = element.getChildren("facet");
        if (facets.length == 0) {
            return null;
        }
        String[] facetIds = new String[facets.length];
        int i = 0;
        while (i < facets.length) {
            facetIds[i] = facets[i].getAttribute("facetId");
            ++i;
        }
        return facetIds;
    }

    private String getHelperName(IConfigurationElement element) {
        IConfigurationElement[] helpers = element.getChildren("helper");
        if (helpers.length == 0) {
            return null;
        }
        return helpers[0].getAttribute("class");
    }

    static IWorkbenchContext createHelper(IConfigurationElement element, String helperClassName) {
        IWorkbenchContext wh = null;
        try {
            wh = (IWorkbenchContext)element.createExecutableExtension("helper");
        }
        catch (Throwable exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("ValidationRegistryReader.createHelper(IConfigurationElement, String)");
                entry.setMessageTypeIdentifier("VBF_EXC_SYNTAX_NO_HELPER_THROWABLE");
                entry.setTargetException(exc);
                String result = MessageFormat.format(ResourceHandler.getExternalizedMessage("VBF_EXC_SYNTAX_NO_HELPER_THROWABLE"), helperClassName);
                entry.setText(result);
                logger.write(Level.SEVERE, (Object)entry);
            }
            return null;
        }
        return wh;
    }

    static IValidator createValidator(IConfigurationElement element, String validatorClassName) {
        IValidator validator;
        block4: {
            validator = null;
            try {
                validator = (IValidator)element.createExecutableExtension("run");
            }
            catch (Throwable exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block4;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("ValidationRegistryReader.createValidator(IConfigurationElement, String, String)");
                entry.setMessageTypeID("VBF_EXC_SYNTAX_NO_VAL_THROWABLE");
                String result = MessageFormat.format(ResourceHandler.getExternalizedMessage("VBF_EXC_SYNTAX_NO_VAL_THROWABLE"), validatorClassName);
                entry.setText(result);
                entry.setTargetException(exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
        if (validator == null) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.FINE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("ValidationRegistryReader.createValidator(IConfigurationElement, String)");
                entry.setMessageTypeID("VBF_EXC_SYNTAX_NO_VAL_NULL");
                entry.setTokens(new String[]{validatorClassName});
                logger.write(Level.FINE, (Object)entry);
            }
            return null;
        }
        return validator;
    }

    private boolean getEnabledByDefault(IConfigurationElement element) {
        IConfigurationElement[] runChildren = element.getChildren("run");
        String inc = runChildren[0].getAttribute("enabled");
        if (inc == null) {
            return true;
        }
        return Boolean.valueOf(inc.trim().toLowerCase());
    }

    private boolean getIncremental(IConfigurationElement element) {
        IConfigurationElement[] runChildren = element.getChildren("run");
        String inc = runChildren[0].getAttribute("incremental");
        if (inc == null) {
            return true;
        }
        return Boolean.valueOf(inc.trim().toLowerCase());
    }

    private boolean getFullBuild(IConfigurationElement element) {
        IConfigurationElement[] runChildren = element.getChildren("run");
        String fb = runChildren[0].getAttribute("fullBuild");
        if (fb == null) {
            return true;
        }
        return Boolean.valueOf(fb.trim().toLowerCase());
    }

    private boolean getAsync(IConfigurationElement element) {
        IConfigurationElement[] runChildren = element.getChildren("run");
        String async = runChildren[0].getAttribute("async");
        if (async == null) {
            return false;
        }
        return Boolean.valueOf(async.trim().toLowerCase());
    }

    private int getRuleGroup(IConfigurationElement element) {
        IConfigurationElement[] runChildren = element.getChildren("run");
        String pass = runChildren[0].getAttribute("ruleGroup");
        if (pass == null) {
            return 1;
        }
        StringTokenizer tokenizer = new StringTokenizer(pass, ",", false);
        int result = 0;
        while (tokenizer.hasMoreTokens()) {
            String nextAction = tokenizer.nextToken().trim();
            if (nextAction.equals("fast")) {
                result |= 1;
                continue;
            }
            if (!nextAction.equals("full")) continue;
            result |= 3;
        }
        if (result == 0) {
            return 1;
        }
        return result;
    }

    private ValidatorMetaData.MigrationMetaData getMigrationMetaData(IConfigurationElement element, ValidatorMetaData vmd) {
        IConfigurationElement[] runChildren = element.getChildren("migrate");
        if (runChildren == null || runChildren.length == 0) {
            return null;
        }
        IConfigurationElement migrate = runChildren[0];
        IConfigurationElement[] migrateChildren = migrate.getChildren("validator");
        if (migrateChildren == null || migrateChildren.length == 0) {
            return null;
        }
        ValidatorMetaData.MigrationMetaData mmd = new ValidatorMetaData.MigrationMetaData(vmd);
        int i = 0;
        while (i < migrateChildren.length) {
            String to;
            IConfigurationElement migrateChild = migrateChildren[i];
            String from = migrateChild.getAttribute("from");
            if (from != null && (to = migrateChild.getAttribute("to")) != null) {
                mmd.addId(from, to);
            }
            ++i;
        }
        return mmd;
    }

    private ValidatorNameFilter[] getProjectNatureFilters(IConfigurationElement element) {
        IConfigurationElement[] filters = element.getChildren("projectNature");
        if (filters.length == 0) {
            return null;
        }
        ValidatorNameFilter[] vf = new ValidatorNameFilter[filters.length];
        int i = 0;
        while (i < filters.length) {
            vf[i] = new ValidatorNameFilter();
            String nameFilter = filters[i].getAttribute("id");
            if (nameFilter != null) {
                nameFilter = nameFilter.intern();
            }
            vf[i].setNameFilter(nameFilter);
            String include = filters[i].getAttribute("include");
            vf[i].setInclude(include);
            ++i;
        }
        return vf;
    }

    public static ValidationRegistryReader getReader() {
        if (inst == null) {
            inst = new ValidationRegistryReader();
            EventManager.getManager().setActive(true);
        }
        return inst;
    }

    public static boolean isActivated() {
        return EventManager.getManager().isActive();
    }

    private IExtensionPoint getValidatorExtensionPoint() {
        Logger logger;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.wst.validation", "validator");
        if (extensionPoint == null && (logger = ValidationPlugin.getPlugin().getMsgLogger()).isLoggingLevel(Level.FINE)) {
            LogEntry entry = ValidationPlugin.getLogEntry();
            entry.setSourceID("ValidationRegistryReader.getValidatorExtensionPoint()");
            entry.setMessageTypeID("VBF_EXC_MISSING_VALIDATOR_EP");
            String result = MessageFormat.format(ResourceHandler.getExternalizedMessage("VBF_EXC_MISSING_VALIDATOR_EP"), "org.eclipse.wst.validation.validator");
            entry.setText(result);
            logger.write(Level.FINE, (Object)entry);
        }
        return extensionPoint;
    }

    public ValidatorMetaData getValidatorMetaData(IValidator validator) {
        if (validator == null) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("ValidationRegistryReader.getValidatorMetaData(IValidator)");
                entry.setText(ResourceHandler.getExternalizedMessage("VBF_EXC_ORPHAN_IVALIDATOR", new String[]{"null"}));
                logger.write(Level.SEVERE, (Object)entry);
            }
            return null;
        }
        String validatorClassName = validator.getClass().getName();
        ValidatorMetaData vmd = this.getValidatorMetaData(validatorClassName);
        if (vmd != null) {
            return vmd;
        }
        Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
        if (logger.isLoggingLevel(Level.SEVERE)) {
            LogEntry entry = ValidationPlugin.getLogEntry();
            entry.setSourceID("ValidationRegistryReader.getValidatorMetaData(IValidator)");
            entry.setText(ResourceHandler.getExternalizedMessage("VBF_EXC_ORPHAN_IVALIDATOR", new String[]{validatorClassName}));
            logger.write(Level.SEVERE, (Object)entry);
        }
        return null;
    }

    public Set getValidatorMetaData(IWorkspaceRoot root) {
        HashSet copy = new HashSet();
        this.clone(this._indexedValidators.values(), copy);
        return copy;
    }

    public Set getValidatorMetaData(IProject project) {
        HashSet copy = new HashSet();
        this.getValidatorMetaData(project, copy);
        return copy;
    }

    /*
     * Exception decompiling
     */
    public void getValidatorMetaData(IProject project, Set vmds) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 444->448)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void calculateVmdsForNatureAndFacets(Set vmds, String[] projectNatures, IProject project) {
        String[] projectFacetIds = this.getProjectFacetIds(project);
        Iterator allValidators = this.getAllValidators().iterator();
        while (allValidators.hasNext()) {
            ValidatorMetaData vmd = (ValidatorMetaData)allValidators.next();
            if (!this.containsProjectFacet(vmd, projectFacetIds)) continue;
            vmds.add(vmd);
        }
        int i = 0;
        while (i < projectNatures.length) {
            String projectNatureId = projectNatures[i];
            Set projVmds = (Set)this._validators.get(projectNatureId);
            if (projVmds != null) {
                Iterator iterator = projVmds.iterator();
                while (iterator.hasNext()) {
                    ValidatorMetaData vmd = (ValidatorMetaData)iterator.next();
                    if (vmds.contains(vmd) || vmd.getFacetFilters() != null && vmd.getFacetFilters().length != 0) continue;
                    vmds.add(vmd);
                }
            }
            ++i;
        }
    }

    private boolean containsProjectFacet(ValidatorMetaData vmd, String[] projectFacetIds) {
        String[] validatorFacets = vmd.getFacetFilters();
        return validatorFacets != null && validatorFacets.length > 0 && projectFacetIds != null && projectFacetIds.length > 0 && Arrays.asList(projectFacetIds).containsAll(Arrays.asList(validatorFacets));
    }

    private String[] getProjectFacetIds(IProject project) {
        try {
            IFacetedProject fProject = ProjectFacetsManager.create((IProject)project);
            if (fProject != null) {
                Object[] projectFacets = fProject.getProjectFacets().toArray();
                String[] projectFacetIds = new String[projectFacets.length];
                int i = 0;
                while (i < projectFacets.length) {
                    IProjectFacet projectFacet = ((IProjectFacetVersion)projectFacets[i]).getProjectFacet();
                    projectFacetIds[i] = projectFacet.getId();
                    ++i;
                }
                return projectFacetIds;
            }
        }
        catch (CoreException ce) {
            Logger.getLogger().log((Throwable)ce);
        }
        return null;
    }

    private void removeExcludedProjects(IProject project, Set vmds) {
        ValidatorMetaData vmd;
        Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
        if (logger.isLoggingLevel(Level.FINEST)) {
            LogEntry entry = ValidationPlugin.getLogEntry();
            entry.setSourceID("ValidationRegistryReader.removeExcludedProjects");
            StringBuffer buffer = new StringBuffer("\nBefore:\n");
            Iterator viterator = vmds.iterator();
            while (viterator.hasNext()) {
                ValidatorMetaData vmd2 = (ValidatorMetaData)viterator.next();
                buffer.append(vmd2.getValidatorUniqueName());
                buffer.append("\n");
            }
            entry.setText(buffer.toString());
            logger.write(Level.FINEST, (Object)entry);
        }
        String[] projectNatures = null;
        try {
            projectNatures = project.getDescription().getNatureIds();
        }
        catch (CoreException exc) {
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("ValidationRegistryReader.getValidatorMetaData(" + project.getName() + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
            return;
        }
        if (projectNatures == null || projectNatures.length == 0) {
            return;
        }
        List tempList = this.getTempList();
        this.clone(vmds, tempList);
        int i = 0;
        while (i < projectNatures.length) {
            String nature = projectNatures[i];
            Iterator iterator = tempList.iterator();
            while (iterator.hasNext()) {
                vmd = (ValidatorMetaData)iterator.next();
                ValidatorNameFilter[] natureFilters = vmd.getProjectNatureFilters();
                if (natureFilters == null) continue;
                int j = 0;
                while (j < natureFilters.length) {
                    ValidatorNameFilter pn = natureFilters[j];
                    if (nature.equals(pn.getNameFilter()) && !pn.isInclude()) {
                        vmds.remove(vmd);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (logger.isLoggingLevel(Level.FINEST)) {
            LogEntry entry = ValidationPlugin.getLogEntry();
            entry.setSourceID("ValidationRegistryReader.removeExcludedProjects");
            StringBuffer buffer = new StringBuffer("\nAfter:\n");
            Iterator viterator = vmds.iterator();
            while (viterator.hasNext()) {
                vmd = (ValidatorMetaData)viterator.next();
                buffer.append(vmd.getValidatorUniqueName());
                buffer.append("\n");
            }
            entry.setText(buffer.toString());
            logger.write(Level.FINEST, (Object)entry);
        }
    }

    private Collection clone(Collection input, Collection copy) {
        if (input == null) {
            return null;
        }
        if (copy == null) {
            return null;
        }
        copy.clear();
        copy.addAll(input);
        return copy;
    }

    public String debug() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Project nature => validators configured");
        buffer.append("\n");
        Iterator<Object> viterator = this._validators.keySet().iterator();
        while (viterator.hasNext()) {
            String projId = (String)viterator.next();
            buffer.append("projId: ");
            buffer.append(projId);
            buffer.append("\n");
            Set validators = (Set)this._validators.get(projId);
            Iterator innerIterator = validators.iterator();
            while (innerIterator.hasNext()) {
                ValidatorMetaData vmd = (ValidatorMetaData)innerIterator.next();
                buffer.append("\t");
                buffer.append(vmd.getValidatorUniqueName());
                buffer.append("\n");
            }
        }
        buffer.append("\n");
        buffer.append("Enable/disable validator by default");
        buffer.append("\n");
        viterator = this._indexedValidators.values().iterator();
        while (viterator.hasNext()) {
            ValidatorMetaData vmd = (ValidatorMetaData)viterator.next();
            buffer.append(vmd.getValidatorUniqueName());
            buffer.append(" enabled? ");
            buffer.append(vmd.isEnabledByDefault());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public boolean isConfiguredOnProject(ValidatorMetaData vmd, IProject project) {
        Object vmds;
        if (this.projectValidationMetaData == null) {
            this.projectValidationMetaData = new HashMap();
        }
        if ((vmds = this.projectValidationMetaData.get(project)) != null) {
            Set pvmds = (Set)vmds;
            return pvmds.contains(vmd);
        }
        Set prjVmds = this.getValidatorMetaData(project);
        if (prjVmds == null) {
            return false;
        }
        if (prjVmds.size() == 0) {
            return false;
        }
        this.projectValidationMetaData.put(project, prjVmds);
        return prjVmds.contains(vmd);
    }

    private Set getValidatorMetaDataUnknownProject() {
        Set projVmds = (Set)this._validators.get(UNKNOWN_PROJECT);
        if (projVmds == null) {
            projVmds = Collections.EMPTY_SET;
        }
        return projVmds;
    }

    public Set getValidatorMetaDataEnabledByDefault() {
        HashSet copy = new HashSet();
        this.clone(this._defaultEnabledValidators, copy);
        return copy;
    }

    public ValidatorMetaData[] getValidatorMetaDataArrayEnabledByDefault() {
        ValidatorMetaData[] result = new ValidatorMetaData[this._defaultEnabledValidators.size()];
        this._defaultEnabledValidators.toArray(result);
        return result;
    }

    public ValidatorMetaData getValidatorMetaData(String validatorClassName) {
        if (validatorClassName == null) {
            return null;
        }
        ValidatorMetaData vmd = (ValidatorMetaData)this._indexedValidators.get(validatorClassName);
        if (vmd != null) {
            return vmd;
        }
        Iterator iterator = this._indexedValidators.values().iterator();
        while (iterator.hasNext()) {
            Set idList;
            ValidatorMetaData.MigrationMetaData mmd;
            vmd = (ValidatorMetaData)iterator.next();
            if (vmd == null) continue;
            if (vmd.getValidatorUniqueName().equals(validatorClassName)) {
                return vmd;
            }
            String[] aggregateNames = vmd.getAggregatedValidatorNames();
            if (aggregateNames != null) {
                int i = 0;
                while (i < aggregateNames.length) {
                    String aggregateName = aggregateNames[i];
                    if (validatorClassName.equals(aggregateName)) {
                        return vmd;
                    }
                    ++i;
                }
            }
            if ((mmd = vmd.getMigrationMetaData()) == null || (idList = mmd.getIds()) == null) continue;
            Iterator idIterator = idList.iterator();
            while (idIterator.hasNext()) {
                String from;
                String[] ids = (String[])idIterator.next();
                if (ids.length != 2 || (from = ids[0]) == null || !from.equals(validatorClassName)) continue;
                return vmd;
            }
        }
        return null;
    }

    public boolean isExistingValidator(String validatorClassName) {
        return this.getValidatorMetaData(validatorClassName) != null;
    }

    private ValidatorMetaData initializeValidator(IConfigurationElement element, String validatorName, String pluginId) {
        Logger logger;
        IConfigurationElement[] runChildren = element.getChildren("run");
        if (runChildren == null || runChildren.length < 1) {
            Logger logger2 = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger2.isLoggingLevel(Level.FINE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("ValidationRegistryReader.initializeValidator(IConfigurationElement, String, String)");
                entry.setMessageTypeID("VBF_EXC_SYNTAX_NO_VAL_RUN");
                String result = MessageFormat.format(ResourceHandler.getExternalizedMessage("VBF_EXC_SYNTAX_NO_VAL_RUN"), validatorName);
                entry.setText(result);
                logger2.write(Level.FINE, (Object)entry);
            }
            return null;
        }
        String validatorImplName = runChildren[0].getAttribute("class");
        if (validatorImplName == null) {
            Logger logger3 = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger3.isLoggingLevel(Level.FINE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("ValidationRegistryReader.initializeValidator(IConfigurationElement, String, String)");
                entry.setMessageTypeID("VBF_EXC_SYNTAX_NO_VAL_CLASS");
                entry.setTokens(new String[]{validatorName});
                logger3.write(Level.FINE, (Object)entry);
            }
            return null;
        }
        String helperImplName = this.getHelperName(element);
        if (helperImplName == null) {
            Logger logger4 = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger4.isLoggingLevel(Level.FINE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("ValidationRegistryReader.initializeValidator(IConfigurationElement, String, String)");
                entry.setMessageTypeID("VBF_EXC_SYNTAX_NO_VAL_RUN");
                entry.setTokens(new String[]{validatorImplName});
                logger4.write(Level.FINE, (Object)entry);
            }
            return null;
        }
        ValidatorMetaData vmd = new ValidatorMetaData();
        vmd.addFilters(this.getFilters(element));
        vmd.addProjectNatureFilters(this.getProjectNatureFilters(element));
        vmd.addFacetFilters(this.getFacetIds(element));
        vmd.addAggregatedValidatorNames(this.getAggregateValidatorsNames(element));
        vmd.setValidatorDisplayName(validatorName.intern());
        vmd.setValidatorUniqueName(validatorImplName.intern());
        vmd.setPluginId(pluginId);
        vmd.setIncremental(this.getIncremental(element));
        vmd.setFullBuild(this.getFullBuild(element));
        vmd.setAsync(this.getAsync(element));
        vmd.setRuleGroup(this.getRuleGroup(element));
        vmd.setEnabledByDefault(this.getEnabledByDefault(element));
        vmd.setMigrationMetaData(this.getMigrationMetaData(element, vmd));
        vmd.setHelperClass(element, helperImplName);
        vmd.setValidatorClass(element);
        vmd.addDependentValidator(this.getDependentValidatorValue(element));
        String customMarkerId = this.getMarkerIdValue(element);
        if (customMarkerId != null) {
            vmd.setMarkerId(String.valueOf(pluginId) + "." + customMarkerId);
        }
        if ((logger = ValidationPlugin.getPlugin().getMsgLogger()).isLoggingLevel(Level.FINEST)) {
            LogEntry entry = ValidationPlugin.getLogEntry();
            entry.setSourceID("ValidationRegistryReader.initializeValidator(IConfigurationElement, String, String)");
            entry.setText("validator loaded: " + validatorImplName);
            logger.write(Level.FINEST, (Object)entry);
        }
        return vmd;
    }

    private List getTempList() {
        if (this._tempList == null) {
            this._tempList = new ArrayList();
        } else {
            this._tempList.clear();
        }
        return this._tempList;
    }

    public Collection getAllValidators() {
        HashSet validators = new HashSet();
        this.clone(this._indexedValidators.values(), validators);
        return validators;
    }

    public int numberOfValidators() {
        return this._indexedValidators.size();
    }

    private void readExtension(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String label = extension.getLabel();
            if (label == null || label.equals("")) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.FINE)) {
                    Object[] msgParm = new String[]{extension.getUniqueIdentifier()};
                    LogEntry entry = ValidationPlugin.getLogEntry();
                    entry.setSourceID("ValidationRegistryReader.readExtension(IExtension)");
                    entry.setMessageTypeID("VBF_EXC_VALIDATORNAME_IS_NULL");
                    String result = MessageFormat.format(ResourceHandler.getExternalizedMessage("VBF_EXC_VALIDATORNAME_IS_NULL"), msgParm);
                    entry.setText(result);
                    logger.write(Level.FINE, (Object)entry);
                }
            } else {
                String pluginId = extension.getNamespace();
                ValidatorMetaData vmd = this.initializeValidator(element, label, pluginId);
                if (vmd != null) {
                    this.add(vmd);
                }
            }
            ++i;
        }
    }

    private void readRegistry() {
        this._validators.clear();
        IExtensionPoint validatorEP = this.getValidatorExtensionPoint();
        if (validatorEP == null) {
            return;
        }
        IExtension[] extensions = validatorEP.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            this.readExtension(extensions[i]);
            ++i;
        }
    }

    public IValidator getValidator(String validatorClassName) throws InstantiationException {
        ValidatorMetaData vmd = (ValidatorMetaData)this._indexedValidators.get(validatorClassName);
        if (vmd != null) {
            return vmd.getValidator();
        }
        return null;
    }
}

