/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.operations;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.validation.internal.FilterUtil;
import org.eclipse.wst.validation.internal.InternalValidatorManager;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.ValidationOperation;

public class ValidatorSubsetOperation
extends ValidationOperation {
    protected static final String DEFAULT_DEFAULTEXTENSION = null;

    public ValidatorSubsetOperation(IProject project, boolean force, boolean async) {
        this(project, force, 1, async);
    }

    public ValidatorSubsetOperation(IProject project, IWorkbenchContext aWorkenchContext, boolean force, int ruleGroup, boolean async) {
        super(project, aWorkenchContext, null, null, ruleGroup, force, async);
    }

    public ValidatorSubsetOperation(IProject project, boolean force, int ruleGroup, boolean async) {
        super(project, null, null, ruleGroup, force, async);
    }

    public ValidatorSubsetOperation(IProject project, String fileExtension, Object[] changedResources, boolean async) throws IllegalArgumentException {
        this(project, fileExtension, DEFAULT_DEFAULTEXTENSION, changedResources, async);
    }

    public ValidatorSubsetOperation(IProject project, String fileExtension, String defaultExtension, Object[] changedResources, boolean async) throws IllegalArgumentException {
        super(project, ValidatorSubsetOperation.shouldForce(changedResources), async);
        boolean filterIn = false;
        Object[] vmds = InternalValidatorManager.getManager().getValidatorsForExtension(project, fileExtension);
        if (defaultExtension != null && (vmds == null || vmds.length == 0)) {
            filterIn = true;
            vmds = InternalValidatorManager.getManager().getValidatorsForExtension(project, defaultExtension);
        }
        if (vmds == null || vmds.length == 0) {
            throw new IllegalArgumentException();
        }
        this.setEnabledValidators(InternalValidatorManager.wrapInSet(vmds));
        this.setFileDeltas(FilterUtil.getFileDeltas(this.getEnabledValidators(), changedResources, filterIn));
    }

    public ValidatorSubsetOperation(IProject project, ValidatorMetaData[] vmds, IResource[] changedResources, int ifileDeltaType, boolean force, boolean async) throws IllegalArgumentException {
        super(project, force, async);
        if (vmds == null || vmds.length == 0) {
            throw new IllegalArgumentException(ResourceHandler.getExternalizedMessage("VBF_EXC_BADVMD"));
        }
        if (!project.isOpen()) {
            throw new IllegalArgumentException(ResourceHandler.getExternalizedMessage("VBF_EXC_OPENPRJ", new String[]{project.getName()}));
        }
        if (!project.exists()) {
            throw new IllegalArgumentException(ResourceHandler.getExternalizedMessage("VBF_EXC_EXISTPRJ", new String[]{project.getName()}));
        }
        if (changedResources != null && changedResources.length > 0) {
            HashSet<IProject> tempSet = new HashSet<IProject>();
            int i = 0;
            while (i < changedResources.length) {
                IProject p = changedResources[i].getProject();
                if (!p.isOpen()) {
                    throw new IllegalArgumentException(ResourceHandler.getExternalizedMessage("VBF_EXC_OPENPRJ", new String[]{p.getName()}));
                }
                if (!p.exists()) {
                    throw new IllegalArgumentException(ResourceHandler.getExternalizedMessage("VBF_EXC_EXISTPRJ", new String[]{p.getName()}));
                }
                tempSet.add(project);
                ++i;
            }
            if (!tempSet.contains(project)) {
                throw new IllegalArgumentException(ResourceHandler.getExternalizedMessage("VBF_EXC_BADPRJ", new String[]{project.getName()}));
            }
            if (tempSet.size() != 1) {
                StringBuffer buffer = new StringBuffer("\n");
                Iterator iterator = tempSet.iterator();
                while (iterator.hasNext()) {
                    IProject p = (IProject)iterator.next();
                    buffer.append("\t");
                    buffer.append(p.getName());
                    if (!iterator.hasNext()) continue;
                    buffer.append(", ");
                }
                throw new IllegalArgumentException(ResourceHandler.getExternalizedMessage("VBF_EXC_MULTIPRJ", new String[]{buffer.toString()}));
            }
        }
        int i = 0;
        while (i < vmds.length) {
            ValidatorMetaData vmd = vmds[i];
            if (!ValidationRegistryReader.getReader().isConfiguredOnProject(vmd, project)) {
                throw new IllegalArgumentException(ResourceHandler.getExternalizedMessage("VBF_EXC_BADVAL", new String[]{vmd.getValidatorDisplayName(), project.getName()}));
            }
            ++i;
        }
        this.setEnabledValidators(InternalValidatorManager.wrapInSet(vmds));
        this.setFileDeltas(FilterUtil.getFileDeltas(this.getEnabledValidators(), (Object[])changedResources, ifileDeltaType));
    }

    public void setValidators(String[] validatorNames) throws IllegalArgumentException {
        HashSet<ValidatorMetaData> enabled = new HashSet<ValidatorMetaData>();
        int i = 0;
        while (i < validatorNames.length) {
            ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validatorNames[i]);
            if (vmd == null) {
                throw new IllegalArgumentException(validatorNames[i]);
            }
            enabled.add(vmd);
            ++i;
        }
        this.setEnabledValidators(enabled);
    }

    public void setAlwaysRun(boolean force) {
        this.setForce(force);
    }
}

