/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.plugin;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.ws.internal.preferences.PersistentWSDLValidationContext;
import org.eclipse.wst.ws.internal.preferences.PersistentWSIAPContext;
import org.eclipse.wst.ws.internal.preferences.PersistentWSIContext;
import org.eclipse.wst.ws.internal.preferences.PersistentWSISSBPContext;
import org.eclipse.wst.ws.internal.preferences.PersistentWaitForWSDLValidationContext;
import org.osgi.framework.BundleContext;

public class WSPlugin
extends Plugin {
    private static WSPlugin plugin;
    private ResourceBundle resourceBundle;
    private PersistentWSISSBPContext wsiSSBPContext_;
    private PersistentWSIAPContext wsiAPContext_;
    private PersistentWSDLValidationContext wsdlValidationContext_;
    private PersistentWaitForWSDLValidationContext waitForWsdlValidationContext_;
    public static final String ID = "org.eclipse.wst.ws";

    public WSPlugin() {
        plugin = this;
    }

    public static WSPlugin getInstance() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.resourceBundle = null;
    }

    public static WSPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = WSPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getResourceString(String key, Object[] args) {
        return MessageFormat.format(WSPlugin.getResourceString(key), args);
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.wst.ws.WSPluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public PersistentWSIContext getWSIContext() {
        return this.getWSISSBPContext();
    }

    public PersistentWSISSBPContext getWSISSBPContext() {
        if (this.wsiSSBPContext_ == null) {
            this.wsiSSBPContext_ = new PersistentWSISSBPContext();
            this.wsiSSBPContext_.load();
        }
        return this.wsiSSBPContext_;
    }

    public PersistentWSIAPContext getWSIAPContext() {
        if (this.wsiAPContext_ == null) {
            this.wsiAPContext_ = new PersistentWSIAPContext();
            this.wsiAPContext_.load();
        }
        return this.wsiAPContext_;
    }

    public PersistentWSDLValidationContext getWSDLValidationContext() {
        if (this.wsdlValidationContext_ == null) {
            this.wsdlValidationContext_ = new PersistentWSDLValidationContext();
            this.wsdlValidationContext_.load();
        }
        return this.wsdlValidationContext_;
    }

    public PersistentWaitForWSDLValidationContext getWaitForWSDLValidationContext() {
        if (this.waitForWsdlValidationContext_ == null) {
            this.waitForWsdlValidationContext_ = new PersistentWaitForWSDLValidationContext();
            this.waitForWsdlValidationContext_.load();
        }
        return this.waitForWsdlValidationContext_;
    }
}

