/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.actions.BaseNodeAction;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.wsdl.ui.internal.widgets.NewComponentDialog;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AddElementAction
extends BaseNodeAction {
    protected Node parentNode;
    protected String prefix;
    protected String nodeName;
    protected Element newElement;
    protected Node relativeNode = null;
    protected IEditorPart editorPart;
    protected Definition definition;
    protected Document document;
    protected boolean computeTopLevelRefChild;
    protected boolean selectNewlyCreatedObject = true;
    protected static HashMap precedenceMap = AddElementAction.createPrecedenceMap();
    static /* synthetic */ Class class$0;

    public AddElementAction(String text, String imageDescriptorKey, Node parentNode, String nodeName) {
        this.setText(text);
        this.setImageDescriptor(WSDLEditorPlugin.getImageDescriptor(imageDescriptorKey));
        this.parentNode = parentNode;
        this.nodeName = nodeName;
    }

    public AddElementAction(String text, String imageDescriptorKey, Node parentNode, String prefix, String localName) {
        this.setText(text);
        this.setImageDescriptor(WSDLEditorPlugin.getImageDescriptor(imageDescriptorKey));
        this.parentNode = parentNode;
        this.prefix = prefix;
        this.nodeName = localName;
    }

    public AddElementAction(String text, Node parentNode, String prefix, String localName) {
        this.setText(text);
        this.setImageDescriptor(null);
        this.parentNode = parentNode;
        this.prefix = prefix;
        this.nodeName = localName;
    }

    public AddElementAction(Node parentNode, String prefix, String localName, Node relativeNode) {
        this.parentNode = parentNode;
        this.prefix = prefix;
        this.nodeName = localName;
        this.relativeNode = relativeNode;
    }

    public void setComputeTopLevelRefChild(boolean isEnabled) {
        this.computeTopLevelRefChild = isEnabled;
    }

    protected void setEditorPart(IEditorPart editorPart) {
        this.editorPart = editorPart;
    }

    protected boolean showDialog() {
        return true;
    }

    public void run() {
        boolean ok = this.showDialog();
        if (ok) {
            this.beginRecording();
            this.performAddElement();
            this.endRecording();
        }
    }

    protected void performAddElement() {
        if (this.parentNode != null) {
            this.newElement = this.createElement(this.nodeName);
            this.addAttributes(this.newElement);
            if (this.relativeNode == null && this.computeTopLevelRefChild) {
                this.relativeNode = this.computeTopLevelRefChild(this.newElement);
            }
            if (this.relativeNode == null) {
                this.parentNode.appendChild(this.newElement);
            } else {
                this.parentNode.insertBefore(this.newElement, this.relativeNode);
            }
            this.format(this.newElement);
            if (this.selectNewlyCreatedObject) {
                this.selectObjectForNewElement();
            }
        }
    }

    public void selectObjectForNewElement(boolean select) {
        this.selectNewlyCreatedObject = select;
    }

    public Node getNode() {
        if (this.parentNode != null) {
            return this.parentNode;
        }
        return this.document;
    }

    public String getUndoDescription() {
        return WSDLEditorPlugin.getWSDLString("_UI_ACTION_ADD");
    }

    protected Element createElement(String nodeName) {
        Document document = this.parentNode.getOwnerDocument();
        Element element = this.prefix != null && this.prefix.length() > 0 ? document.createElement(String.valueOf(this.prefix) + ":" + nodeName) : document.createElement(nodeName);
        return element;
    }

    protected void addAttributes(Element newElement) {
    }

    protected void format(Node parentNode) {
        if (parentNode instanceof IDOMNode) {
            FormatProcessorXML formatProcessorXML = new FormatProcessorXML();
            formatProcessorXML.formatNode((Node)((IDOMNode)parentNode));
        }
    }

    protected Element getDefinitionElement(Element parentElement) {
        Element definitionElement = null;
        Node node = parentElement.getOwnerDocument().getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if (WSDLEditorUtil.getInstance().getWSDLType(element) == 1) {
                    definitionElement = element;
                    break;
                }
            }
            node = node.getNextSibling();
        }
        return definitionElement;
    }

    public Element getNewElement() {
        return this.newElement;
    }

    public void setDefinition(Definition definition) {
        this.definition = definition;
    }

    public void selectObjectForNewElement() {
        Object object;
        if (this.editorPart == null) {
            this.editorPart = WSDLEditorPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        }
        if (this.editorPart != null && this.definition != null && (object = WSDLEditorUtil.getInstance().findModelObjectForElement(this.definition, this.newElement)) != null) {
            ISelectionProvider selectionProvider;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.viewers.ISelectionProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((selectionProvider = (ISelectionProvider)this.editorPart.getAdapter((Class)clazz)) != null) {
                selectionProvider.setSelection((ISelection)new StructuredSelection(object));
            }
        }
    }

    public void selectObject(WSDLElement object) {
        if (this.editorPart == null) {
            this.editorPart = WSDLEditorPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        }
        if (this.editorPart != null && this.definition != null && object != null) {
            ISelectionProvider selectionProvider;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.viewers.ISelectionProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((selectionProvider = (ISelectionProvider)this.editorPart.getAdapter((Class)clazz)) != null) {
                selectionProvider.setSelection((ISelection)new StructuredSelection((Object)object));
            }
        }
    }

    public String showDialogHelper(String title, String defaultName, List usedNames) {
        String result = defaultName;
        NewComponentDialog dialog = new NewComponentDialog(WSDLEditorPlugin.getShell(), title, defaultName, usedNames);
        int rc = dialog.createAndOpen();
        result = rc == 0 ? dialog.getName() : null;
        return result;
    }

    protected Node computeTopLevelRefChild(Node nodeToAdd) {
        Node result = null;
        int a = AddElementAction.getPrecedence(nodeToAdd);
        Node node = this.parentNode.getFirstChild();
        while (node != null) {
            int b;
            if (node.getNodeType() == 1 && (b = AddElementAction.getPrecedence(node)) > a) {
                result = node;
                break;
            }
            node = node.getNextSibling();
        }
        return result;
    }

    protected void createDefinitionStub() {
        if (this.document != null) {
            Preferences preference = XMLCorePlugin.getDefault().getPluginPreferences();
            String charSet = preference.getString("outputCodeset");
            if (charSet == null || charSet.trim().equals("")) {
                charSet = "UTF-8";
            }
            this.document.appendChild(this.document.createProcessingInstruction("xml", "version=\"1.0\" encoding=\"" + charSet + "\""));
            Element root = this.document.createElement("wsdl:definitions");
            this.document.appendChild(root);
            root.setAttribute("xmlns:soap", "http://schemas.xmlsoap.org/wsdl/soap/");
            root.setAttribute("xmlns:tns", this.getDefaultNamespace());
            root.setAttribute("xmlns:wsdl", "http://schemas.xmlsoap.org/wsdl/");
            root.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            root.setAttribute("name", this.getFileName());
            root.setAttribute("targetNamespace", this.getDefaultNamespace());
            this.definition.setElement(root);
            this.parentNode = root;
            this.prefix = this.definition.getPrefix("http://schemas.xmlsoap.org/wsdl/");
        }
    }

    private String getDefaultNamespace() {
        String namespace = WSDLEditorPlugin.getInstance().getPreferenceStore().getString(WSDLEditorPlugin.getWSDLString("_UI_PREF_PAGE_DEFAULT_TARGET_NAMESPACE"));
        if (!namespace.endsWith("/")) {
            namespace = namespace.concat("/");
        }
        namespace = String.valueOf(namespace) + this.getFileName() + "/";
        return namespace;
    }

    private String getFileName() {
        String fileLocation = this.definition.getLocation();
        Path filePath = new Path(fileLocation);
        return filePath.removeFileExtension().lastSegment().toString();
    }

    protected static int getPrecedence(Node node) {
        Integer integer;
        int result = 2;
        String localName = node.getLocalName();
        if (localName != null && (integer = (Integer)precedenceMap.get(localName)) != null) {
            result = integer;
        }
        return result;
    }

    protected static HashMap createPrecedenceMap() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("documentation", new Integer(1));
        hashMap.put("import", new Integer(3));
        hashMap.put("types", new Integer(4));
        hashMap.put("message", new Integer(5));
        hashMap.put("portType", new Integer(6));
        hashMap.put("binding", new Integer(7));
        hashMap.put("service", new Integer(8));
        return hashMap;
    }
}

