/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.actions.AddElementAction;
import org.eclipse.wst.wsdl.ui.internal.commands.AddMessageCommand;
import org.eclipse.wst.wsdl.ui.internal.util.CreateWSDLElementHelper;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class AddMessageAction
extends AddElementAction {
    protected Definition definition;
    protected String name;

    public AddMessageAction(Definition definition, String name, Node parentNode, String prefix) {
        super(WSDLEditorPlugin.getWSDLString("_UI_ACTION_ADD_MESSAGE"), "icons/message_obj.gif", parentNode, prefix, "message");
        this.definition = definition;
        this.name = name;
        this.setComputeTopLevelRefChild(true);
    }

    public AddMessageAction(Definition definition, String name, Node parentNode, String prefix, Document document) {
        super(WSDLEditorPlugin.getWSDLString("_UI_ACTION_ADD_MESSAGE"), "icons/message_obj.gif", parentNode, prefix, "message");
        this.definition = definition;
        this.name = name;
        this.setDefinition(definition);
        this.document = document;
        this.setComputeTopLevelRefChild(true);
    }

    public boolean showDialog() {
        this.name = NameUtil.buildUniqueMessageName(this.definition, this.name);
        this.name = this.showDialogHelper(WSDLEditorPlugin.getWSDLString("_UI_ACTION_NEW_MESSAGE"), this.name, NameUtil.getUsedMessageNames(this.definition));
        return this.name != null;
    }

    protected void performAddElement() {
        NodeList list = this.document.getChildNodes();
        if (this.parentNode == null || list.getLength() == 0) {
            this.createDefinitionStub();
        }
        AddMessageCommand action = new AddMessageCommand(this.definition, this.name);
        action.run();
        Message message = (Message)action.getWSDLElement();
        CreateWSDLElementHelper.createPart(message);
        this.format(message.getElement());
        this.selectObject((WSDLElement)message);
    }

    public String getName() {
        return this.name;
    }
}

