/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditor;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.actions.AddElementAction;
import org.eclipse.wst.wsdl.ui.internal.commands.AddInputCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddOperationCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddOutputCommand;
import org.eclipse.wst.wsdl.ui.internal.graph.WSDLComponentViewer;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.WSDLTreeNodeEditPart;
import org.eclipse.wst.wsdl.ui.internal.util.CreateWSDLElementHelper;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.wsdl.ui.internal.widgets.NewComponentWithChildDialog;
import org.w3c.dom.Node;

class AddOperationAction
extends AddElementAction {
    protected String name = "NewOperation";
    protected PortType portType;
    protected boolean createSubComponents = false;

    public AddOperationAction(IEditorPart editorPart, PortType portType, Node parentNode, String prefix) {
        super(WSDLEditorPlugin.getWSDLString("_UI_ACTION_ADD_OPERATION"), "icons/operation_obj.gif", parentNode, prefix, "operation");
        this.setEditorPart(editorPart);
        this.setDefinition(portType.getEnclosingDefinition());
        this.portType = portType;
    }

    public boolean showDialog() {
        this.name = NameUtil.buildUniqueOperationName(this.portType);
        this.name = this.showDialogHelper(WSDLEditorPlugin.getWSDLString("_UI_ACTION_NEW_OPERATION"), this.name, NameUtil.getUsedOperationNames(this.portType));
        return this.name != null;
    }

    protected void performAddElement() {
        if (this.createSubComponents) {
            CreateWSDLElementHelper.operationName = this.name;
            CreateWSDLElementHelper.PART_TYPE_OR_DEFINITION = CreateWSDLElementHelper.getPartInfo((WSDLElement)this.portType);
            Operation operation = CreateWSDLElementHelper.createOperation(this.portType);
            this.format(operation.getElement());
            this.selectObject((WSDLElement)operation);
            this.expandEditParts(operation, true);
        } else {
            AddOperationCommand opAction = new AddOperationCommand(this.portType, this.name);
            opAction.run();
            Operation operation = (Operation)opAction.getWSDLElement();
            AddOutputCommand outAction = new AddOutputCommand(operation, NameUtil.buildUniqueInputName(this.portType, operation.getName(), ""));
            outAction.run();
            AddInputCommand inAction = new AddInputCommand(operation, NameUtil.buildUniqueOutputName(this.portType, operation.getName(), ""));
            inAction.run();
            this.format(operation.getElement());
            this.selectObject((WSDLElement)operation);
            this.expandEditParts(operation, true);
        }
    }

    private void expandEditParts(Object element, boolean expandChildren) {
        if (element != null) {
            WSDLComponentViewer editPartViewer = ((WSDLEditor)this.editorPart).getGraphViewer().getComponentViewer();
            Map editPartMap = editPartViewer.getEditPartRegistry();
            WSDLTreeNodeEditPart wsdlEditPart = (WSDLTreeNodeEditPart)editPartMap.get(element);
            wsdlEditPart.setExpanded(true);
            if (expandChildren) {
                Iterator iterator = WSDLEditorUtil.getModelGraphViewChildren(element).iterator();
                while (iterator.hasNext()) {
                    this.expandEditParts(iterator.next(), expandChildren);
                }
            }
        }
    }

    public String showDialogHelper(String title, String defaultName, List usedNames) {
        String result = defaultName;
        NewComponentWithChildDialog dialog = new NewComponentWithChildDialog(WSDLEditorPlugin.getShell(), title, defaultName, usedNames);
        int rc = dialog.createAndOpen();
        if (rc == 0) {
            result = dialog.getName();
            this.createSubComponents = dialog.createSubComponents();
        } else {
            result = null;
        }
        return result;
    }
}

