/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.actions.AddElementAction;
import org.eclipse.wst.wsdl.ui.internal.actions.AddNamespaceDeclarationsAction;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class AddPartAction
extends AddElementAction {
    protected Message message;
    protected String name;

    public AddPartAction(IEditorPart editorPart, Message message, Node parentNode, String prefix) {
        super(WSDLEditorPlugin.getWSDLString("_UI_ACTION_ADD_PART"), "icons/part_obj.gif", parentNode, prefix, "part");
        this.message = message;
        this.setEditorPart(editorPart);
        this.setDefinition(message.getEnclosingDefinition());
    }

    public boolean showDialog() {
        this.name = NameUtil.buildUniquePartName(this.message, this.message.getQName().getLocalPart());
        this.name = this.showDialogHelper(WSDLEditorPlugin.getWSDLString("_UI_ACTION_NEW_PART"), this.name, NameUtil.getUsedPartNames(this.message));
        return this.name != null;
    }

    protected void addAttributes(Element newElement) {
        newElement.setAttribute("name", this.name);
        String xsdPrefix = this.message.getEnclosingDefinition().getPrefix("http://www.w3.org/2001/XMLSchema");
        if (xsdPrefix == null) {
            Element definitionElement = WSDLEditorUtil.getInstance().getElementForObject(this.message.getEnclosingDefinition());
            new AddNamespaceDeclarationsAction(definitionElement, "http://www.w3.org/2001/XMLSchema", "xsd").run();
            xsdPrefix = this.message.getEnclosingDefinition().getPrefix("http://www.w3.org/2001/XMLSchema");
        }
        String defaultTypeName = "string";
        if (xsdPrefix != null && xsdPrefix.length() > 0) {
            defaultTypeName = String.valueOf(xsdPrefix) + ":" + defaultTypeName;
        }
        newElement.setAttribute("type", defaultTypeName);
    }
}

