/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.internal.impl.WSDLElementImpl;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditor;
import org.eclipse.wst.wsdl.ui.internal.actions.WSDLDragAction;
import org.eclipse.wst.wsdl.ui.internal.graph.WSDLComponentViewer;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.GroupEditPart;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.WSDLTreeNodeEditPart;
import org.eclipse.wst.xsd.ui.internal.gef.util.figures.IConnectedFigure;

public class WSDLDragSetMessageAction
extends WSDLDragAction {
    protected EditPart pointerEditPart;
    protected WSDLElement movingChild;
    protected WSDLElement pointerModelElement;

    public WSDLDragSetMessageAction(WSDLTreeNodeEditPart movingChildEditPart, EditPart pointerEditPart, Point pointerLocation) {
        this.movingChildEditPart = movingChildEditPart;
        this.pointerEditPart = pointerEditPart;
        this.pointerLocation = pointerLocation;
        this.movingChild = (WSDLElement)movingChildEditPart.getModel();
        this.pointerModelElement = (WSDLElement)pointerEditPart.getModel();
        if (this.pointerModelElement instanceof Part) {
            this.pointerEditPart = pointerEditPart.getParent();
            this.pointerModelElement = (WSDLElement)this.pointerEditPart.getModel();
        }
    }

    public boolean canExecute() {
        boolean result = false;
        if (this.pointerModelElement == null || this.movingChild == null) {
            return false;
        }
        if ((this.movingChild instanceof Input || this.movingChild instanceof Output || this.movingChild instanceof Fault) && this.pointerModelElement instanceof Message) {
            result = true;
        }
        return result;
    }

    public void run() {
        if (this.canExecute()) {
            MessageReference messageReference = (MessageReference)this.movingChild;
            messageReference.setEMessage((Message)this.pointerModelElement);
            ((WSDLElementImpl)messageReference).updateElement(true);
            WSDLEditor wsdlEditor = ((WSDLComponentViewer)this.pointerEditPart.getViewer()).getWSDLEditor();
            wsdlEditor.getSelectionManager().setSelection((ISelection)new StructuredSelection((Object)this.movingChild));
        }
    }

    public IFigure getFeedbackFigure() {
        Polyline polyfigure = new Polyline();
        GroupEditPart leftGroupEditPart = this.getGroupEditPart((EditPart)this.movingChildEditPart);
        GroupEditPart rightGroupEditPart = this.getGroupEditPart(this.pointerEditPart);
        int mx = rightGroupEditPart.getFigure().getBounds().x - 5;
        this.drawLine(polyfigure, leftGroupEditPart.outputConnection.getFigure(), ((AbstractGraphicalEditPart)this.pointerEditPart).getFigure(), mx);
        return polyfigure;
    }

    protected void drawLine(Polyline feedbackFigure, IFigure a, IFigure b, int mx) {
        Rectangle r1 = this.getConnectionBounds(a);
        Rectangle r2 = this.getConnectionBounds(b);
        int x1 = r1.x + r1.width;
        int y1 = r1.y + r1.height / 2;
        int x2 = r2.x - 1;
        int y2 = r2.y + 8;
        this.addLineToPolyline(feedbackFigure, x1, y1, mx, y1);
        this.addLineToPolyline(feedbackFigure, mx, y2, x2 - 1, y2);
        this.addLineToPolyline(feedbackFigure, x2 - 1, y2, x2 - 4, y2 - 3);
        this.addLineToPolyline(feedbackFigure, x2 - 1, y2, x2 - 4, y2 + 3);
    }

    protected Rectangle getConnectionBounds(IFigure figure) {
        Rectangle r = null;
        if (figure instanceof IConnectedFigure) {
            IConnectedFigure connectedFigure = (IConnectedFigure)figure;
            r = connectedFigure.getConnectionFigure().getBounds();
        } else {
            r = figure.getBounds();
        }
        return r;
    }

    protected Polyline addLineToPolyline(Polyline polyline, int x1, int y1, int x2, int y2) {
        polyline.addPoint(new Point(x1, y1));
        polyline.addPoint(new Point(x2, y2));
        polyline.setLineWidth(1);
        return polyline;
    }

    private GroupEditPart getGroupEditPart(EditPart editPart) {
        Object parentPart = editPart.getParent();
        if (parentPart == null) {
            return null;
        }
        if (!(parentPart instanceof GroupEditPart)) {
            parentPart = this.getGroupEditPart((EditPart)parentPart);
        }
        return (GroupEditPart)parentPart;
    }
}

