/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.dialogs;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;

public class GenerateBindingOnSaveDialog
extends MessageDialog
implements SelectionListener {
    private static String dialogTitle = "Regenerate Bindings On Save";
    private static String dialogMessage = "Regenerate Bindings On Save?";
    private static String[] buttons = new String[]{"Yes", "No", "Cancel"};
    private Button rememberDecisionBox;
    private boolean rememberDecision = false;

    public GenerateBindingOnSaveDialog(Shell shell) {
        super(shell, dialogTitle, null, dialogMessage, 3, buttons, 0);
    }

    protected Control createCustomArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        comp.setLayout((Layout)layout);
        comp.setData((Object)new GridData());
        new Label(comp, 0);
        new Label(comp, 0);
        this.rememberDecisionBox = new Button(comp, 32);
        this.rememberDecisionBox.setText("Remember my decision");
        this.rememberDecisionBox.addSelectionListener((SelectionListener)this);
        return parent;
    }

    private void storePromptPreference(int swtValue) {
        if (this.rememberDecision) {
            WSDLEditorPlugin.getInstance().getPluginPreferences().setValue("Prompt Regenerate Binding on save", false);
            String generateID = WSDLEditorPlugin.getWSDLString("_UI_PREF_PAGE_AUTO_REGENERATE_BINDING");
            if (swtValue == 64) {
                WSDLEditorPlugin.getInstance().getPluginPreferences().setValue(generateID, true);
            } else if (swtValue == 128) {
                WSDLEditorPlugin.getInstance().getPluginPreferences().setValue(generateID, false);
            }
        }
    }

    public int open() {
        int rValue = super.open();
        if (rValue == 0) {
            this.storePromptPreference(64);
            return 64;
        }
        if (rValue == 1) {
            this.storePromptPreference(128);
            return 128;
        }
        if (rValue == 2) {
            this.storePromptPreference(256);
            return 256;
        }
        return rValue;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.rememberDecisionBox) {
            this.rememberDecision = this.rememberDecisionBox.getSelection();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

