/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.dialogs;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.dialogs.types.WSDLComponentSelectionDialog;
import org.eclipse.wst.wsdl.ui.internal.dialogs.types.WSDLComponentSelectionProvider;
import org.eclipse.wst.wsdl.ui.internal.dialogs.types.WSDLSetComponentHelper;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.common.IComponentSelectionProvider;

public class InvokeSetDialog {
    String kind;
    String newValue = "";

    public void setReferenceKind(String kind) {
        this.kind = kind;
    }

    public String getValue() {
        return this.newValue;
    }

    public void run(Object input, IEditorPart editorPart) {
        String dialogTitle;
        WSDLComponentSelectionDialog dialog = null;
        Shell shell = Display.getCurrent().getActiveShell();
        IFile iFile = ((IFileEditorInput)editorPart.getEditorInput()).getFile();
        Definition definition = ((WSDLElement)input).getEnclosingDefinition();
        String property = "";
        if (input instanceof Binding) {
            dialogTitle = WSDLEditorPlugin.getWSDLString("_UI_TITLE_SPECIFY_PORTTYPE");
            WSDLComponentSelectionProvider provider = new WSDLComponentSelectionProvider(iFile, definition, 11);
            dialog = new WSDLComponentSelectionDialog(shell, dialogTitle, (IComponentSelectionProvider)provider);
            provider.setDialog(dialog);
            property = "type";
        } else if (input instanceof Port) {
            dialogTitle = WSDLEditorPlugin.getWSDLString("_UI_TITLE_SPECIFY_BINDING");
            WSDLComponentSelectionProvider provider = new WSDLComponentSelectionProvider(iFile, definition, 0);
            dialog = new WSDLComponentSelectionDialog(shell, dialogTitle, (IComponentSelectionProvider)provider);
            provider.setDialog(dialog);
            property = "binding";
        } else if (input instanceof Part) {
            ArrayList<String> validExtensions = new ArrayList<String>(2);
            validExtensions.add("wsdl");
            validExtensions.add("xsd");
            WSDLComponentSelectionProvider provider = null;
            if (this.kind.equalsIgnoreCase("type")) {
                property = "";
                String dialogTitle2 = WSDLEditorPlugin.getWSDLString("_UI_TITLE_SPECIFY_TYPE");
                provider = new WSDLComponentSelectionProvider(iFile, definition, 15, validExtensions);
                dialog = new WSDLComponentSelectionDialog(shell, dialogTitle2, (IComponentSelectionProvider)provider);
            } else {
                property = "";
                String dialogTitle3 = WSDLEditorPlugin.getWSDLString("_UI_TITLE_SPECIFY_ELEMENT");
                provider = new WSDLComponentSelectionProvider(iFile, definition, 14, validExtensions);
                dialog = new WSDLComponentSelectionDialog(shell, dialogTitle3, (IComponentSelectionProvider)provider);
            }
            provider.setDialog(dialog);
        } else if (input instanceof Input || input instanceof Output || input instanceof Fault) {
            dialogTitle = WSDLEditorPlugin.getWSDLString("_UI_TITLE_SPECIFY_MESSAGE");
            WSDLComponentSelectionProvider provider = new WSDLComponentSelectionProvider(iFile, definition, 6);
            dialog = new WSDLComponentSelectionDialog(shell, dialogTitle, (IComponentSelectionProvider)provider);
            provider.setDialog(dialog);
            property = "message";
        }
        dialog.setBlockOnOpen(true);
        dialog.create();
        if (dialog.open() == 0) {
            WSDLSetComponentHelper helper = new WSDLSetComponentHelper(iFile, definition);
            if (this.kind != null && this.kind.equalsIgnoreCase("type")) {
                helper.setXSDTypeComponent((Part)input, dialog.getSelection());
            } else if (this.kind != null && this.kind.equalsIgnoreCase("element")) {
                helper.setXSDElementComponent((Part)input, dialog.getSelection());
            } else {
                helper.setWSDLComponent((WSDLElement)input, property, dialog.getSelection());
            }
        }
    }
}

