/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.dialogs.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.core.search.pattern.QualifiedName;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.internal.impl.ImportImpl;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.dialogs.types.WSDLComponentFinder;
import org.eclipse.wst.wsdl.ui.internal.dialogs.types.WSDLComponentSelectionDialog;
import org.eclipse.wst.wsdl.ui.internal.search.IWSDLSearchConstants;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.common.IComponentList;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xml.XMLComponentSelectionDialog;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xml.XMLComponentSelectionProvider;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xml.XMLComponentSpecification;
import org.eclipse.wst.xsd.ui.internal.search.IXSDSearchConstants;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDImportImpl;

public class WSDLComponentSelectionProvider
extends XMLComponentSelectionProvider {
    public static final String BUILT_IN_TYPE = "BUILT_IN_TYPE";
    private WSDLComponentFinder wsdlComponentFinder;
    private WSDLComponentSelectionDialog dialog;
    private WSDLComponentLabelProvider labelProvider;
    private Definition definition;
    private QualifiedName metaName;
    private int kind;

    public WSDLComponentSelectionProvider(IFile file, Definition definition, int kind) {
        this.kind = kind;
        ArrayList<String> validExt = new ArrayList<String>(1);
        validExt.add("wsdl");
        this.metaName = this.getQualifiedName(kind);
        this.wsdlComponentFinder = new WSDLComponentFinder(this.metaName);
        this.wsdlComponentFinder.setFile(file);
        this.definition = definition;
        this.labelProvider = new WSDLComponentLabelProvider();
    }

    protected QualifiedName getQualifiedName(int kind) {
        switch (kind) {
            case 0: {
                return IWSDLSearchConstants.BINDING_META_NAME;
            }
            case 11: {
                return IWSDLSearchConstants.PORT_TYPE_META_NAME;
            }
            case 6: {
                return IWSDLSearchConstants.MESSAGE_META_NAME;
            }
            case 15: {
                return IXSDSearchConstants.COMPLEX_TYPE_META_NAME;
            }
            case 14: {
                return IXSDSearchConstants.ELEMENT_META_NAME;
            }
        }
        return null;
    }

    public WSDLComponentSelectionProvider(IFile file, Definition definition, int kind, List validExt) {
        this(file, definition, kind);
    }

    public void setDialog(WSDLComponentSelectionDialog dialog) {
        this.dialog = dialog;
    }

    public String getType(Object element) {
        return null;
    }

    private void createWSDLComponentObjects(IComponentList list, List inputComponents, QualifiedName metaName) {
        Iterator it = inputComponents.iterator();
        while (it.hasNext()) {
            WSDLElement wsdlElement = (WSDLElement)it.next();
            XMLComponentSpecification spec = new XMLComponentSpecification(metaName);
            spec.addAttributeInfo((Object)"name", (Object)wsdlElement.getElement().getAttribute("name"));
            spec.setTargetNamespace(wsdlElement.getEnclosingDefinition().getTargetNamespace());
            String normalizedFile = this.getNormalizedLocation(wsdlElement.getEnclosingDefinition().getLocation());
            spec.setFileLocation(normalizedFile);
            this.addDataItemToTreeNode(list, spec);
        }
    }

    private void createXSDComponentObjects(IComponentList list, List inputComponents, QualifiedName metaName) {
        Iterator it = inputComponents.iterator();
        while (it.hasNext()) {
            XSDNamedComponent xsdElement = (XSDNamedComponent)it.next();
            XMLComponentSpecification spec = new XMLComponentSpecification(metaName);
            spec.addAttributeInfo((Object)"name", (Object)xsdElement.getName());
            spec.setTargetNamespace(xsdElement.getTargetNamespace());
            String normalizedFile = this.getNormalizedLocation(xsdElement.getSchema().getSchemaLocation());
            spec.setFileLocation(normalizedFile);
            this.addDataItemToTreeNode(list, spec);
        }
    }

    public void getComponents(IComponentList list, boolean quick) {
        if (quick) {
            this.getComponentsQuick(list, this.metaName);
        } else {
            String scope = "";
            if (this.dialog != null) {
                scope = this.dialog.getSearchScope();
            }
            List comps = new ArrayList();
            if (scope.equals(XMLComponentSelectionDialog.SCOPE_ENCLOSING_PROJECT)) {
                comps = this.wsdlComponentFinder.getWorkbenchResourceComponents(0);
            } else if (scope.equals(XMLComponentSelectionDialog.SCOPE_WORKSPACE)) {
                comps = this.wsdlComponentFinder.getWorkbenchResourceComponents(1);
            }
            Iterator compsIt = comps.iterator();
            while (compsIt.hasNext()) {
                XMLComponentSpecification item = (XMLComponentSpecification)compsIt.next();
                this.addDataItemToTreeNode(list, item);
            }
        }
    }

    private void getComponentsQuick(IComponentList list, QualifiedName metaName) {
        if (metaName == IWSDLSearchConstants.BINDING_META_NAME) {
            this.createWSDLComponentObjects(list, (List)this.definition.getEBindings(), metaName);
            Iterator importsIt = this.getWSDLFileImports((List)this.definition.getEImports()).iterator();
            while (importsIt.hasNext()) {
                Import importItem = (Import)importsIt.next();
                Definition importDefinition = importItem.getEDefinition();
                EList importedComponents = importDefinition.getEBindings();
                this.createWSDLComponentObjects(list, (List)importedComponents, metaName);
            }
        } else if (metaName == IWSDLSearchConstants.PORT_TYPE_META_NAME) {
            this.createWSDLComponentObjects(list, (List)this.definition.getEPortTypes(), metaName);
            Iterator importsIt = this.getWSDLFileImports((List)this.definition.getEImports()).iterator();
            while (importsIt.hasNext()) {
                Import importItem = (Import)importsIt.next();
                Definition importDefinition = importItem.getEDefinition();
                EList importedComponents = importDefinition.getEPortTypes();
                this.createWSDLComponentObjects(list, (List)importedComponents, metaName);
            }
        } else if (metaName == IWSDLSearchConstants.MESSAGE_META_NAME) {
            this.createWSDLComponentObjects(list, (List)this.definition.getEMessages(), metaName);
            Iterator importsIt = this.getWSDLFileImports((List)this.definition.getEImports()).iterator();
            while (importsIt.hasNext()) {
                Import importItem = (Import)importsIt.next();
                Definition importDefinition = importItem.getEDefinition();
                EList importedComponents = importDefinition.getEMessages();
                this.createWSDLComponentObjects(list, (List)importedComponents, metaName);
            }
        } else if (metaName == IXSDSearchConstants.ELEMENT_META_NAME) {
            this.createXSDElementObjects(list, metaName);
            this.createRegularImportXSDElementObjects(list);
        } else if (metaName == IXSDSearchConstants.COMPLEX_TYPE_META_NAME) {
            this.createXSDInlineWrapperTypeObjects(list, metaName);
            this.createXSDBuiltInTypeObjects(list);
            this.createRegularImportXSDTypeObjects(list);
        } else if (metaName == IXSDSearchConstants.SIMPLE_TYPE_META_NAME) {
            this.createXSDInlineWrapperTypeObjects(list, metaName);
        }
    }

    private List getWSDLFileImports(List wsdlImports) {
        ArrayList<ImportImpl> list = new ArrayList<ImportImpl>();
        Iterator it = wsdlImports.iterator();
        while (it.hasNext()) {
            ImportImpl importItem = (ImportImpl)it.next();
            importItem.importDefinitionOrSchema();
            if (importItem.getESchema() != null) continue;
            list.add(importItem);
        }
        return list;
    }

    private void createXSDBuiltInTypeObjects(IComponentList list) {
        int i = 0;
        while (i < XSDDOMHelper.dataType.length) {
            String builtIn = XSDDOMHelper.dataType[i][0];
            XMLComponentSpecification spec = new XMLComponentSpecification(null);
            spec.addAttributeInfo((Object)"name", (Object)builtIn);
            spec.setTargetNamespace("http://www.w3.org/2001/XMLSchema");
            spec.setFileLocation("Built-in");
            this.addDataItemToTreeNode(list, spec);
            ++i;
        }
    }

    private void createRegularImportXSDTypeObjects(IComponentList list) {
        Iterator imports = this.definition.getEImports().iterator();
        while (imports.hasNext()) {
            Definition definition;
            Import importItem = (Import)imports.next();
            ((ImportImpl)importItem).importDefinitionOrSchema();
            ArrayList<XSDSchema> schemas = new ArrayList<XSDSchema>();
            if (importItem.getESchema() != null) {
                schemas.add(importItem.getESchema());
            } else if (importItem.getEDefinition() != null && (definition = importItem.getEDefinition()).getETypes() != null) {
                Iterator schemaIt = definition.getETypes().getEExtensibilityElements().iterator();
                while (schemaIt.hasNext()) {
                    XSDSchemaExtensibilityElement eeElement = (XSDSchemaExtensibilityElement)schemaIt.next();
                    schemas.add(eeElement.getSchema());
                }
            }
            if (schemas.size() <= 0) continue;
            Iterator schemaIt = schemas.iterator();
            while (schemaIt.hasNext()) {
                Iterator typesIt = ((XSDSchema)schemaIt.next()).getTypeDefinitions().iterator();
                ArrayList complexList = new ArrayList();
                ArrayList simpleList = new ArrayList();
                while (typesIt.hasNext()) {
                    Object component = typesIt.next();
                    if (component instanceof XSDComplexTypeDefinition) {
                        complexList.add(component);
                        continue;
                    }
                    if (!(component instanceof XSDSimpleTypeDefinition)) continue;
                    simpleList.add(component);
                }
                this.createXSDComponentObjects(list, complexList, IXSDSearchConstants.COMPLEX_TYPE_META_NAME);
                this.createXSDComponentObjects(list, simpleList, IXSDSearchConstants.SIMPLE_TYPE_META_NAME);
            }
        }
    }

    private void createRegularImportXSDElementObjects(IComponentList list) {
        Iterator imports = this.definition.getEImports().iterator();
        while (imports.hasNext()) {
            Definition definition;
            Import importItem = (Import)imports.next();
            ((ImportImpl)importItem).importDefinitionOrSchema();
            ArrayList<XSDSchema> schemas = new ArrayList<XSDSchema>();
            if (importItem.getESchema() != null) {
                schemas.add(importItem.getESchema());
            } else if (importItem.getEDefinition() != null && (definition = importItem.getEDefinition()).getETypes() != null) {
                Iterator schemaIt = definition.getETypes().getEExtensibilityElements().iterator();
                while (schemaIt.hasNext()) {
                    XSDSchemaExtensibilityElement eeElement = (XSDSchemaExtensibilityElement)schemaIt.next();
                    schemas.add(eeElement.getSchema());
                }
            }
            if (schemas.size() <= 0) continue;
            Iterator schemaIt = schemas.iterator();
            while (schemaIt.hasNext()) {
                EList elementList = ((XSDSchema)schemaIt.next()).getElementDeclarations();
                this.createXSDComponentObjects(list, (List)elementList, IXSDSearchConstants.ELEMENT_META_NAME);
            }
        }
    }

    private void createXSDInlineTypesObjects(IComponentList list, QualifiedName tagPath) {
        if (this.definition.getETypes() == null) {
            return;
        }
        Iterator inlineSchemasIt = this.definition.getETypes().getSchemas().iterator();
        while (inlineSchemasIt.hasNext()) {
            Object type;
            XSDSchema schema = (XSDSchema)inlineSchemasIt.next();
            if (schema.getTargetNamespace() == null || schema.getTargetNamespace().equals("")) continue;
            ArrayList keepTypes = new ArrayList();
            Iterator typeIterator = schema.getTypeDefinitions().iterator();
            if (tagPath.equals((Object)"/definitions/types/schema/complexType")) {
                while (typeIterator.hasNext()) {
                    type = typeIterator.next();
                    if (!(type instanceof XSDComplexTypeDefinition) || !((XSDComplexTypeDefinition)type).getSchema().equals(schema)) continue;
                    keepTypes.add(type);
                }
            } else if (tagPath.equals((Object)"/definitions/types/schema/simpleType")) {
                while (typeIterator.hasNext()) {
                    type = typeIterator.next();
                    if (!(type instanceof XSDSimpleTypeDefinition) || !((XSDSimpleTypeDefinition)type).getSchema().equals(schema)) continue;
                    keepTypes.add(type);
                }
            }
            this.createXSDComponentObjects(list, keepTypes, tagPath);
        }
    }

    private void createXSDElementObjects(IComponentList list, QualifiedName tagPath) {
        if (this.definition.getETypes() == null) {
            return;
        }
        Iterator inlineSchemasIt = this.definition.getETypes().getSchemas().iterator();
        while (inlineSchemasIt.hasNext()) {
            XSDSchema schema = (XSDSchema)inlineSchemasIt.next();
            ArrayList<XSDElementDeclaration> keepElements = new ArrayList<XSDElementDeclaration>();
            if (schema.getTargetNamespace() == null || schema.getTargetNamespace().equals("")) continue;
            Iterator elementIt = schema.getElementDeclarations().iterator();
            while (elementIt.hasNext()) {
                XSDElementDeclaration xsdElement = (XSDElementDeclaration)elementIt.next();
                if (!xsdElement.getSchema().equals(schema)) continue;
                keepElements.add(xsdElement);
            }
            this.createXSDComponentObjects(list, keepElements, tagPath);
        }
    }

    private void createXSDInlineWrapperTypeObjects(IComponentList list, QualifiedName tagPath) {
        if (this.definition.getETypes() == null) {
            return;
        }
        Iterator inlineSchemasIt = this.definition.getETypes().getSchemas().iterator();
        while (inlineSchemasIt.hasNext()) {
            XSDSchema schema = (XSDSchema)inlineSchemasIt.next();
            if (schema.getTargetNamespace() != null && !schema.getTargetNamespace().equals("")) continue;
            ArrayList keepTypes = new ArrayList();
            ArrayList<XSDSchemaContent> imports = new ArrayList<XSDSchemaContent>();
            Iterator contents = schema.getContents().iterator();
            while (contents.hasNext()) {
                XSDSchemaContent content = (XSDSchemaContent)contents.next();
                if (!(content instanceof XSDImport)) continue;
                imports.add(content);
            }
            Iterator importIterator = imports.iterator();
            while (importIterator.hasNext()) {
                XSDImport importObject = (XSDImport)importIterator.next();
                XSDSchema importSchema = ((XSDImportImpl)importObject).importSchema();
                Iterator typesIt = importSchema.getTypeDefinitions().iterator();
                while (typesIt.hasNext()) {
                    Object typeObject = typesIt.next();
                    if (tagPath.equals((Object)"/schema/complexType") && typeObject instanceof XSDComplexTypeDefinition) {
                        keepTypes.add(typeObject);
                        continue;
                    }
                    if (!tagPath.equals((Object)"/schema/simpleType") || !(typeObject instanceof XSDSimpleTypeDefinition)) continue;
                    keepTypes.add(typeObject);
                }
            }
            this.createXSDComponentObjects(list, keepTypes, tagPath);
        }
    }

    private void createXSDInlineWrapperElementObjects(IComponentList list, QualifiedName tagPath) {
        if (this.definition.getETypes() == null) {
            return;
        }
        Iterator inlineSchemasIt = this.definition.getETypes().getSchemas().iterator();
        while (inlineSchemasIt.hasNext()) {
            XSDSchema schema = (XSDSchema)inlineSchemasIt.next();
            if (schema.getTargetNamespace() != null && !schema.getTargetNamespace().equals("")) continue;
            Iterator contents = schema.getContents().iterator();
            ArrayList<XSDSchemaContent> imports = new ArrayList<XSDSchemaContent>();
            while (contents.hasNext()) {
                XSDSchemaContent content = (XSDSchemaContent)contents.next();
                if (!(content instanceof XSDImport)) continue;
                imports.add(content);
            }
            Iterator importIterator = imports.iterator();
            while (importIterator.hasNext()) {
                XSDImport importObject = (XSDImport)importIterator.next();
                XSDSchema importSchema = ((XSDImportImpl)importObject).importSchema();
                this.createXSDComponentObjects(list, (List)importSchema.getElementDeclarations(), tagPath);
            }
        }
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public String getListTitle() {
        switch (this.kind) {
            case 0: {
                return WSDLEditorPlugin.getWSDLString("_UI_LABEL_MATCHING_BINDINGS");
            }
            case 11: {
                return WSDLEditorPlugin.getWSDLString("_UI_LABEL_MATCHING_PORTTYPES");
            }
            case 6: {
                return WSDLEditorPlugin.getWSDLString("_UI_LABEL_MATCHING_MESSAGES");
            }
            case 15: {
                return WSDLEditorPlugin.getWSDLString("_UI_LABEL_MATCHING_TYPES");
            }
            case 14: {
                return WSDLEditorPlugin.getWSDLString("_UI_LABEL_MATCHING_ELEMENTS");
            }
        }
        return null;
    }

    public String getNameFieldTitle() {
        switch (this.kind) {
            case 0: {
                return WSDLEditorPlugin.getWSDLString("_UI_LABEL_BINDING_NAME");
            }
            case 11: {
                return WSDLEditorPlugin.getWSDLString("_UI_LABEL_PORTTYPE_NAME");
            }
            case 6: {
                return WSDLEditorPlugin.getWSDLString("_UI_LABEL_MESSAGE_NAME");
            }
            case 15: {
                return WSDLEditorPlugin.getWSDLString("_UI_LABEL_TYPE_NAME");
            }
            case 14: {
                return WSDLEditorPlugin.getWSDLString("_UI_LABEL_ELEMENT_NAME");
            }
        }
        return null;
    }

    public class WSDLComponentLabelProvider
    extends XMLComponentSelectionProvider.XMLComponentSelectionLabelProvider {
        public WSDLComponentLabelProvider() {
            super((XMLComponentSelectionProvider)WSDLComponentSelectionProvider.this);
        }

        public Image getImage(Object element) {
            XMLComponentSelectionProvider.XMLComponentTreeObject specification = (XMLComponentSelectionProvider.XMLComponentTreeObject)element;
            XMLComponentSpecification spec = (XMLComponentSpecification)specification.getXMLComponentSpecification().get(0);
            if (spec.getMetaName() == IWSDLSearchConstants.BINDING_META_NAME) {
                return WSDLEditorPlugin.getInstance().getImage("icons/binding_obj.gif");
            }
            if (spec.getMetaName() == IWSDLSearchConstants.PORT_TYPE_META_NAME) {
                return WSDLEditorPlugin.getInstance().getImage("icons/portType_obj.gif");
            }
            if (spec.getMetaName() == IWSDLSearchConstants.MESSAGE_META_NAME) {
                return WSDLEditorPlugin.getInstance().getImage("icons/message_obj.gif");
            }
            if (spec.getMetaName() == IXSDSearchConstants.COMPLEX_TYPE_META_NAME) {
                return XSDEditorPlugin.getXSDImage((String)"icons/XSDComplexType.gif");
            }
            if (spec.getMetaName() == IXSDSearchConstants.SIMPLE_TYPE_META_NAME || spec.getMetaName() == null) {
                return XSDEditorPlugin.getXSDImage((String)"icons/XSDSimpleType.gif");
            }
            if (spec.getMetaName() == IXSDSearchConstants.ELEMENT_META_NAME) {
                return XSDEditorPlugin.getXSDImage((String)"icons/XSDElement.gif");
            }
            return null;
        }
    }
}

