/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.dialogs.types;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.ui.internal.actions.AddElementDeclarationAction;
import org.eclipse.wst.wsdl.ui.internal.actions.AddImportAction;
import org.eclipse.wst.wsdl.ui.internal.actions.AddWSISchemaImportAction;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xml.XMLComponentSpecification;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.w3c.dom.Element;

public class WSDLSetComponentHelper {
    private Definition definition;
    private IFile currentIFile;

    public WSDLSetComponentHelper(IFile iFile, Definition definition) {
        this.currentIFile = iFile;
        this.definition = definition;
    }

    public void setWSDLComponent(WSDLElement inputElement, String property, XMLComponentSpecification spec) {
        this.addImportIfNecessary(spec);
        String componentObject = this.getPrefixedComponentName(spec);
        Element wsdlElement = inputElement.getElement();
        wsdlElement.setAttribute(property, componentObject);
    }

    public void setXSDTypeComponent(Part part, XMLComponentSpecification spec) {
        if (spec.getMetaName() != null) {
            this.addImportIfNecessary(spec);
        }
        String componentObject = this.getPrefixedComponentName(spec);
        ComponentReferenceUtil.setComponentReference(part, true, componentObject);
    }

    public void setXSDElementComponent(Part part, XMLComponentSpecification spec) {
        this.addImportIfNecessary(spec);
        String componentObject = this.getPrefixedComponentName(spec);
        ComponentReferenceUtil.setComponentReference(part, false, componentObject);
    }

    public String getPrefixedComponentName(XMLComponentSpecification spec) {
        String name = (String)spec.getAttributeInfo((Object)"name");
        List prefixes = this.getPrefixes(this.definition, spec.getTargetNamespace());
        if (prefixes.size() > 0) {
            name = prefixes.get(0) + ":" + name;
        }
        return name;
    }

    private List getPrefixes(Definition definition, String namespace) {
        ArrayList<String> list = new ArrayList<String>();
        Map map = definition.getNamespaces();
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            String theNamespace = (String)map.get(prefix);
            if (theNamespace == null || !theNamespace.equals(namespace)) continue;
            list.add(prefix);
        }
        return list;
    }

    private void addImportIfNecessary(XMLComponentSpecification spec) {
        XSDSchema schema;
        Import importItem;
        boolean foundMatch = false;
        String currentFileLocation = this.currentIFile.getLocation().toString();
        if (currentFileLocation.equals(spec.getFileLocation())) {
            foundMatch = true;
        }
        if (!foundMatch) {
            Iterator importsIt = this.definition.getEImports().iterator();
            while (importsIt.hasNext()) {
                String importLocation = "";
                importItem = (Import)importsIt.next();
                if (importItem.getESchema() != null) {
                    schema = importItem.getESchema();
                    importLocation = this.getNormalizedLocation(schema.getSchemaLocation());
                } else {
                    Definition importDefinition = importItem.getEDefinition();
                    importLocation = this.getNormalizedLocation(importDefinition.getLocation());
                }
                if (!importLocation.equals(spec.getFileLocation())) continue;
                foundMatch = true;
                break;
            }
        }
        if (!foundMatch) {
            ArrayList<XSDSchemaContent> imports = new ArrayList<XSDSchemaContent>();
            if (this.definition.getETypes() != null) {
                Iterator it = this.definition.getETypes().getEExtensibilityElements().iterator();
                while (it.hasNext()) {
                    XSDSchemaExtensibilityElement eeElement = (XSDSchemaExtensibilityElement)it.next();
                    schema = eeElement.getSchema();
                    if (schema.getTargetNamespace() != null && !schema.getTargetNamespace().equals("")) continue;
                    Iterator contents = schema.getContents().iterator();
                    while (contents.hasNext()) {
                        XSDSchemaContent content = (XSDSchemaContent)contents.next();
                        if (!(content instanceof XSDImport)) continue;
                        imports.add(content);
                    }
                }
            }
            Iterator importIt = imports.iterator();
            while (importIt.hasNext()) {
                importItem = (XSDImport)importIt.next();
                XSDSchema resolvedSchema = importItem.getResolvedSchema();
                String resolvedString = resolvedSchema.getSchemaLocation();
                String importLocation = this.getNormalizedLocation(resolvedString);
                if (!importLocation.equals(spec.getFileLocation())) continue;
                foundMatch = true;
                break;
            }
        }
        if (!foundMatch) {
            boolean wsiStyleImport = this.isXSDSchemaFile(spec);
            if (wsiStyleImport) {
                AddElementDeclarationAction action = new AddElementDeclarationAction(this.definition, spec.getTargetNamespace(), "xsd");
                action.run();
                String location = URIHelper.getRelativeURI((IPath)new Path(spec.getFileLocation()), (IPath)this.currentIFile.getLocation());
                AddWSISchemaImportAction addImport = new AddWSISchemaImportAction(this.definition, spec.getTargetNamespace(), location);
                addImport.run();
            } else {
                String newSelectedFileLoc = spec.getFileLocation();
                String currentFileLoc = this.getNormalizedLocation(this.definition.getLocation());
                String relativeLoc = ComponentReferenceUtil.computeRelativeURI(newSelectedFileLoc, currentFileLoc, true);
                Element definitionElement = WSDLEditorUtil.getInstance().getElementForObject(this.definition);
                String prefix = this.definition.getPrefix("http://schemas.xmlsoap.org/wsdl/");
                String namespace = spec.getTargetNamespace();
                AddImportAction addImportAction = new AddImportAction(null, this.definition, definitionElement, prefix, namespace, relativeLoc);
                addImportAction.run();
                String uniquePrefix = this.getUniquePrefix(this.definition, prefix);
                definitionElement.setAttribute("xmlns:" + uniquePrefix, namespace);
            }
        }
    }

    private boolean isXSDSchemaFile(XMLComponentSpecification spec) {
        String extension;
        String fileLocation = spec.getFileLocation();
        int periodIndex = fileLocation.lastIndexOf(".");
        return periodIndex > 0 && (extension = fileLocation.substring(periodIndex + 1)).equalsIgnoreCase("xsd");
    }

    private String getUniquePrefix(Definition definition, String initPrefix) {
        String uniquePrefix;
        Map map = definition.getNamespaces();
        if (definition.getNamespace(initPrefix) == null) {
            uniquePrefix = initPrefix;
        } else {
            String tempPrefix = initPrefix;
            int i = 1;
            while (map.containsKey(String.valueOf(tempPrefix) + i)) {
                ++i;
            }
            uniquePrefix = String.valueOf(tempPrefix) + i;
        }
        return uniquePrefix;
    }

    private String getNormalizedLocation(String location) {
        try {
            URL url = new URL(location);
            URL resolvedURL = Platform.resolve((URL)url);
            location = resolvedURL.getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return location;
    }
}

