/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.extension;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditor;
import org.eclipse.wst.wsdl.ui.internal.extension.WSDLEditorExtension;

public class WSDLEditorExtensionRegistry {
    protected List registeredExtensionList = new ArrayList();

    public WSDLEditorExtensionRegistry() {
        this.add(new WSDLEditor.BuiltInWSDLEditorExtension());
    }

    public List getRegisteredExtensions() {
        return this.registeredExtensionList;
    }

    public WSDLEditorExtension getApplicableExtension(int type, Object object) {
        WSDLEditorExtension result = null;
        Iterator i = this.getRegisteredExtensions().iterator();
        while (i.hasNext()) {
            WSDLEditorExtension extension = (WSDLEditorExtension)i.next();
            if (!extension.isExtensionTypeSupported(type) || !extension.isApplicable(object)) continue;
            result = extension;
            break;
        }
        return result;
    }

    public WSDLEditorExtension[] getRegisteredExtensions(int type) {
        ArrayList<WSDLEditorExtension> list = new ArrayList<WSDLEditorExtension>();
        Iterator i = this.getRegisteredExtensions().iterator();
        while (i.hasNext()) {
            WSDLEditorExtension extension = (WSDLEditorExtension)i.next();
            if (!extension.isExtensionTypeSupported(type)) continue;
            list.add(extension);
        }
        WSDLEditorExtension[] result = new WSDLEditorExtension[list.size()];
        int count = 0;
        Iterator i2 = list.iterator();
        while (i2.hasNext()) {
            WSDLEditorExtension extension;
            result[count] = extension = (WSDLEditorExtension)i2.next();
            ++count;
        }
        return result;
    }

    public void addAsFirst(WSDLEditorExtension extension) {
        this.getRegisteredExtensions().add(0, extension);
    }

    public void add(WSDLEditorExtension extension) {
        this.getRegisteredExtensions().add(extension);
    }

    public void add(ClassLoader classLoader, String className) {
        try {
            Class<?> theClass = classLoader != null ? classLoader.loadClass(className) : Class.forName(className);
            WSDLEditorExtension extension = (WSDLEditorExtension)theClass.newInstance();
            this.registeredExtensionList.add(extension);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

