/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.gef.util.editparts;

import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.wst.wsdl.ui.internal.gef.util.figures.Interactor;
import org.eclipse.wst.xsd.ui.internal.gef.util.figures.IExpandable;

public class InteractorHelper
implements MouseListener {
    protected boolean needToPerformDefaultExpansion = true;
    protected EditPart editPart;
    protected Interactor interactor;
    protected IExpandable expandable;

    public InteractorHelper(EditPart editPart, Interactor interactor, IExpandable expandable) {
        this.editPart = editPart;
        this.interactor = interactor;
        this.expandable = expandable;
        interactor.addMouseListener(this);
        expandable.setExpanded(interactor.isExpanded());
    }

    public void setExpanded(boolean isExpanded) {
        this.interactor.setExpanded(isExpanded);
        this.interactorExpansionChanged(isExpanded);
    }

    protected void interactorExpansionChanged(boolean isInteractorExpanded) {
        this.expandable.setExpanded(isInteractorExpanded);
        this.expandable.setVisible(isInteractorExpanded);
        this.editPart.refresh();
        RootEditPart root = this.editPart.getRoot();
        if (root instanceof AbstractGraphicalEditPart) {
            IFigure rootFigure = ((AbstractGraphicalEditPart)root).getFigure();
            this.invalidateAll(rootFigure);
            rootFigure.validate();
            rootFigure.repaint();
        }
    }

    protected void invalidateAll(IFigure figure) {
        figure.invalidate();
        LayoutManager manager = figure.getLayoutManager();
        if (manager != null) {
            manager.invalidate();
        }
        Iterator i = figure.getChildren().iterator();
        while (i.hasNext()) {
            IFigure child = (IFigure)i.next();
            this.invalidateAll(child);
        }
    }

    public void mouseDoubleClicked(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
        boolean newExpansionState = !this.interactor.isExpanded();
        this.interactor.setExpanded(newExpansionState);
        this.interactorExpansionChanged(newExpansionState);
    }

    public void mouseReleased(MouseEvent me) {
    }
}

