/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.graph;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Widget;

public class FigureCanvasKeyboardHandler
extends KeyAdapter {
    public static final int H_SCROLL_INCREMENT = 5;
    public static final int V_SCROLL_INCREMENT = 30;

    public void keyPressed(KeyEvent e) {
        Widget w = e.widget;
        if (w instanceof FigureCanvas) {
            this.processKey(e.keyCode, (FigureCanvas)w);
        }
    }

    private void processKey(int keyCode, FigureCanvas figureCanvas) {
        switch (keyCode) {
            case 0x1000002: {
                this.scrollVertical(figureCanvas, false);
                break;
            }
            case 0x1000001: {
                this.scrollVertical(figureCanvas, true);
                break;
            }
            case 0x1000003: {
                this.scrollHorizontal(figureCanvas, true);
                break;
            }
            case 0x1000004: {
                this.scrollHorizontal(figureCanvas, false);
                break;
            }
            case 0x1000005: {
                this.scrollPage(figureCanvas, true);
                break;
            }
            case 0x1000006: {
                this.scrollPage(figureCanvas, false);
            }
        }
    }

    private int verifyScrollBarOffset(RangeModel model, int value) {
        value = Math.max(model.getMinimum(), value);
        return Math.min(model.getMaximum() - model.getExtent(), value);
    }

    private void scrollVertical(FigureCanvas figureCanvas, boolean up) {
        Point location = figureCanvas.getViewport().getViewLocation();
        int vOffset = up ? -30 : 30;
        int x = this.verifyScrollBarOffset(figureCanvas.getViewport().getHorizontalRangeModel(), location.x);
        int y = this.verifyScrollBarOffset(figureCanvas.getViewport().getVerticalRangeModel(), location.y + vOffset);
        figureCanvas.scrollSmoothTo(x, y);
    }

    private void scrollHorizontal(FigureCanvas figureCanvas, boolean left) {
        Point location = figureCanvas.getViewport().getViewLocation();
        int hOffset = left ? -5 : 5;
        int x = this.verifyScrollBarOffset(figureCanvas.getViewport().getHorizontalRangeModel(), location.x + hOffset);
        int y = this.verifyScrollBarOffset(figureCanvas.getViewport().getVerticalRangeModel(), location.y);
        figureCanvas.scrollSmoothTo(x, y);
    }

    private void scrollPage(FigureCanvas figureCanvas, boolean up) {
        Rectangle clientArea = figureCanvas.getClientArea();
        int increment = up ? -clientArea.height : clientArea.height;
        Point location = figureCanvas.getViewport().getViewLocation();
        int x = this.verifyScrollBarOffset(figureCanvas.getViewport().getHorizontalRangeModel(), location.x);
        int y = this.verifyScrollBarOffset(figureCanvas.getViewport().getVerticalRangeModel(), location.y + increment);
        figureCanvas.scrollSmoothTo(x, y);
    }
}

